/* indent:4  tabsize:8  font:fixed-width */

#import "TenpileModel.h"
#import "localstrings.h"
#import "TenpileTempLogic.h"
#import "TenpileSuitLogic.h"
#import "TenpileGameLogic.h"
#import <Foundation/NSUserDefaults.h>
#import <Foundation/NSString.h>
#import <Solitaire/CardPile.h>
#import <Solitaire/CardPileHolder.h>

@implementation TenpileModel

- init
{
    int 	pileIndex ;
    id gameLogic = [[TenpileGameLogic alloc] init];
    id tempLogic = [[TenpileTempLogic alloc] init];
    id suitLogic = [[TenpileSuitLogic alloc] init];
    [super init];
    [gameLogic setGameModel:self];
    [tempLogic setGameModel:self];
    [suitLogic setGameModel:self];
    //-----------------------------------------------------------------------
    //    Initialize the "suit piles"
    //    Initialize the "temp piles"
    //-----------------------------------------------------------------------

    for (pileIndex = 0; pileIndex < 4; pileIndex++)
    {
        suitPileHolders[pileIndex] = [[CardPileHolder alloc] initWithModel:self logic:suitLogic];
        tempPileHolders[pileIndex] = [[CardPileHolder alloc] initWithModel:self logic:tempLogic];
    }
    //    Initialize the 10 "user piles" or "game piles"
    for (pileIndex = 0; pileIndex < 10; pileIndex++)
    {
        gamePileHolders[pileIndex] = [[CardPileHolder alloc] initWithModel:self logic:gameLogic];
    }

    [self newGame];
    [gameLogic release];
    [tempLogic release];
    [suitLogic release];

    return self;
}

- (void)dealloc
{
    int i = 0;
    for(i = 0; i < 4 ; i++ ) {
        [suitPileHolders[i] release];
        [tempPileHolders[i] release];
    }
    for(i = 0; i < 10 ; i++ ) {
        [gamePileHolders[i] release];
    }
    [super dealloc];
}

- (void)setupGameUsingDeal:(CardPile*)deal
    /*" Setup a new using this specified Deal. "*/
{
    int 	hiddenCards = [[NSUserDefaults standardUserDefaults] integerForKey:@"HiddenCards"];
    int cycle, pileIndex;

    // first be sure that all pile are empty.
    for (pileIndex = 0; pileIndex < 10; pileIndex++)
    {
        [gamePileHolders[pileIndex] empty];
        if(pileIndex < 4 ) {
            [suitPileHolders[pileIndex] empty];
            [tempPileHolders[pileIndex] empty];
        }
    }

    for (cycle = 0; cycle < 5; cycle++)
    {
        for (pileIndex = 0; pileIndex < 10; pileIndex++)
        {
            [deal dealLastObjectTo:gamePileHolders[pileIndex]];
            if (cycle >= hiddenCards)
                [[gamePileHolders[pileIndex] lastObject] flip];
        }
    }
    for (pileIndex = 0; pileIndex < 2; pileIndex++)
    {
        [deal dealLastObjectFaceUpTo:tempPileHolders[pileIndex]];
    }
    [super setupGameUsingDeal:deal];
}

- (CardPileHolder**)gamePileHolders
{
    return gamePileHolders;
}

- (CardPileHolder**)suitPileHolders
{
    return suitPileHolders;
}

- (CardPileHolder**)tempPileHolders
{
    return tempPileHolders;
}


- (BOOL) isWinning
/*"    Called to check the state of the game.  Always override (unless your
       game is impossible to win).
"*/{
    return ([suitPileHolders[0] count] +
            [suitPileHolders[1] count] +
            [suitPileHolders[2] count] +
            [suitPileHolders[3] count] == 52);
}

- (id) initWithCoder:(NSCoder *)aDecoder
    /*"
    Unarchives a GameModel instance. archive the state of all pileHolders
     "*/
{
    int i = 0;
    [super initWithCoder:aDecoder];

    for(i = 0 ; i < 4 ; i++) {
        suitPileHolders[i] = [[aDecoder decodeObject] retain];
        tempPileHolders[i] = [[aDecoder decodeObject] retain];
    }
    for(i = 0 ; i < 10 ; i++) {
        gamePileHolders[i] = [[aDecoder decodeObject] retain];
    }
    return self;
}

- (void) encodeWithCoder:(NSCoder *)aCoder
    /*"
    Archives a GameModel instance.  Unarchive the state of all pileHolders
     "*/
{
    int i = 0;
    [super encodeWithCoder:aCoder];

    for(i = 0 ; i < 4 ; i++) {
        [aCoder encodeObject:suitPileHolders[i]];
        [aCoder encodeObject:tempPileHolders[i]];
    }
    for(i = 0 ; i < 10 ; i++ ) {
        [aCoder encodeObject:gamePileHolders[i]];
    }
}

@end
