/* indent:4  tabsize:8  font:fixed-width */

#import "TenpileGameLogic.h"
#import "TenpileSuitLogic.h"
#import "TenpileModel.h"
#import <Solitaire/CardPile.h>
#import <Solitaire/CardPileHolder.h>

#import "TenpileModel.h"

@implementation TenpileGameLogic

- (void) clickedCard:(CardPile*)aCard in:(CardPileHolder*)aCardPileHolder
{
    if ((aCard == [aCardPileHolder lastObject]) && (![aCard isFaceUp]))
    {
        [aCard flip];
    } 
}


- (void) doubleClickedCard:(CardPile*)aCard in:(CardPileHolder*)aCardPileHolder
{
    int i;

    if (([aCard count] ==1) && (![aCard isFaceUp]))
    {
        [aCard flip];
    }
    else if ([aCard count] ==1)
    {
        id* suitHlds = [(TenpileModel*)gameModel suitPileHolders];
        for (i = 0; i < 4; i++)
        {
            if ([suitHlds[i] canAcceptPile:aCard
                                      from:aCardPileHolder
                                        in:suitHlds[i]])
            {
                [aCardPileHolder dealLastObjectTo:suitHlds[i]];
                [gameModel checkForWin];

                break;
            }
        }
    } 
}


- (BOOL) draggedPile:(CardPile*)aCardPile from:(CardPileHolder*)aCardPileHolder
/*"
    You can move piles of cards if you have enough free tempoary spaces to perform the same operation by moving the cards to the temporary spaces, moving the selected card and moving the cards on the temporary spaces below the selected card.
"*/
{
    int 		i;

    if ([aCardPile isFaceUp])
    {
        int allowed = 1;
        id* tempHlds = [(TenpileModel*)gameModel tempPileHolders];
	/* Can only drag if all cards above are alternating color and in
	   descending sequence */
        if(!([aCardPile isAllNextInDecreasingCardValue] && [aCardPile isAllNextInAlternateColor])) {
            return NO;
        }

        /* Count number of empty temporary piles.  */
        for (i = 0; i < 4; i++)
            if ([tempHlds[i] count] == 0)
                allowed++;


        if ( [aCardPile count] <= allowed )
            return YES;
    }
    return NO;
}


- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(CardPileHolder*)aCardPileHolder
{
    CardPile* targetCard = [aCardPileHolder lastObject];

    if (targetCard)
    {
        if (([targetCard isFaceUp]) &&
            ([targetCard cardColor] != [aCardPile cardColor]) &&
            ([targetCard cardValue] == [aCardPile cardValue] + 1))
        {
            return YES;
        }
    }
    else
    {
        if ([aCardPile cardValue] == CS_KING)
        {
            return YES;
        }
    }
    return NO;
}

@end

