/* indent:4  tabsize:8  font:fixed-width */

#import "PyramidPrefs.h"


@implementation PyramidPrefs

/*---------------------------------------------------------------------------
|
|    - registerPrefs
|
|----------------------------------------------------------------------------
|
|    Register the preferences for this game.  Called automatically.
|			
\---------------------------------------------------------------------------*/

- (void) registerPrefs
{
    NSDictionary * defaultsDict;

    defaultsDict = [NSDictionary dictionaryWithObjects:[NSArray arrayWithObject:@"0"]	forKeys:[NSArray arrayWithObject:@"Score"]];

    [[NSUserDefaults standardUserDefaults] registerDefaults:defaultsDict];

    theScore = [[NSUserDefaults standardUserDefaults] integerForKey:@"Score"];
    [[score cellAtIndex:0] setStringValue:	
	[NSString stringWithFormat:@"%d", theScore]];
}


/*---------------------------------------------------------------------------
|
|    - pyramidScore
|
|    returns: (int) the current score
|
|----------------------------------------------------------------------------
|
|    Return the current score.
|			
\---------------------------------------------------------------------------*/

- (int) pyramidScore
{
    return theScore;
}

/*---------------------------------------------------------------------------
|
|    - setPyramidScore:(int)aScore
|
|----------------------------------------------------------------------------
|
|    Set the current score.
|			
\---------------------------------------------------------------------------*/
- (void) setPyramidScore:(int)aScore
{
    [[NSUserDefaults standardUserDefaults] setInteger:theScore forKey:@"Score"];
    [[score cellAtIndex:0] setStringValue:[NSString stringWithFormat:@"%d", theScore]];
}

- (void) resetScore:sender
{
    [self setPyramidScore:0]; 
}

@end

