/* indent:4  tabsize:8  font:fixed-width */

/*---------------------------------------------------------------------------
|----------------------------------------------------------------------------
|
|    Pyramid:GameModule
|
|    Pyramid solitaire module.
|
|    CREDITS
|
|    Gary Ritchie<gary@uaneuro.uah.ualberta.ca>
|        -- design, implementation, documentation
|
|----------------------------------------------------------------------------
\---------------------------------------------------------------------------*/

#import <Solitaire/GameModel.h>

@class CardPileHolder;

@interface PyramidModel : GameModel
{
    id gamePileHolders[28];
    id stockPileHolder;
    id wastePileHolder;
    id discardPileHolders[2];

    int dealCount;              // number of passes through the stock pile
                                // "1" indicates we are on the first pass
    BOOL gameInProgress;        // TRUE unless user has won/lost game
    BOOL pyramidEmpty;
}

/*" Game specific "*/

- (int) dealCount;
- (void) setDealCount:(int)count;
- (void) incDealCount;
- (void) determineScore;

- (CardPileHolder*)wastePileHolder;
- (CardPileHolder*)stockPileHolder;
- (CardPileHolder**)discardPileHolders;
- (CardPileHolder**)gamePileHolders;

@end

