/* indent:4  tabsize:8  font:fixed-width */

#import "PyramidGameLogic.h"
#import <Solitaire/CardSet.h>
#import <Solitaire/CoveredListHolder.h>
#import "PyramidModel.h"


@implementation PyramidGameLogic

- (BOOL) draggedPile:(CardPile*)aCardPile from:(ListHolder*)gameCardPileHolder
{
    /*-----------------------------------------------------------------------
     * Dragging is only allowed if the pile is not covered.
     *-----------------------------------------------------------------------*/
    if ([(CoveredListHolder*)gameCardPileHolder pileCovered:self])
        return NO;
    else
        return YES;
}

- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(ListHolder*)gameCardPileHolder
{
    CardPile* card1 = [aCardPile lastObject];
    CardPile* card2 = [gameCardPileHolder lastObject];

    /*-----------------------------------------------------------------------
    |	Can only accept a card if this pile is not covered by
    |	others, and the two cards add to 13.
    \----------------------------------------------------------------------*/
    if (![(CoveredListHolder*)gameCardPileHolder pileCovered:sender])
    {
#warning  #define PYRAMID_CHEAT_CHEAT_CHEAT  if you want to cheat !
#ifndef PYRAMID_CHEAT_CHEAT_CHEAT
	if (card1 && card2)
	{
	    if (([card1 cardValue] + [card2 cardValue]) == 11)
		return YES;
	}
#else
    return YES;
#endif

    }
    return NO;
}

- (void) acceptPile:(CardPile*)aCardPile in:(ListHolder*)gameCardPileHolder
/*"Called by a GamePileCardView after cards have been successfully
    added to the pile as a result of cards being dropped on it.
"*/
{
    /*-----------------------------------------------------------------------
    |	Remove both cards from the game pile, and move
    |	them to the match piles.
    \------------------------------------------------------------------------*/
    id *disHlds = [(PyramidModel*)gameModel discardPileHolders];

    [gameCardPileHolder dealLastObjectTo:disHlds[0]];
    [gameCardPileHolder dealLastObjectTo:disHlds[1]];

    [gameModel checkForWin]; 
}

- (void) doubleClickedCard:(CardPile*)aCard in:(ListHolder*)holder
    /*"Double clicked on a card; discard if it is a King."*/
{
    if (aCard && (aCard == [holder lastObject]) && [aCard cardValue] == CS_KING)
    {
        id *disHlds = [(PyramidModel*)gameModel discardPileHolders];
        [holder dealLastObjectTo:disHlds[0]];
        [gameModel checkForWin];
    } 
}

@end

