/* indent:4  tabsize:8  font:fixed-width */

#import "KlondikePrefs.h"

@implementation KlondikePrefs


/*---------------------------------------------------------------------------
|
|    - registerPrefs
|
|----------------------------------------------------------------------------
|
|    Register the preferences for this game.  Called automatically.
|			
\---------------------------------------------------------------------------*/

- (void) registerPrefs
{
    NSDictionary* defaultsDict;

    defaultsDict = [NSDictionary dictionaryWithObjects:[NSArray arrayWithObject:@"3"] forKeys:[NSArray arrayWithObject:@"CardsToDraw"]];

    [[NSUserDefaults standardUserDefaults] registerDefaults:defaultsDict];
    
    cardsToDraw = [[NSUserDefaults standardUserDefaults] integerForKey:@"CardsToDraw"];
    [cardsToDrawMatrix selectCellWithTag:cardsToDraw];
}


/*---------------------------------------------------------------------------
|
|    - saveCardsToDraw:sender
|
|----------------------------------------------------------------------------
|
|    Save "CardsToDraw" preference.
|			
\---------------------------------------------------------------------------*/

- (void) saveCardsToDraw:sender
{
    cardsToDraw = [[cardsToDrawMatrix selectedCell] tag];
    [[NSUserDefaults standardUserDefaults] setInteger:[self cardsToDraw] forKey:@"CardsToDraw"]; 
}


/*---------------------------------------------------------------------------
|
|    - cardsToDraw:sender
|
|----------------------------------------------------------------------------
|
|    Return "CardsToDraw" preference.
|			
\---------------------------------------------------------------------------*/

- (int) cardsToDraw
{
    return cardsToDraw;
}

@end

