/* indent:4  tabsize:8  font:fixed-width */

#import "KlondikeGameLogic.h"
#import "KlondikeSuitLogic.h"
#import "KlondikeModel.h"
#import <Solitaire/Card.h>
#import <Solitaire/CardPile.h>
#import <Solitaire/CardImager.h>
#import <Solitaire/CardPileHolder.h>

@implementation KlondikeGameLogic

- (void) clickedCard:(CardPile*)aCard in:(CardPileHolder*)aCardPileHolder
{
    if (([aCard count] == 1) && (![aCard isFaceUp])) {
        [aCard flip];
    } 
}

- (void) doubleClickedCard:(CardPile*)aCard in:(CardPileHolder*)aCardPileHolder
{
    int i;
    
    if (([aCard count] == 1) && (![aCard isFaceUp]))
    {
        [aCard flip];
    }
    else if (aCard == [aCardPileHolder lastObject])
    {
        CardPileHolder** suitHlds = [[self gameModel] suitPileHolders];
        for (i=0; i<4; i++)
        {
	  if ([suitHlds[i] canAcceptPile:aCard
                                    from:aCardPileHolder
                                      in:suitHlds[i]])
            {
                [aCardPileHolder dealLastObjectTo:suitHlds[i]];
                [[aCardPileHolder lastObject] setFaceUp:YES];
                [[self gameModel] checkForWin];
                break;
            }
        }
    } 
}

- (BOOL) draggedPile:(CardPile*)aCardPile from:(CardPileHolder*)cardHolder
{
    if([aCardPile isAllNextInDecreasingCardValue] && [aCardPile isAllNextInAlternateColor]) {
        return YES;
    }
    return NO;
}

- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(CardPileHolder*)aCardPileHolder
{
    CardPile* targetCard = [aCardPileHolder lastObject];
    
    if (targetCard)
    {
        if (([targetCard isFaceUp]) &&
            ([targetCard cardColor] != [aCardPile cardColor]) &&
            ([targetCard cardValue] == [aCardPile cardValue] + 1))
        {
            return YES;
        }
    }
    else
    {
        if ([aCardPile cardValue] == CS_KING)
        {
            return YES;
        }
    }
    return NO;
}

@end

