/* indent:4  tabsize:8  font:fixed-width */

#import "FreezeLSuitLogic.h"
#import "FreezeLModel.h"
#import <Solitaire/CardPileHolder.h>
#import <Solitaire/CardPile.h>

@implementation FreezeLSuitLogic

- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(CardPileHolder*)aCardPileHolder
{
    CardPile*	targetCard = [aCardPileHolder lastObject];

    if ([aCardPile count] != 1)
      {
        return NO;
      }

    if (targetCard)
      {
        if (([aCardPile cardSuit] == [targetCard cardSuit]) &&
            ([aCardPile cardValue] == [targetCard cardValue] + 1))
          {
            return YES;
          }
      } else if ([aCardPile cardValue] == CS_ACE)
        {
          return YES;
        }

    return NO;
}


- (void) acceptPile:(CardPile*)aCardPile in:(CardPileHolder*)aCardPileHolder
{
    [[self gameModel] moveSuitableCards];
}

@end
