/* indent:4  tabsize:8  font:fixed-width */

#import "FreezeLGUI.h"
#import "FreezeLModel.h"
#import "localstrings.h"
#import <Solitaire/CardPileHolder.h>
#import <Solitaire/CardPileView.h>
#import <Solitaire/CardImager.h>
#import <AppKit/NSWindow.h>

@implementation FreezeLGUI

- (void)setupGame
{
    int 		i;
    CardPileView*  	views[8];
    CardPileHolder**	suitModel = [model suitPileHolders];
    CardPileHolder**	gameModel = [model gamePileHolders];
    CardPileHolder**	tempModel = [model tempPileHolders];

    [gameWindow disableFlushWindow];

    //   Connect model with views

    views[0] = suitPileView1;
    views[1] = suitPileView2;
    views[2] = suitPileView3;
    views[3] = suitPileView4;
    for (i = 0; i < 4; i++)
    {
        [views[i] setModel:suitModel[i]];
    }

    views[0] = gamePileView1;
    views[1] = gamePileView2;
    views[2] = gamePileView3;
    views[3] = gamePileView4;
    views[4] = gamePileView5;
    views[5] = gamePileView6;
    views[6] = gamePileView7;
    views[7] = gamePileView8;
    for (i = 0; i < 8; i++)
    {
        [views[i] setModel:gameModel[i]];
        [views[i] setOffset:0.0 :[[views[i] cardImager] yTopSpace]];
    }

    views[0] = tempPileView1;
    views[1] = tempPileView2;
    views[2] = tempPileView3;
    views[3] = tempPileView4;
    for (i = 0; i < 4; i++)
      {
        [views[i] setModel:tempModel[i]];
      }

    [gameWindow display];
    [gameWindow enableFlushWindow];
    [gameWindow flushWindow];

    [gameWindow makeKeyAndOrderFront:self];
}

@end

