/* indent:4  tabsize:8  font:fixed-width */

#import "FortyThievesModel.h"
#import "localstrings.h"
#import "FTDrawLogic.h"
#import "FTDiscardLogic.h"
#import "FTSuitLogic.h"
#import "FTGameLogic.h"
#import <Solitaire/LinkList.h>

@implementation FortyThievesModel

- init
/*"
    Setup a new game.  If "redeal" is true, deal a new deck, otherwise
    use the same cards as the previous game.
"*/
{
    int i = 0;
    // create logic objects
    id gamePileLogic;
    id suitPileLogic;
    id drawPileLogic;
    id discardPileLogic;
    [super init];
    gamePileLogic = [[FTGameLogic alloc] init];
    suitPileLogic = [[FTSuitLogic alloc] init];
    drawPileLogic = [[FTDrawLogic alloc] init];
    discardPileLogic = [[FTDiscardLogic alloc] init];

    [gamePileLogic setGameModel:self];
    [suitPileLogic setGameModel:self];
    [discardPileLogic setGameModel:self];
    [drawPileLogic setGameModel:self];

    // then create the gamePileHolders
    for(i = 0 ; i < 10 ; i++ ) {
        gamePileHolders[i] = [[CardPileHolder alloc] init];
        [gamePileHolders[i] setCardLogic:gamePileLogic];
        [gamePileHolders[i] setGameModel:self];
    }
    // then create the suitPileHolders
    for(i = 0 ; i < 8 ; i++ ) {
        suitPileHolders[i] = [[CardPileHolder alloc] init];
        [suitPileHolders[i] setCardLogic:suitPileLogic];
        [suitPileHolders[i] setGameModel:self];
    }
    drawPileHolder = [[CardPileHolder alloc] init];
    [drawPileHolder setCardLogic:drawPileLogic];
    [drawPileHolder setGameModel:self];

    discardPileHolder = [[CardPileHolder alloc] init];
    [discardPileHolder setCardLogic:discardPileLogic];
    [discardPileHolder setGameModel:self];

    [self newGame];
    [gamePileLogic release];
    [suitPileLogic release];
    [drawPileLogic release];
    [discardPileLogic release];

    return self;
}

- (void)dealloc
{
    int i = 0;
    [drawPileHolder release];
    [discardPileHolder release];
    for(i = 0; i < 8 ; i++ ) {
        [suitPileHolders[i] release];
    }
    for(i = 0; i < 10 ; i++ ) {
        [gamePileHolders[i] release];
    }
    [super dealloc];
}

-(id*) suitPileHolders
{
    return suitPileHolders;
}

- drawPileHolder
{
    return drawPileHolder;
}

-(id*) gamePileHolders
{
    return gamePileHolders;
}

- discardPileHolder
{
    return discardPileHolder;
}

- (CardPile*)createNewDeal
{
    id deal = [super doubleDeck];
    [deal shuffleValue];
    return deal;
}

- (void)setupGameUsingDeal:(CardPile*)deal
    /*" Setup a new using this specified Deal. "*/
{
    int		i, cycle;

    //-----------------------------------------------------------------------
    //    Initialize the "suit piles" and "temp piles" as empty
    //-----------------------------------------------------------------------

    for (i = 0; i < 8; i++)
    {
        [suitPileHolders[i] empty];
    }

    for (i = 0; i < 10; i++)
    {
        [gamePileHolders[i] empty];
    }

    [discardPileHolder empty];

    //-----------------------------------------------------------------------
    //    Initialize and deal cards to the 8 "user piles"
    //-----------------------------------------------------------------------

    [drawPileHolder setNextObject:deal];

    //-----------------------------------------------------------------------
    //    Initialize and deal cards to the 10 "user piles"
    //-----------------------------------------------------------------------

    for (cycle = 0; cycle < 4; cycle++)
    {
        for (i = 0; i < 10; i++)
        {
            [drawPileHolder dealLastObjectFaceUpTo:gamePileHolders[i]];
        }
    }
    [super setupGameUsingDeal:deal];
}

- (BOOL)isWinning
    /*"    Called to check the state of the game.  Always override (unless your game is impossible to win). "*/
{
    return ([suitPileHolders[0] count] +
            [suitPileHolders[1] count] +
            [suitPileHolders[2] count] +
            [suitPileHolders[3] count] +
            [suitPileHolders[4] count] +
            [suitPileHolders[5] count] +
            [suitPileHolders[6] count] +
            [suitPileHolders[7] count] == 104);
}

- (id) initWithCoder:(NSCoder *)aDecoder
    /*"
    Unarchives a GameModel instance. archive the state of all pileHolders
     "*/
{
    int i = 0;
    [super initWithCoder:aDecoder];

    for(i = 0 ; i< 10 ; i++) {
        gamePileHolders[i] = [[aDecoder decodeObject] retain];
    }
    for(i = 0 ; i < 8 ; i++) {
        suitPileHolders[i] = [[aDecoder decodeObject] retain];
    }
    drawPileHolder = [[aDecoder decodeObject] retain];
    discardPileHolder = [[aDecoder decodeObject] retain];

    return self;
}

- (void) encodeWithCoder:(NSCoder *)aCoder
    /*"
    Archives a GameModel instance.  Unarchive the state of all pileHolders
     "*/
{
    int i = 0;
    [super encodeWithCoder:aCoder];

    for(i = 0 ; i< 10 ; i++) {
        [aCoder encodeObject:gamePileHolders[i]];
    }
    for(i=0 ; i < 8 ; i++ ) {
        [aCoder encodeObject:suitPileHolders[i]];
    }
    [aCoder encodeObject:drawPileHolder];
    [aCoder encodeObject:discardPileHolder];
}

@end

