/* indent:4  tabsize:8  font:fixed-width */

#import "FortyThievesGUI.h"
#import "FortyThievesModel.h"
#import "localstrings.h"
#import "FTDrawLogic.h"
#import "FTSuitLogic.h"
#import "FTGameLogic.h"
#import "FTDiscardLogic.h"

#import <Solitaire/CardPile.h>
#import <Solitaire/CardImager.h>
#import <Solitaire/CardPileHolder.h>
#import <Solitaire/CardPileView.h>
#import <AppKit/NSApplication.h>
#import <AppKit/NSPanel.h>

@implementation FortyThievesGUI

/*The Controller is responsible to get the offset from the model.
       The #getOffset:: message allows the controller's model to control the amount of
       stagger that the deck has when it draws.  This method is rerouted to the card's logic to get the answer.
*/

- (void)dealloc
{
    [peekPanel release];
    [super dealloc];
}

- (void)setupGame
/*"    Setup a new game.  "*/
{
    int i;
    CardPileView*  suitCardPiles[8];
    CardPileView*  gameCardPiles[10];
    CardPileHolder** suitHlds = [model suitPileHolders];
    CardPileHolder** gameHlds = [model gamePileHolders];

    [gameWindow disableFlushWindow];

    //----------------------------------------------------------------
    //    Sync pile id's with current game window and set 
    //    preferences and delegates
    //----------------------------------------------------------------
    
    suitCardPiles[0] = suitPileView1;
    suitCardPiles[1] = suitPileView2;
    suitCardPiles[2] = suitPileView3;
    suitCardPiles[3] = suitPileView4;
    suitCardPiles[4] = suitPileView5;
    suitCardPiles[5] = suitPileView6;
    suitCardPiles[6] = suitPileView7;
    suitCardPiles[7] = suitPileView8;

    for (i = 0; i < 8; i++)
    {
        [suitCardPiles[i] setModel:suitHlds[i]];
    }

    gameCardPiles[0] = gamePileView1;
    gameCardPiles[1] = gamePileView2;
    gameCardPiles[2] = gamePileView3;
    gameCardPiles[3] = gamePileView4;
    gameCardPiles[4] = gamePileView5;
    gameCardPiles[5] = gamePileView6;
    gameCardPiles[6] = gamePileView7;
    gameCardPiles[7] = gamePileView8;
    gameCardPiles[8] = gamePileView9;
    gameCardPiles[9] = gamePileView10;
    for (i = 0; i < 10; i++)
    {
        [gameCardPiles[i] setModel:gameHlds[i]];
        [gameCardPiles[i] setOffset:0.0 :[[discardPileView cardImager] yTopSpace]];
    }

    [drawPileView setModel:[model drawPileHolder]];
    [discardPileView setModel:[model discardPileHolder]];
    [discardPileView setOffset:[[discardPileView cardImager] xTopSpace] :0.0];

    [gameWindow display];
    [gameWindow enableFlushWindow];
    [gameWindow flushWindow];

    [gameWindow makeKeyAndOrderFront:self]; 
}

- peekModel
{
    id m = [peekCardView model];
    if(m == nil) {
        m = [[CardPileHolder alloc] init];
        [peekCardView setModel:m];
        [m release];
    }
    return m;
}

- (void) peekAtNextCard:sender
{
    CardPileHolder* peekCardPile = [self  peekModel];
    CardPile* nextCard = [[[model drawPileHolder] lastObject] copy];
    [nextCard setFaceUp:YES];
    
    if(nextCard != nil) {
        [peekCardView setDrawOutline:NO];
        [peekCardPile empty];
        [peekCardPile appendObjects:nextCard];
        [peekCardView setModel:peekCardPile];
        [peekCardView display];
        [peekPanel makeKeyAndOrderFront:self];
        [NSApp runModalForWindow:peekPanel];
        [peekPanel orderOut:self];
        [nextCard release];
    }
    else{
        NSRunAlertPanel(LOCALIZED_GAME_NAME, LOCALIZED_NO_STOCK_CARD, @"OK", nil, nil);
    } 
}

- (void)peekOKButtonPressed:sender
{
        [NSApp stopModal];
}

@end

