/* indent:4  tabsize:8  font:fixed-width */

#import "FTDiscardLogic.h"
#import "FTSuitLogic.h"
#import "FortyThievesModel.h"

#import <Solitaire/CardPile.h>
#import <Solitaire/CardImager.h>
#import <Solitaire/CardPileHolder.h>

@implementation FTDiscardLogic

- (void) doubleClickedCard:(CardPile*)aCard in:(CardPileHolder*)aCardPileHolder
{
    int i;
    id	cardPile = aCardPileHolder;
    id* suitHlds = [(FortyThievesModel*)gameModel suitPileHolders];
    
    if ((aCard == [cardPile lastObject] ) && (![aCard isFaceUp]))
    {
	[aCard flip];
    }
    else if (aCard == [cardPile lastObject])
    {
	for (i=0;i<8;i++)
	{
            if ([suitHlds[i] canAcceptPile:aCard
                                      from:aCardPileHolder
                                        in:suitHlds[i]])
	    {
                [aCard moveAtLastOf:suitHlds[i]];
		[gameModel checkForWin];
		break;
	    }
	}
    } 
}

- (BOOL) draggedPile:(CardPile*)aCardPile from:(CardPileHolder*)discardCardPileView
    /*"Move only one card at a time"*/
{
    if ([aCardPile count] == 1)
    {
        return YES;
    }
    return NO;
}

@end
