/* SmallTiffCards.h created by veilljf on Wed 04-Nov-1998 */

#import <Foundation/Foundation.h>
#import "Card.h"
@class CardPile;
@class NSImage;


typedef enum _CardSize
{
    CS_SMALL = 0,
    CS_LARGE
} CardSize;

typedef enum _CardBack
{
    CS_DEFAULT = 0,
    CS_TRAD,
    CS_SHIP,
    CS_CUSTOM
} CardBack;


@interface TiffCardsImager : NSObject
{
    float hSpacer;
    float vSpacer;

    BOOL _preDrawnImagesAvailable;
    NSImage* cardCache[54];
    NSImage** backCache;
    NSDictionary *subImgCache;


    NSImage* _CardFrontImage;
    NSImage* _CardBackImage;
    NSImage* _CardSymbolsImage;
    NSImage* _CardKingClubsImage;
    NSImage* _CardKingDiamondsImage;
    NSImage* _CardKingHeartsImage;
    NSImage* _CardKingSpadesImage;
    NSImage* _CardQueenClubsImage;
    NSImage* _CardQueenDiamondsImage;
    NSImage* _CardQueenHeartsImage;
    NSImage* _CardQueenSpadesImage;
    NSImage* _CardJackClubsImage;
    NSImage* _CardJackDiamondsImage;
    NSImage* _CardJackHeartsImage;
    NSImage* _CardJackSpadesImage;
    NSImage* _CardAceOfSpadesImage;
}

- (void) drawCard:(CardPile*)card at:(NSPoint)thePoint;
- (void) drawOutlineOfCard:(CardPile*)card at:(NSPoint)thePoint;
- (void) drawContentsOfCard:(CardPile*)card at:(NSPoint)thePoint;

@end

@interface TiffCardsImager(private)

- subImagesDict;

- (void) cacheSubImages;

- (void) drawCardImages;
- (void) freeCardImages;

- (void) setCardBackImage:theImage;
- (void) setCardBack:(CardBack)aBack;


- (NSImage*)imageForSuit:(int)suit value:(int)value;
- (void) drawContentsForSuit:(CardSuit)suit
                       value:(CardValue)value
                      faceUp:(BOOL)faceUp
                          at:(NSPoint)thePoint;

@end
