/* indent:4  tabsize:8  font:fixed-width */

/*---------------------------------------------------------------------------
|----------------------------------------------------------------------------
|
|    GameModule : NSObject
|
|    Abstract superclass.  Game modules (.solitaire) must have a controller
|    which is a subclass of GameModule.
|
|----------------------------------------------------------------------------
\---------------------------------------------------------------------------*/


#import <Foundation/NSObject.h>

// Forward clss declarations
@class NSView;
@class NSWindow;
@class NSBundle;
@class NSString;
@class GamePref;
@class NSNotification;

#define IBOutlet

@interface GameModule : NSObject
{
    IBOutlet	NSView *	inspector;		/*" Our inspector view "*/
    IBOutlet	GamePref *	prefs;			/*" Game's preference object "*/
    IBOutlet	NSWindow *	rulesWindow;
    NSBundle *	bundle;	
    NSString *	gameName;	/*" Our bundle for this module "*/
    id	totalWinTextField;
    id	totalPlayedTextField;
}

/*" Initialization/deallocation "*/
- initFromBundle:(NSBundle*)aBundle withName:(NSString*)name;

/*" Our inspector "*/
- (NSView*) inspector:(id)sender;
- (void) inspectorWillBeRemoved;
- (void) inspectorInstalled;
- (void) showRules:(id)sender;

- (void)statisticChanged:(NSNotification*)notif;

/*" Starting/stopping play "*/
- (void) newGame:(id)sender;

@end

