/* PileController.m created by veilljf on Wed 04-Nov-1998 */

#import "ListHolder.h"
#import <Foundation/NSNotification.h>
#import <Foundation/NSException.h>
#import <Foundation/NSString.h>
#import <Foundation/NSCoder.h>

NSString* LINK_LIST_CHANGED = @"Linked_List_Changed";

@implementation ListHolder

/*" this class define an indirection level before the first element of the linked list.  This is used so we can append to the begining of the list without losing the pointer of the begining of the list.
"*/

- (void)dealloc
{
    [nextObject release];

    [super dealloc];
}


- nextObject
    /*" return the next object, usualy the rest of the list."*/
{
    return nextObject;
}

- (void)setNextObject:(id)no
    /*" set the rest of the list."*/
{
    if(no != nextObject) {
        if(no == self) {
            no = nil;
        // this can append, this code is not bug-free !
        }
        [nextObject release];
        nextObject = [no retain];

        // advise our new nextObject that somewone new is holding it.
        if ([no respondsToSelector:@selector(addedAsNextObjectFrom:)])
        {
            [no addedAsNextObjectFrom:self];
        }
    }
    [self changed];
}

- (void)addedAsNextObjectFrom:(ListHolder*)ho
/*_" this is a callback method used to show that "*/
{
    // do nothing when somewone decide to own us.
    // this is something a double linked subclass could implement to keep a pointer to the previous node
}

- (void)changed
    /*" Post the LINK_LIST_CHANGED notification."*/
{
    [[NSNotificationCenter defaultCenter]
            postNotificationName:LINK_LIST_CHANGED object:self];
}

- (unsigned)count
    /*" return the size of the list. return 0 if empty."*/
{
    return [[self firstObject] count];
}

- (void)empty
{
    [self setNextObject:nil];
}

- objectAtIndex:(unsigned)step
    /*"return the node object next step from me, empty or not."*/
{
    return (step == 0) ? self : [[self nextObject] objectAtIndex: step-1 ];
}

//- objectAtIndex:(unsigned)step
//    /*"return the node object next step from me, empty or not."*/
//{
//    return [[self nextObject] objectAtIndex: step];
//}

- (int)indexOfValue:va
    /*" return the index of the given value."*/
{
    return [[self nextObject] indexOfValue:va];
}

- (void)appendObjects:list
    /*" append the linked list to the last object."*/
{
    if([self nextObject] == nil) {
        [self setNextObject:list];
    } else {
        [[self nextObject] appendObjects:list];
    }
}

- firstObject
    /*" return the first node of the list"*/
{
    return [self nextObject];
}

- (void)addAsFirstObjects:(ListHolder*)l
    /*"add the list l to the begining of the current list."*/
{
    [l appendObjects:[self nextObject]];
    [self setNextObject:l];
}

- (ListHolder*)lastObject
    /*" return the last object of the list.  return nil if the list is empty"*/
{
    return [nextObject lastObject];
}

- (ListHolder*)holder
    /*" return the holder of the list.  Return nil, since we do not have holder"*/
{
    return nil;
}

- (ListHolder*)dealLastObject
    /*" return the last object, and remove it from the list. if self is the last object, then simply return it."*/
{
    id result = self;
    if ([nextObject nextObject] == nil) {
        result = nextObject;
        [result retain];
        [result autorelease];
        [self setNextObject:nil];
    } else {
        result = [nextObject dealLastObject];
    }
    return result;
}

- (unsigned)indexOfObject:obj
    /*" return the index from the current pile.

                EXCEPTION:
    raise an exception if the obj is not in the list."*/
{
    if(![obj isEqual:self]) {
        if(nextObject != nil) {
            return 1 + [[self nextObject] indexOfObject:obj];
        } else {
            [NSException raise:@"NOT_FOUND" format:@"Object not found: %@", obj];
        }
    }
    return 0;
}

- (void)dealLastObjectTo:(ListHolder*)dest
    /*" move the last object of the current list to the end of the destination list."*/
{
    id tpile = [self lastObject];
    [tpile moveAtLastOf:dest];
}

- (void)moveAtLastOf:(ListHolder*)list
    /*" Move the list at the end of the other list.  This method do not check for circular references !. "*/
{
    [list appendObjects:self];
}

/*"Copying"*/
- copyWithZone:(NSZone*)zone
    /*"Copy the node but not the value itself."*/
{
    id cpy = [[[self class] allocWithZone:zone] init];
    id nxt = [[self nextObject] copy];
    [cpy setNextObject:nxt];
    [nxt release];
    return cpy;
}

- (id) initWithCoder:(NSCoder *)aDecoder
/*"
   Unarchives a node instance.
"*/
{
    [self setNextObject:[[aDecoder decodeObject] retain]];
    return self;
}

- (void) encodeWithCoder:(NSCoder *)aCoder
/*"
   Archives a node instance.
"*/
{
    [aCoder encodeObject:nextObject];
}

@end
