/* indent:4  tabsize:8  font:fixed-width */

#import "CardSet.h"
#import "NSPasteboard-CardSet.h"


@implementation NSPasteboard(CardSet)

/*---------------------------------------------------------------------------
|
|    - writeType:(NSString *)dataType asObject:(id)anObject
|
|----------------------------------------------------------------------------
|
|    Perform gyrations necessary to archive an object to a stream and write 
|    the stream to the pasteboard. (It is a lot less gyrations under 
|    OpenStep)
|
\---------------------------------------------------------------------------*/

- (void)writeType:(NSString *)dataType asObject:(id)anObject
{
    [self setData:[NSArchiver archivedDataWithRootObject:anObject] 
	forType:dataType];
}


/*---------------------------------------------------------------------------
|
|    - readType:(NSString *) dataType asObject:(id) anObject
|
|----------------------------------------------------------------------------
|
|    Perform gyrations necessary to convert a pasteboard data type into a 
|    stream and dearchive an object from it
|
\----------------------------------------------------------------------------*/

- (void)readType:(NSString *)dataType asObject:(id *)anObjectPtr
{
    NSData *data;

    data = [self dataForType:dataType];
    *anObjectPtr = [NSUnarchiver unarchiveObjectWithData:data];
}

@end
