/* GameModel.h created by veilljf on Wed 02-Dec-1998 */

#import <Foundation/Foundation.h>



extern NSString * GAME_WIN;
extern NSString * STATISTIC_CHANGED;


@class NSUndoManager;
@class NSMutableDictionary;
@class CardPile;

@interface GameModel : NSObject
{
    NSUndoManager * undoManager;
}

- init;
- undoManager;
- (void)setUndoManager:(NSUndoManager*)um;

- (CardPile*)simpleDeck;
- (CardPile*)doubleDeck;
- (void)win;
- (void)checkForWin;
- (BOOL)isWinning;

- (CardPile*)createNewDeal;
- (void)setupGameUsingDeal:(CardPile*)deal;
- (NSString *)gamePrefWithName:(NSString *)prefName;

- (BOOL) hasBeenPlayed;
- (void) accumulateWin;
- (void) accumulatePlayed;
- (void) statisticsChanged;

- (void) newGame;
- (void)restartGame;

- (void)startGame;
- (void)endGame:notif;

- (id) initWithCoder:(NSCoder *)aDecoder;
- (void) encodeWithCoder:(NSCoder *)aCoder;

@end
