/* indent:4  tabsize:8  font:fixed-width */


/*--------------------------------------------------------------------------
| --------------------------------------------------------------------------
|
|    CardPile:NSObject
|
|    Instances of this class provide low-level functionality for card 
|    games.  CardPiles contain an ordered list of cards which can be added 
|    to, removed from or shuffled by clients of the class.
|
| ----------------------------------------------------------------------------
\---------------------------------------------------------------------------*/

#import "card-defs.h"
#import "DblLinkList.h"

#define    CS_BOTTOM        0
#define    CS_TOP           9999

@class Card;

extern NSString *CARDPILE_CHANGED;


@interface CardPile: DblLinkList
{
    BOOL isFaceUp;
}

/*" Class initialization "*/
+ (void) initialize;

/*" Class method "*/
+ (CardPile*) fullDeck;

/*" Initialization/deallocation "*/
- init;
- initWithCard:(Card*)crd faceUp:(BOOL)fu;

- (BOOL)isFaceUp;
- (void)setFaceUp:(BOOL)bl;
    /*" Manipulating cards "*/

- (void)dealLastObjectTo:(ListHolder*)dest faceUp:(BOOL)up;
- (void)dealLastObjectFaceUpTo:(ListHolder*)dest;
- (void)dealLastObjectFaceDownTo:(ListHolder*)dest;
- (void)dealLastObjectFlipedFaceTo:(ListHolder*)dest;
- (void)removeFromHolderList;

- (int)numberOfContiniusHolderVisibleCard;// return the number of top visible cards
- (void)swapCardWithPile:(CardPile*)otherPile;

- (BOOL)isAllNextInSameCardSuit;
- (BOOL)isAllNextInCardSuit:(CardSuit)s;
- (BOOL)isAllNextInDecreasingCardValue;
- (BOOL)isAllNextInDecreasingCardValue:(int)v;
- (BOOL)isAllNextInAlternateColor;
- (BOOL)isAllNextInAlternateColor:(CardSuit)s;
- (BOOL)isAllNextFaceUp;
- (BOOL)isAllNextFace:(BOOL)faceUp;

    /*"Copying"*/
- copyWithZone:(NSZone*)z;

    /*" Manipulating the deck "*/
- (void) addDeck; // convenience method to append a full deck of card to the top.
- (void) flip; // flip the current pile, and next on
- (void) flipCard; // only flip the current card.

    /*" UndoManager "*/
- undoManager;

/*" Archiving "*/
- (id) initWithCoder:(NSCoder *)aDecoder;
- (void) encodeWithCoder:(NSCoder *)aCoder;

@end

@interface CardPile (Compatibility)
- (CardSuit)cardSuit;
- (void)setCardSuit:(CardSuit)aSuit;
- (CardValue)cardValue;
- (void)setCardValue:(CardValue)aValue;
- (CardColor)cardColor;


- initForCardSize:(int)size;
//- (void)setCardSize:(int)sze;
- (void)addCopyOfPile:(CardPile*)p;
@end

