/* indent:4  tabsize:8  font:fixed-width */

/*---------------------------------------------------------------------------
|----------------------------------------------------------------------------
|
|    Card : NSObject
|
|    Instances of this class provide low-level functionality for card games.  
|    Cards can have a suit, a value, and an orientation.  These values can be
|    initialized, modified and determined by clients of the class.  Cards 	
|    also know how to render themselves on screen.
|
|----------------------------------------------------------------------------
\---------------------------------------------------------------------------*/

#import <AppKit/AppKit.h>
#import "card-defs.h"

@interface Card : NSObject
{
    CardSuit            cardSuit;		/*" The card's suit. "*/
    CardValue           cardValue;		/*" The card's value. "*/
}

/*" Class Method "*/

+ (NSString *)stringForCardSuit:(CardSuit)aSuit;
+ (NSString *)stringForCardValue:(CardValue)aValue;
+ (NSString *)stringForCardColor:(CardColor)aColor;

+ (CardColor) colofOfSuit:(CardSuit)sui;
+ (CardColor) colorInverseOf:(CardColor)co;
+ (NSArray*)fullSet;

/*" Creating and freeing "*/
- init;
- initSuit:(CardSuit)aSuit value:(CardValue)aValue;
- copyWithZone:(NSZone *)zone;

/*" Comparing cards "*/
-(BOOL) isEqual:(Card*)aCard;
-(BOOL) isOneLargerThan:(Card*)aCard wrap:(BOOL)flag;
-(BOOL) isOneSmallerThan:(Card*)aCard wrap:(BOOL)flag;

/*" Our state "*/
- (CardSuit)cardSuit;
- (void)setCardSuit:(CardSuit)aSuit;
- (CardValue)cardValue;
- (void)setCardValue:(CardValue)aValue;
- (CardColor)cardColor;
- (NSString*)description;

/*" Archiving "*/
- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;

@end
