/* indent:4  tabsize:8  font:fixed-width */

/*--------------------------------------------------------------------------
| --------------------------------------------------------------------------
|
|    CardPileView :NSView :NSResponder :NSObject
|
|    Instances of this class provide a visual representation of a pile of 
|    cards.  CardPileView uses CardPile as the underlying representation, 
|    but adds a visual aspect and user interaction.  Users can click on 
|    CardPileViews and drag cards from one view to another.  The decisions 
|    on when this is allowed and what happens as a result are left to the
|    CardPileView's delegate.
|
| ---------------------------------------------------------------------------
\------------------------------------------------------------------------- */

#import <AppKit/NSView.h>
#import "card-defs.h"
#import "CardPile.h"
#import "CardPileHolder.h"

extern NSString* CardPilePBoardType;

@interface CardPileView : NSView
{
    float xOffset, yOffset;	/*" The current drawing offset between cards."*/
    ListHolder* model;	/*" The CardPile holding all the cards. "*/
    BOOL useDragCardPile;	/*" Used internally for dragging cards. "*/

    int	tag;			/*" The pile's tag. "*/
    BOOL drawOutline;		/*" Do we draw an outline around our view? "*/
    int	maxVisibleCards;	/*" The number of overlapping cards you'll see. "*/

   id cardImager;
   id controller;
}	

/*" Class initialization "*/

/*" Creating/releasing "*/
- (id) initWithFrame:(NSRect)frameRect;
- (void) dealloc;

/*" Our visible cards "*/
- (void) setMaxVisibleCards:(int)cardsVisible;
- (int) maxVisibleCards;

/*" Accessors "*/
- (ListHolder*) model;
- (void)setModel:(CardPileHolder*)p;
- cardImager;
- (void)setOffset:(float)xOf :(float)yOf;

/*" Display attributes "*/
- (BOOL) willDrawOutline;
- (void) setDrawOutline:(BOOL)aFlag;
- (void) drawRect:(NSRect)theRect;

/*" Responder methods "*/
- (void) mouseDown:(NSEvent *)theEvent;

/*" Dragging methods "*/
- (unsigned int) draggingEntered:sender;
- (BOOL) prepareForDragOperation:sender;
- (BOOL) performDragOperation:sender;

/*" Utility "*/
- (CardPile*) findPileAtPoint:(NSPoint)thePoint;
- (NSRect) getRectForPile:(CardPile*)aCard;
- (void) drawDragCard:sender;
- (void) setTag:(int)theTag;
- (int) tag;

- (void)superMouseDragged:(NSEvent*)theEvent;
- (void)superMouseUp:(NSEvent*)theEvent;
- (void)superMouseDown:(NSEvent*)theEvent;
- controller;
@end

