/* CardImager.h created by veilljf on Wed 04-Nov-1998 */

#import <Foundation/Foundation.h>
#import "CardPile.h"

@class NSImage;

@interface CardImager : NSObject
{

}

+ (void) initialize;
+ (void) drawCardImages;
+ (void) freeCardImages;
+ (void) setCardBackImage:theImage;
// + (void) setCardBack:(CardBack)aBack;
+ (void) drawCard:(CardPile*)card at:(NSPoint)thePoint;
+ (void) drawOutlineOfCard:(CardPile*)card at:(NSPoint)thePoint;

+ (void) drawContentsOfCard:(CardPile*)card at:(NSPoint)thePoint;

+ (NSImage*)imageForSuit:(int)suit value:(int)value;
+ (void) drawContentsForSuit:(CardSuit)suit
                       value:(CardValue)value
                      faceUp:(BOOL)faceUp
                          at:(NSPoint)thePoint;
+ (float)cardWidth;
+ (float)cardHeight;

+ (float)xTopSpace;
+ (float)yTopSpace;
+ (float)xStackSpace;
+ (float)yStackSpace;

- (float)cardWidth;
- (float)cardHeight;

- (float)xTopSpace;
- (float)yTopSpace;
- (float)xStackSpace;
- (float)yStackSpace;

@end
