objc:declare void NSRegisterServicesProvider {id id}

objc:define JSCancel 4711

if {$tcl_platform(os) == "Rhapsody" && $tcl_platform(osVersion) == 5.0} {
    # To compensate for very strange DR1 bug
    NSBundle loadNibFile: nil externalNameTable: nil withZone: [NULL]
}

objc:teach NSApplication {

- void sendEvent: event {
    switch -- [catch {former sendEvent: $event} result] \
        [TCL_ERROR] {
            NSRunAlertPanel [@ {Joy Error}] [@ $result] [@ Ok] nil nil
        } \
        [ITKOBJC_NSEXCEPTION] {
            NSRunAlertPanel [$result name] [$result reason] [@ Ok] nil nil
        }
}

- void finishLaunching {
    NSRegisterServicesProvider $self [@ JoyServer]
    $self rescanServices
    catch {exec make_services &}
    if {$::tcl_platform(os) != "OPENSTEP"} {
        # on OPENSTEP we want to hide the application icon
        # on other platforms we don't know how we could do that
        former finishLaunching
    }
}

- void rescanServices {
    global tcl_platform env interps interp code \
           sendTypes returnTypes hide unhide
    if {[info exists interps]} {
        foreach oldInterp $interps {
            $oldInterp autorelease
        }
        unset interps interp code sendTypes returnTypes hide unhide
    }
    if {$tcl_platform(platform) == "windows"} {
        set root $env(NEXT_ROOT)
    } else {
        set root /
    }
    foreach path [glob -nocomplain -- \
                        [file join $root System Library Services *.service] \
                        [file join $root Local Library Services *.service] \
                        [file join $root NextLibrary Services *.service] \
                        [file join $root LocalLibrary Services *.service] \
                        [file join ~ Library Services *.service]] {
        set services [NSDictionary dictionaryWithContentsOfFile: \
                        [@ [file join $path Resources Info.plist]]]
        if {[set init [$services objectForKey: [@ JoyCode]]] == "nil"} {
            continue
        }
        set newInterp [[ITKTclInterp alloc] init]
        $newInterp eval: {namespace eval JS {
            namespace export arg path pboard name sendTypes returnTypes type
            proc type {name} {
                if {[string match NS*PboardType $name] &&
                    [objc:info mac $name] != ""} {
                    $name
                } else {
                    @ $name
                }
            }
            proc loadNibFile {name} {
                global self
                NSBundle loadNibFile: [[NSBundle bundleWithPath: [@ $JS::path]] pathForResource: [@ $name] ofType: [@ nib]] externalNameTable: [NSDictionary dictionaryWithObject: $self forKey: [@ NSOwner]] withZone: [$self zone]
            }
            set arg() ""
            unset arg()
            trace variable arg ru [namespace code argtrace]
            proc argtrace {name index op} {
                if {$op == "u"} {
                    if {$index == ""} {
                        upvar $name arg
                        set arg() ""
                        unset arg()
                        trace variable arg ru [namespace code argtrace]
                    }
                    return
                }
                upvar ${name}($index) arg
                if {[info exists arg]} return
                variable pboard
                set type [type $index]
                if {![[$pboard types] containsObject: $type]} return    
                switch -- $index {
                    NSColorPboardType {
                        set arg [NSColor colorFromPasteboard: $pboard]
                    }
                    NSDataLinkPboardType {
                        set arg [[[NSDataLink alloc] \
                                    initWithPasteboard: $pboard] autorelease]
                    }
                    NSFilenamesPboardType {
                        set arg ""
                        objc:foreach f [$pboard propertyListForType: $type] {
                            lappend arg [eval file join [file split [* $f]]]
                        }
                    }
                    NSPostScriptPboardType - NSTIFFPboardType {
                        set arg [[[NSImage alloc] \
                                    initWithPasteboard: $pboard] autorelease]
                    }
                    NSRTFPboardType {
                        set arg [[[NSAttributedString alloc] \
                                    initWithRTF: [$pboard dataForType: $type] \
                             documentAttributes: [NULL]] autorelease]
                    }
                    NSRTFDPboardType {
                        set arg [[[NSAttributedString alloc] \
                                   initWithRTFD: [$pboard dataForType: $type] \
                             documentAttributes: [NULL]] autorelease]
                    }
                    NSSelectionPboardType {
                        set arg [[[NSSelection alloc] \
                                    initWithPasteboard: $pboard] autorelease]
                    }
                    NSStringPboardType - NSTabularTextPboardType {
                        set arg [* [$pboard stringForType: $type]]
                    }
                    default {
                        set arg [$pboard dataForType: $type]
                    }
                }
            }
        }}
        $newInterp setVar: JS::path to: $path flags: [TCL_GLOBAL_ONLY]
        switch -- [catch {$newInterp eval: [* $init]} result] \
            [TCL_ERROR] {
                NSRunAlertPanel [@ JoyServer] [@ "Joy error while initializing $path:\n$result"] [@ Ok] nil nil
                $newInterp autorelease
                continue
            } \
            [ITKOBJC_NSEXCEPTION] {
                NSRunAlertPanel [@ JoyServer] [@ "[$result name] while initializing $path:\n[$result reason]" [@ Ok] nil nil
                $newInterp autorelease
                continue
            }
        objc:foreach service [$services objectForKey: [@ NSServices]] {
            set name [* [$service objectForKey: [@ NSUserData]]]
            set interp($name) $newInterp
            set code($name) [* [$service objectForKey: [@ JoyCode]]]
            set sendTypes($name) ""
            objc:foreach type [$service objectForKey: [@ NSSendTypes]] {
                lappend sendTypes($name) [* $type]
            }
            set returnTypes($name) ""
            objc:foreach type [$service objectForKey: [@ NSReturnTypes]] {
                lappend returnTypes($name) [* $type]
            }
            if {[set b [$service objectForKey: [@ JoyHide]]] == "nil"} {
                set hide($name) 1
            } else {
                set hide($name) [expr {[* $b] == "YES"}]
            }
            if {[set b [$service objectForKey: [@ JoyUnhide]]] == "nil"} {
                set unhide($name) 0
            } else {
                set unhide($name) [expr {[* $b] == "YES"}]
            }
        }
        lappend interps $newInterp
    }
}

- void joyService: pboard userData: userData error: {{id *} error} {
    set name [* $userData]
    upvar #0 interp($name) interp code($name) code \
             sendTypes($name) sendTypes returnTypes($name) returnTypes \
             hide($name) hide unhide($name) unhide
    if {![info exists interp]} {
        objc:poke $error [@ "Don't know how to provide service $name"]
        return
    }
    $interp setVar: JS::pboard to: $pboard flags: [TCL_GLOBAL_ONLY]
    $interp setVar: JS::name to: $name flags: [TCL_GLOBAL_ONLY]
    $interp setVar: JS::sendTypes to: $sendTypes flags: [TCL_GLOBAL_ONLY]
    $interp setVar: JS::returnTypes to: $returnTypes flags: [TCL_GLOBAL_ONLY]
    $interp unsetVar: JS::arg flags: [TCL_GLOBAL_ONLY]
    set count [$pboard changeCount]
    if {$unhide} {
        $self unhideWithoutActivation
        $self activateIgnoringOtherApps: [YES]
    }
    set err [catch {$interp eval: $code} result]
    if {$hide} {
        $self hide: nil
    }
    switch -- $err \
        [TCL_ERROR] {
            objc:poke $error [@ "Joy error:\n$result"]
            return
        } \
        [ITKOBJC_NSEXCEPTION] {
            objc:poke $error [@ "[$result name]:\n[$result reason]"]
            return
        } \
        [JSCancel] {
            return
        }
    if {[llength $returnTypes] == 1 && [$pboard changeCount] == $count} {
        lassign $returnTypes name
        set type [$interp eval: [list JS::type $name]]
        $pboard declareTypes: [NSArray arrayWithObject: $type] owner: nil
        switch -- [catch {
            switch -- $name {
                NSColorPboardType - NSDataLinkPboardType -
                NSSelectionPboardType {
                    $result writeToPasteboard: $pboard
                }
                NSFilenamesPboardType {
                    set pl [NSMutableArray array]
                    foreach f $result {
                        $pl addObject: [@ $f]
                    }
                    $pboard setPropertyList: $pl forType: $type
                }
                NSPostScriptPboardType {
                    objc:foreach rep [$result representations] {
                        if {[$rep isKindOfClass: NSEPSImageRep]} {
                            $pboard setData: [$rep EPSRepresentation] \
                                    forType: $type
                            return
                        }
                    }
                    error "$result does not have a PostScript representation"
                }
                NSTIFFPboardType {
                    $pboard setData: [$result TIFFRepresentation] \
                            forType: $type
                }
                NSRTFPboardType {
                    $pboard setData: \
                        [$result RTFFromRange: "0 [$result length]" \
                           documentAttributes: nil] \
                            forType: $type
                }
                NSRTFDPboardType {
                    $pboard setData: \
                        [$result RTFDFromRange: "0 [$result length]" \
                            documentAttributes: nil] \
                            forType: $type
                }
                NSStringPboardType - NSTabularTextPboardType {
                    $pboard setString: [@ $result] forType: $type
                }
                default {
                    $pboard setData: $result forType: $type
                }
            }
        } result] \
            [TCL_ERROR] {
                objc:poke $error [@ "Joy error while getting result:\n$result"]
            } \
            [ITKOBJC_NSEXCEPTION] {
                objc:poke $error [@ "[$result name] while getting result:\n[$result reason]"]
            }
    }
}

}

if {[NSConnection rootProxyForConnectionWithRegisteredName: [@ JoyServicesDaemon] host: nil] == "nil"} {
    set connection [[NSConnection defaultConnection] retain]
    $connection setRootObject: [NSApplication sharedApplication]
    $connection registerName: [@ JoyServicesDaemon]
    [NSApplication sharedApplication] run
} else {
    NSLog [@ "another JoyServer.daemon is already running"]
}
