/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/

extern "C"
{
#import <Foundation/NSString.h>
#import <Foundation/NSDictionary.h>
}

#include "id3_tag.h"

/** 
    I know this sucks, but I can't get exceptions to work properly 
    in a bundle
**/

extern NSString *id3_frames[];
extern int num_id3frames;

extern "C" 
NSString *id3_get_field_text(ID3_Tag *tag, enum ID3_FrameID frameId)
{
  try
    {
      char buf[1024];
      ID3_Frame *frame = tag->Find(frameId);
      if ( frame != 0 ) {
	ID3_Field &field = frame->Field(ID3FN_TEXT);
	field.Get(buf, 1024);
	return [NSString stringWithCString:buf];
      }
      return nil;
    }
  catch (ID3_Error &e )
    {
      return nil;
    }
  
}

extern "C"
ID3_Tag *id3_create_tag(NSString *filename)
{
  try 
    {
      return new ID3_Tag((char *)[filename cString]);
    }
  catch ( ID3_Error &e )
    {
      NSLog(@"Exception creating ID3_Tag: %s", e.GetErrorDesc());
    }
  return 0;
}


extern "C" 
NSDictionary *id3_get_tag_dictionary(NSString *filename)
{
  NSMutableDictionary *vals = nil;

  try 
    {
      ID3_Tag tag((char *)[filename cString]);
      NSString *val;
      ID3_Frame *frame;
      char buf[1024];
      unsigned int i;
      
      vals = [NSMutableDictionary dictionary];

      for ( i = 0; i < tag.NumFrames(); i++ ) {
	frame = tag[i];
	*buf = 0;
	try 
	  {
	    ID3_Field &field = frame->Field(ID3FN_TEXT);
	    field.Get(buf, 1024);
	    val = [NSString stringWithCString:buf];
	  }
	catch ( ID3_Error &e ) 
	  {
	    if ( e.GetErrorID() == ID3E_FieldNotFound )
	      val = @"(Not Textual)";
	  }
	      
	if ( ((int)frame->GetID()) < num_id3frames )
	  [vals setObject:val forKey:id3_frames[frame->GetID()]];
      }

    }
  catch ( ID3_Error &e ) 
    {
      NSLog(@"error readtag ID3 tag: %s", e.GetErrorDesc());
    }
  return vals;
}


NSString *id3_frames[] = {
  @"None",
  @"Origal Album",
  @"Publisher",
  @"Encoded By",
  @"Encoder Settings",
  @"Original Filename",
  @"Language",
  @"Part In Set",
  @"Date",
  @"Time",
  @"Recording Dates",
  @"Media Type",
  @"File Type",
  @"Net Radio Station",
  @"Net Radio Owner",
  @"Lyricist",
  @"Original Artist",
  @"Original Lyricist",
  @"Subtitle",
  @"Mix Artist",
  @"User Text",
  @"Content Group",
  @"Title",
  @"Lead Artist",
  @"Band",
  @"Album",
  @"Year",
  @"Conductor",
  @"Composer",
  @"Copyright",
  @"Content Type",
  @"Track Num",
  @"Comment",
  @"WWW Audio File",
  @"WWW Artist",
  @"WWW Audio Source",
  @"WWW Commercial Info",
  @"WWW Copyright",
  @"WWW Publisher",
  @"WWW Payment",
  @"WWW Radiopage",
  @"WWW User",
  @"Involved People",
  @"Unsynced Lyrics",
  @"Picture",
  @"General Object",
  @"Unique File Id",
  @"Play Counter",
  @"Popular Imeter",
  @"Group Ingreg",
  @"Gryptoreg"
};

int num_id3frames = sizeof(id3_frames) / sizeof(*id3_frames);
