/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/
#import <AppKit/AppKit.h>
#import "Plugins.h"

typedef enum
{
	VIS_ANALYZER,VIS_SCOPE,VIS_OFF
} VisType;

typedef enum
{
	ANALYZER_NORMAL,ANALYZER_FIRE,ANALYZER_VLINES
} AnalyzerMode;
	

typedef enum
{
	ANALYZER_LINES,ANALYZER_BARS
} AnalyzerType;

	
typedef enum
{
	SCOPE_DOT,SCOPE_LINE,SCOPE_SOLID
} ScopeMode;
	
typedef enum
{
	VU_NORMAL,VU_SMOOTH
} VUMode;
	
typedef enum
{
	REFRESH_FULL,REFRESH_HALF,REFRESH_QUARTER,REFRESH_EIGTH
} RefreshRate;
	
typedef enum
{
	FALLOFF_SLOWEST,FALLOFF_SLOW,FALLOFF_MEDIUM,FALLOFF_FAST,FALLOFF_FASTEST
} FalloffSpeed;


@interface Visualization : NSView
{
  float data[75], peak[75], peak_speed[75];
  int refresh_delay;
}

- (void)timeout:(unsigned char *)data;
- (void)clear;
- (void)drawIt;

@end


@interface VisEntry : NSObject
{
  @public
  int time;
  InputVisType	type;
  unsigned char vis[75];
}
@end
  
