/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/
#import <AppKit/AppKit.h>
#import "PluginPreference.h"
#import "Plugins.h"

@implementation PluginPreference

- (void)awakeFromNib
{
  [browser setDoubleAction:@selector(browser_doubleaction:)];
}

- (void)setPluings:(NSArray *)_plugins
{
  plugins = _plugins;
}


- (void)enabled:sender
{
  int sel = [browser selectedRowInColumn:0];
  
  if ( sel != -1 )
    [[plugins objectAtIndex:sel] setEnabled:[sender state]];
}


- (void)configure:sender
{
  int sel = [browser selectedRowInColumn:0];
  
  if ( sel != -1 )
    [[plugins objectAtIndex:sel] configure];
}

- (void)about:sender
{
  int sel = [browser selectedRowInColumn:0];
  
  if ( sel != -1 )
    [[plugins objectAtIndex:sel] about];
}


- (void)browser_action:sender
{
  Plugin *plugin;
  plugin = [plugins objectAtIndex:[sender selectedRowInColumn:0]];
  [enabled_box setEnabled:YES];
  [enabled_box setState:[plugin enabled]];
  [[button_matrix cellWithTag:0] setEnabled:[plugin hasConfigure]];
  [[button_matrix cellWithTag:1] setEnabled:[plugin hasAbout]];
}

- (void)browser_doubleaction:sender
{
  [self configure:sender];
}

- (int)browser:(NSBrowser *)sender numberOfRowsInColumn:(int)column
{
  return [plugins count];
}

- (void)browser:(NSBrowser *)sender 
willDisplayCell:(id)cell 
	  atRow:(int)row 
	 column:(int)column
{
  Plugin *plugin;
  plugin = [plugins objectAtIndex:row];
  [cell setStringValue:[plugin description]];
  [cell setLeaf:YES];
}


@end
