/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/
#import <Foundation/NSArray.h>
#import "PlaylistView.h"
#import "EqView.h"
#import "Skin.h"
#import "Config.h"
#import "Button.h"
#import "TextBox.h"
#import "MenuRow.h"
#import "Slider.h"
#import "MonoStereo.h"
#import "Number.h"
#import "EqGraph.h"
#import "EqSlider.h"
#import "NormPlaylistList.h"
#import "BrowserPlaylistList.h"
#import "AppDelegate.h"
#import "PlaylistEntry.h"
#import "PlaylistSlider.h"
#import "PlaylistPopup.h"
#import "MainView.h"
#import "Plugins.h"

@implementation PlaylistView

- (void)removeIfNeeded:(NSView *)view
{
  if ( [view superview] != nil )
    [view removeFromSuperviewWithoutNeedingDisplay];
}

- (void)addSubviewIfNeeded:(NSView *)view
{
  if ( [view superview] == nil )
    [self addSubview:view];
}

- (void)repositionViews
{
  NSRect frame = [self frame];
  int y = frame.size.height-31;
  NSPoint o;

  [shade setFrame:NSMakeRect(frame.size.width-21,3,9,9)];
  [close setFrame:NSMakeRect(frame.size.width-11,3,9,9)];
  [slider setFrame:NSMakeRect(frame.size.width-15, 20,
			      8, frame.size.height-58)];
  [playlistList setFrame:NSMakeRect(12,20, frame.size.width-31,
				    frame.size.height-58)];
  [time_min setFrame:NSMakeRect(frame.size.width-82,
				frame.size.height-15, 15, 6)];
  [time_sec setFrame:NSMakeRect(frame.size.width-64,
				frame.size.height-15, 10, 6)];
  [info setFrame:NSMakeRect(frame.size.width-143,
			    frame.size.height-28, 85, 6)];
  [srew setFrame:NSMakeRect(frame.size.width-144,
			    frame.size.height-16,8,7)];
  [splay setFrame:NSMakeRect(frame.size.width-138,
			     frame.size.height-16,10,7)];
  [spause setFrame:NSMakeRect(frame.size.width-128,
			      frame.size.height-16,10,7)];
  [sstop setFrame:NSMakeRect(frame.size.width-118,
			     frame.size.height-16,9,7)];
  [sfwd setFrame:NSMakeRect(frame.size.width-109,
			    frame.size.height-16,8,7)];
  [seject setFrame:NSMakeRect(frame.size.width-100, 
			      frame.size.height-16,9,7)];
  [sscroll_up setFrame:NSMakeRect(frame.size.width-14,
				  frame.size.height-35, 8,5)];
  [sscroll_down setFrame:NSMakeRect(frame.size.width-14,
				    frame.size.height-30, 8,5)];

  if ( ((frame.size.width-275)/25) >= 3 ) {
    [self addSubviewIfNeeded:vis];
    [vis setFrame:NSMakeRect(frame.size.width-223,
			     frame.size.height-26,72, 16)];
  } else
    [self removeIfNeeded:vis];

#define reset_popup(pop)\
  o.y = y; \
  o.x = [pop frame].origin.x; \
  [pop setFrameOrigin:o];

  reset_popup(add_popup);
  reset_popup(sub_popup);
  reset_popup(misc_popup);
  reset_popup(sel_popup);
  
  o = NSMakePoint(frame.size.width-46,y);
  [plist_popup setFrameOrigin:o];
}
  

- (void)updateShaded:(BOOL)shaded
{
  NSSize size;
  NSRect frame;
  NSPoint new_pos;

  [cfg setplaylist_shaded:shaded];

  frame = [[self window] frame];  
  size = frame.size;
  new_pos = frame.origin;

  if ( !shaded ) {
    [self removeIfNeeded:sinfo];
    size.height = [cfg playlist_size].height;
    new_pos.y = new_pos.y + frame.size.height - size.height;
    [shade setNormal:NSMakePoint(157, 3)];
    [shade setPushed:NSMakePoint(62, 42)];
    [close setNormal:NSMakePoint(167, 3)];
  } else {
    size.height = 14;
    new_pos.y = new_pos.y - size.height + frame.size.height;
    [shade setNormal:NSMakePoint(128, 45)];
    [shade setPushed:NSMakePoint(150, 42)];
    [close setNormal:NSMakePoint(138, 45)];


    [self removeIfNeeded:info];
    [self removeIfNeeded:playlistList];
    [self removeIfNeeded:time_min];
    [self removeIfNeeded:time_sec];
    [self removeIfNeeded:srew];
    [self removeIfNeeded:splay];
    [self removeIfNeeded:sstop];
    [self removeIfNeeded:sfwd];
    [self removeIfNeeded:seject];
    [self removeIfNeeded:sscroll_up];
    [self removeIfNeeded:sscroll_down];
    [self removeIfNeeded:spause];
    [self removeIfNeeded:slider];
    [self removeIfNeeded:add_popup];
    [self removeIfNeeded:sub_popup];
    [self removeIfNeeded:misc_popup];
    [self removeIfNeeded:plist_popup];
    [self removeIfNeeded:sel_popup];
  }
  frame = NSMakeRect(new_pos.x, new_pos.y, size.width,size.height);
  [[self window] setFrame:frame display:NO];

  if ( !shaded ) {
    [self addSubviewIfNeeded:info];
    [self addSubviewIfNeeded:playlistList];
    [self addSubviewIfNeeded:time_min];
    [self addSubviewIfNeeded:time_sec];
    [self addSubviewIfNeeded:srew];
    [self addSubviewIfNeeded:splay];
    [self addSubviewIfNeeded:sstop];
    [self addSubviewIfNeeded:sfwd];
    [self addSubviewIfNeeded:seject];
    [self addSubviewIfNeeded:sscroll_up];
    [self addSubviewIfNeeded:sscroll_down];
    [self addSubviewIfNeeded:spause];
    [self addSubviewIfNeeded:slider];
    [self addSubviewIfNeeded:add_popup];
    [self addSubviewIfNeeded:sub_popup];
    [self addSubviewIfNeeded:misc_popup];
    [self addSubviewIfNeeded:plist_popup];
    [self addSubviewIfNeeded:sel_popup];
    if ( ((frame.size.width-275)/25) >= 3 )
      [self addSubviewIfNeeded:vis];
    [self repositionViews];
  } else {
    [sinfo setFrame:NSMakeRect(4, 4, frame.size.width-35, 6)];
    [self addSubviewIfNeeded:sinfo];
  }
}


- (void)shade_pushed:button
{
  [self updateShaded:![cfg playlist_shaded]];
}

- (BOOL)isFlipped
{
  return YES;
}

- (void)close_button:sender
{
  [[NSApp delegate] hideShowPlaylist:sender];
}

- (void)button_pressed:button
{
  NSLog(@"PlaylistView.button_pressed");
}

- (void)scrollDown:button
{
  [playlistList scrollDown];
}

- (void)scrollUp:button
{
  [playlistList scrollUp];
}

- (void)scrollList:aslider
{
  [playlistList scrollTo:[aslider maxValue] - [aslider intValue]];
}

- (void)showMenu:(NSMenu *)menu :(NSPopUpButton *)button
{
  NSRect frame, mframe, bframe;
  NSMenuView *menuView;
  NSWindow *menuWindow;

  if ( menu == nil )
    return;

  menuView = [[NSMenuView alloc] initWithFrame:NSMakeRect(0,0,0,0)];
  [menuView setMenu:menu];
  [menuView update];
  [menuView setNeedsSizing:YES];
  [menuView sizeToFit];
  menuWindow = [[NSWindow alloc]  
		 initWithContentRect:[menuView frame]
			   styleMask:NSBorderlessWindowMask
			     backing:NSBackingStoreBuffered
			       defer:FALSE];
  [menuWindow setContentView:menuView];

  mframe = [menuView frame];
  frame = [[self window] frame];
  bframe = [button frame];
  frame.origin.y = frame.origin.y + (frame.size.height-bframe.origin.y);
  frame.origin.x = frame.origin.x + bframe.origin.x + bframe.size.width;
  [menuWindow setFrameOrigin:NSMakePoint(frame.origin.x, frame.origin.y)];
  
  [menuWindow makeKeyAndOrderFront:self];
  [menuView trackWithEvent:[NSApp currentEvent]];
  [menuWindow orderOut:self];

  [menuWindow release];
}


- (void)opts_menu:popup
{
  NSLog(@"opts_menu:");
  [self showMenu:[[NSApp delegate] miscOptsMenu] :misc_popup];
}

- (void)file_menu:popup
{
  NSArray *items = [Playlist selectedItems];
  if ( [items count] )
    [Input fileInfoBox:[[items objectAtIndex:0] filename]];
}

- (void)sort_menu:popup
{
  NSLog(@"sort_menu: %@", [[NSApp delegate] sortMenu]);
  [self showMenu:[[NSApp delegate] sortMenu] :misc_popup];
}

- (void)load_list:popup
{
  NSOpenPanel *panel;
  
  panel = [NSOpenPanel openPanel];
  
  [panel setAllowsMultipleSelection:NO];
  [panel setCanChooseDirectories:NO];
  
  if ( [panel runModalForTypes:nil] == NSOKButton ) {
    NSString *fn = [[panel filenames] objectAtIndex:0];
    if ( [Playlist loadPlaylist:fn] ) {
      [cfg setcurrent_playlist:fn];
    }
  }
}

- (void)save_list:popup
{
  [[NSApp delegate] savePlaylist];
}

- (void)add_file:popup
{
  NSOpenPanel *panel;
  
  panel = [NSOpenPanel openPanel];
  
  [panel setAllowsMultipleSelection:YES];
  [panel setCanChooseDirectories:NO];
  
  if ( [panel runModalForTypes:nil] == NSOKButton ) {
    int i;
    NSArray *files = [panel filenames];
    for ( i = 0; i < [files count]; i++ ) {
      [Playlist addFile:[files objectAtIndex:i]];
    }
  }
}

- (void)add_dir:popup
{
  NSOpenPanel *panel;
  
  panel = [NSOpenPanel openPanel];
  
  [panel setAllowsMultipleSelection:YES];
  [panel setCanChooseDirectories:YES];
  [panel setCanChooseFiles:NO];
  
  if ( [panel runModalForTypes:nil] == NSOKButton ) {
    int i;
    NSArray *files = [panel filenames];
    for ( i = 0; i < [files count]; i++ ) {
      [Playlist addDirectory:[files objectAtIndex:i]];
    }
  }
}

- (void)add_url:popup
{
}

- (void)new_list:popup
{
  [Playlist newPlaylist];
  [cfg setcurrent_playlist:@""];  
}

- (void)sel_all:popup
{
  [Playlist selectAll];
}

- (void)sel_invert:popup
{
  [Playlist invertSelection];
}

- (void)sel_zero:popup
{
  [Playlist clearSelection];
}

- (void)sub_file:popup
{
  [Playlist removeSelected];
}

- (void)sub_crop:popup
{
  [Playlist crop];
}

- (void)sub_all:popup
{
  [Playlist removeAll];
}

- (void)sub_misc:popup
{
}

#if 0
- (NSImage *)createPopupImage:(int)x :(int)y
{
  NSImage *new_image;
  
  new_image = [[NSImage allocWithZone:[self zone]] 
			 initWithSize:NSMakeSize(22, 18)];

  [new_image lockFocus];
  PSgsave();
  [[currentSkin pledit] 
    compositeToPoint:NSMakePoint(0,0)
	    fromRect:flipRect(NSMakeRect(x,y, 22, 18),
			      [currentSkin pledit])
	   operation:NSCompositeCopy];
  PSgrestore();
  [new_image unlockFocus];
  return new_image;
}
#endif

- (NSPopUpButton *)createPopup:(NSPoint)pos
			      :(int)num_items
			      :(int *)nx
			      :(int *)ny
			      :(int *)sx
			      :(int *)sy
			      :(SEL *)actions
			      :(int)barx
			      :(int)bary
			      :(SEL)cb
{
  pos.x -= 3;
  return [[PlaylistPopup alloc] initWithPos:pos 
					   :num_items 
					   :nx 
					   :ny 
					   :sx
					   :sy
					   :actions
					   :barx
					   :bary
					   :self];
}

- (void)createPopupButtons
{
  int add_nx[]={0,0,0},add_ny[]={111,130,149},add_sx[]={23,23,23},add_sy[]={111,130,149},add_barx=48,add_bary=111;
  int sub_nx[]={54,54,54,54},sub_ny[]={168,111,130,149},sub_sx[]={77,77,77,77},sub_sy[]={168,111,130,149},sub_barx=100,sub_bary=111;
  int sel_nx[]={104,104,104},sel_ny[]={111,130,149},sel_sx[]={127,127,127},sel_sy[]={111,130,149},sel_barx=150,sel_bary=111;
  int misc_nx[]={154,154,154},misc_ny[]={111,130,149},misc_sx[]={177,177,177},misc_sy[]={111,130,149},misc_barx=200,misc_bary=111;
  int plist_nx[]={204,204,204},plist_ny[]={111,130,149},plist_sx[]={227,227,227},plist_sy[]={111,130,149},plist_barx=250,plist_bary=111;
  SEL misc_actions[] = 
  { @selector(opts_menu:), @selector(file_menu:), @selector(sort_menu:) };
  SEL list_actions[] =
  { @selector(load_list:), @selector(save_list:), @selector(new_list:) };
  SEL sel_actions[] =
  { @selector(sel_all:),  @selector(sel_zero:), @selector(sel_invert:) };
  SEL add_actions[] = 
  { @selector(add_file:), @selector(add_dir:), @selector(add_url:) };
  SEL sub_actions[] =
  { @selector(sub_file:), @selector(sub_crop:), @selector(sub_all:),
    @selector(sub_crop:) };
  
  int y;
  NSRect frame = [self frame];

  y = frame.size.height-31;

  add_popup = [self createPopup:NSMakePoint(14, y)
			       :3 :add_nx :add_ny :add_sx :add_sy
				 :add_actions
			         :add_barx :add_bary
			         :@selector(button_pressed:)];
  [add_popup setAutoresizingMask:NSViewMinYMargin];
  [self addSubview:add_popup];
 
 
  sub_popup = [self createPopup:NSMakePoint(43, y)
				 :4 :sub_nx :sub_ny :sub_sx :sub_sy
				 :sub_actions
			         :sub_barx :sub_bary
			         :@selector(button_pressed:)];
  [sub_popup setAutoresizingMask:NSViewMinYMargin];
  [self addSubview:sub_popup];

  sel_popup = [self createPopup:NSMakePoint(72, y)
				 :3 :sel_nx :sel_ny :sel_sx :sel_sy
				 :sel_actions
			         :sel_barx :sel_bary
			         :@selector(button_pressed:)];
  [sel_popup setAutoresizingMask:NSViewMinYMargin];
  [self addSubview:sel_popup];

  misc_popup = [self createPopup:NSMakePoint(101, y)
				 :3 :misc_nx :misc_ny :misc_sx :misc_sy
				 :misc_actions
			         :misc_barx :misc_bary
			         :@selector(button_pressed:)];
  [misc_popup setAutoresizingMask:NSViewMinYMargin];
  [self addSubview:misc_popup];

  plist_popup = [self createPopup:NSMakePoint(frame.size.width-46,
						y)
				 :3 :plist_nx :plist_ny :plist_sx :plist_sy
				 :list_actions
			         :plist_barx :plist_bary
			         :@selector(button_pressed:)];
  [plist_popup setAutoresizingMask:NSViewMinXMargin|NSViewMinYMargin];
  [self addSubview:plist_popup];
}

- (void)skinChanged:(NSNotification *)notification
{
  [add_popup removeFromSuperview];
  [sub_popup removeFromSuperview];
  [sel_popup removeFromSuperview];
  [misc_popup removeFromSuperview];
  [plist_popup removeFromSuperview];
  [self createPopupButtons];
}


- initWithFrame:(NSRect)frame
{
  MainView *appDelegate = [NSApp delegate];
  
  [super initWithFrame:frame];

  [self setAutoresizesSubviews:YES];

  sinfo = [[TextBox alloc] 
	    initWithFrame:NSMakeRect(4, 4, frame.size.width-35, 0)
			 :self
			 :@selector(text)];
  [sinfo setAutoresizingMask:NSViewWidthSizable];

  shade = [[Button alloc] init:NSMakeRect(frame.size.width-21,3,9,9)
			      :NSMakePoint(157,3)
			      :NSMakePoint(62,42)
			      :self
			      :@selector(shade_pushed:)
			      :@selector(pledit)];
  [shade setAutoresizingMask:NSViewMinXMargin];
  [self addSubview:shade];


  close = [[Button alloc] init:NSMakeRect(frame.size.width-11,3,9,9)
			      :NSMakePoint(167,3)
			      :NSMakePoint(52,42)
			      :self
			      :@selector(close_button:)
			      :@selector(pledit)];
  [close setAutoresizingMask:NSViewMinXMargin];
  [self addSubview:close];



  slider = [[PlaylistSlider alloc] initWithParentFrame:frame 
						target:self 
					    cb:@selector(scrollList:)];
  [slider setMaxValue:[Playlist count]];
  [slider setIntValue:[Playlist count]];
  [slider setAutoresizingMask:NSViewHeightSizable|NSViewMinXMargin];
  [self addSubview:slider];
  
  {
    Class lclass;
    if ( [cfg useArtistBrowser] )
      lclass = [BrowserPlaylistList class];
    else
      lclass = [NormPlaylistList class];
    
    playlistList = [[lclass alloc] 
		   initWithFrame:NSMakeRect(12,20,
					    frame.size.width-31,
					    frame.size.height-58)
			  target:self
			  action:@selector(playlistListClicked:)
			  slider:slider];
    [playlistList setAutoresizingMask:
      NSViewHeightSizable|NSViewWidthSizable];
    [self addSubview:playlistList];
  }
  

  time_min = [[TextBox alloc] 
	       initWithFrame:NSMakeRect(frame.size.width-82,
					frame.size.height-15, 15, 1)
			    :self
			    :@selector(text)];
  [time_min setAutoresizingMask:NSViewMinXMargin|NSViewMinYMargin];
  [self addSubview:time_min];

  time_sec = [[TextBox alloc] 
	       initWithFrame:NSMakeRect(frame.size.width-64,
					frame.size.height-15, 10, 1)
			    :self
			    :@selector(text)];
  [time_sec setAutoresizingMask:NSViewMinXMargin|NSViewMinYMargin];
  [self addSubview:time_sec];

  info = [[TextBox alloc] 
	       initWithFrame:NSMakeRect(frame.size.width-143,
					frame.size.height-28, 85, 1)
			    :self
			    :@selector(text)];
  [info setAutoresizingMask:NSViewMinXMargin|NSViewMinYMargin];
  [self addSubview:info];


  vis = [[Visualization alloc] initWithFrame:NSMakeRect(frame.size.width-223,frame.size.height-26,72, 16)];
  [vis setAutoresizingMask:NSViewMinXMargin|NSViewMinYMargin];

  if ( ((frame.size.width-275)/25) >= 3 )
    [self addSubview:vis];

  srew = [[Button alloc] init:NSMakeRect(frame.size.width-144,
					 frame.size.height-16,8,7)
			      :appDelegate
			      :@selector(prev_pressed:)];
  [srew setAutoresizingMask:NSViewMinXMargin|NSViewMinYMargin];
  [self addSubview:srew];

  splay = [[Button alloc] init:NSMakeRect(frame.size.width-138,
					  frame.size.height-16,10,7)
			      :appDelegate
			      :@selector(play_pressed:)];
  [splay setAutoresizingMask:NSViewMinXMargin|NSViewMinYMargin];
  [self addSubview:splay];
  
  spause = [[Button alloc] init:NSMakeRect(frame.size.width-128,
					   frame.size.height-16,10,7)
			       :appDelegate
			       :@selector(pause_pressed:)];
  [spause setAutoresizingMask:NSViewMinXMargin|NSViewMinYMargin];
  [self addSubview:spause];

  sstop = [[Button alloc] init:NSMakeRect(frame.size.width-118,
					  frame.size.height-16,9,7)
			      :appDelegate
			      :@selector(stop_pressed:)];
  [sstop setAutoresizingMask:NSViewMinXMargin|NSViewMinYMargin];
  [self addSubview:sstop];

  sfwd = [[Button alloc] init:NSMakeRect(frame.size.width-109,
					 frame.size.height-16,8,7)
			     :appDelegate
			     :@selector(fwd_pressed:)];
  [sfwd setAutoresizingMask:NSViewMinXMargin|NSViewMinYMargin];
  [self addSubview:sfwd];

  seject = [[Button alloc] init:NSMakeRect(frame.size.width-100,
					   frame.size.height-16,9,7)
			       :appDelegate
			       :@selector(eject_pressed:)];
  [seject setAutoresizingMask:NSViewMinXMargin|NSViewMinYMargin];
  [self addSubview:seject];

  sscroll_up = [[Button alloc] init:NSMakeRect(frame.size.width-14,
					       frame.size.height-35,
					       8,5)
				   :self
				   :@selector(scrollUp:)];
  [sscroll_up setAutoresizingMask:NSViewMinXMargin|NSViewMinYMargin];
  [self addSubview:sscroll_up];

  sscroll_down= [[Button alloc] init:NSMakeRect(frame.size.width-14,
						frame.size.height-30,
						8,5)
				    :self
				    :@selector(scrollDown:)];
  [sscroll_down setAutoresizingMask:NSViewMinXMargin|NSViewMinYMargin];
  [self addSubview:sscroll_down];
  [self createPopupButtons];

  [self update_sinfo];
  [self update_info];

  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(playlistChanged:)
	   name:PlaylistSelectionChangedNotification
	 object:nil];
  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(playlistChanged:)
	   name:PlaylistChangedNotification
	 object:nil];
  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(playlistChanged:)
	   name:NewPlaylistNotification
	 object:nil];
  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(skinChanged:)
	   name:SkinChangedNotification
	 object:nil];
  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(songInfoChanged:)
	   name:SongInfoChangedNotification
	 object:nil];
  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(songEnded:)
	   name:SongEndedNotification
	 object:nil];

  return self;
}

- (void)drawRect:(NSRect)rect 
{
  int w,h,y,i,c;
  NSImage *src;
  BOOL drawFocus = [[self window] isKeyWindow] || ![cfg dim_titlebar];
  NSRect frame = [self frame];
  
  w = frame.size.width;
  h = frame.size.height;
  src = [currentSkin pledit];
  
  if([cfg playlist_shaded]) {
    [src compositeToPoint:NSMakePoint(0, 14)
		 fromRect:flipRect(NSMakeRect(72, 42, 25, 14), src)
		operation:NSCompositeCopy];

    c = (w-75) / 25;
    for(i = 0; i < c; i++)
      [src compositeToPoint:NSMakePoint((i * 25) + 25, 14)
		   fromRect:flipRect(NSMakeRect(72, 57, 25, 14), src)
		  operation:NSCompositeCopy];

    [src compositeToPoint:NSMakePoint(w-50, 14)
		 fromRect:flipRect(NSMakeRect(99, drawFocus?57:42, 
					      50, 14), src)
		operation:NSCompositeCopy];
  } else {
    y = drawFocus ? 0 : 21;
    [src compositeToPoint:NSMakePoint(0,20)
		 fromRect:flipRect(NSMakeRect(0, y, 25, 20),src)
		operation:NSCompositeCopy];


    /** titlebar lines **/
    c=(w-150)/25;
    for(i=0;i<c/2;i++) {
      [src compositeToPoint:NSMakePoint((i*25)+25, 20)
		   fromRect:flipRect(NSMakeRect(127, y, 25, 20), src)
		  operation:NSCompositeCopy];
      [src compositeToPoint:NSMakePoint((i*25)+(w/2)+50, 20)
		   fromRect:flipRect(NSMakeRect(127, y, 25, 20), src)
		  operation:NSCompositeCopy];
    }
    if(c&1) {
      [src compositeToPoint:NSMakePoint(((c/2)*25)+25, 20)
		   fromRect:flipRect(NSMakeRect(127, y, 12, 20), src)
		  operation:NSCompositeCopy];

      [src compositeToPoint:NSMakePoint((w/2)+((c/2)*25)+50, 20)
		   fromRect:flipRect(NSMakeRect(127, y, 13, 20), src)
		  operation:NSCompositeCopy];
    }
    /****/

    /** title **/
    [src compositeToPoint:NSMakePoint((w/2)-50, 20)
		 fromRect:flipRect(NSMakeRect(26, y, 100, 20), src)
		operation:NSCompositeCopy];
    /** title button area **/
    [src compositeToPoint:NSMakePoint(w-25, 20)
		 fromRect:flipRect(NSMakeRect(153, y, 25, 20), src)
		operation:NSCompositeCopy];

    /** sides **/
    for(i=0;i<(h-58)/29;i++) {
      [src compositeToPoint:NSMakePoint(0, (i*29)+20+29)
		   fromRect:flipRect(NSMakeRect(0, 42, 12, 29), src)
		  operation:NSCompositeCopy];
      [src compositeToPoint:NSMakePoint(w-19, (i*29)+20+29)
		   fromRect:flipRect(NSMakeRect(32, 42, 19, 29), src)
		  operation:NSCompositeCopy];
    }
    /****/

    /** bottom left **/
    [src compositeToPoint:NSMakePoint(0, h)
		 fromRect:flipRect(NSMakeRect(0, 72, 125, 38), src)
		operation:NSCompositeCopy];

    /** vis **/
    c=(w-275)/25;
    if(c>=3) {
      c-=3;
      [src compositeToPoint:NSMakePoint(w-225, h)
		   fromRect:flipRect(NSMakeRect(205, 0, 75, 38), src)
		  operation:NSCompositeCopy];
    }


    /** bottom left of vis **/
    for(i=0;i<c;i++)
      [src compositeToPoint:NSMakePoint((i*25)+125, h)
		   fromRect:flipRect(NSMakeRect(179, 0, 25, 38), src)
		  operation:NSCompositeCopy];

    /** bottom right **/
    [src compositeToPoint:NSMakePoint(w-150, h)
		 fromRect:flipRect(NSMakeRect(126, 72, 150, 38), src)
		operation:NSCompositeCopy];
  }
}

- (void)mouseDown:(NSEvent *)theEvent 
{
  NSPoint startPoint, curPoint, new;
  NSRect frame = [[self window] frame], playerFrame, eqFrame;
  int xdif, ydif;
  int sd = [cfg snap_distance];
  int w = frame.size.width;
  int h = frame.size.height;
  int sw = [[NSScreen mainScreen] frame].size.width;
  int sh = [[NSScreen mainScreen] frame].size.height;
  BOOL done = NO;

  new.x = new.y = 0;

  startPoint = [theEvent locationInWindow];
  
  if(([cfg playlist_shaded] == NO && 
      startPoint.x > frame.size.width-20 
      && startPoint.y < 20)
     || ([cfg playlist_shaded] && startPoint.x >= frame.size.width-31 
	 && startPoint.x < frame.size.width - 22)) {
    // Size Window
    int w, bx, nw, h, by, nh, ny;
    float ysave;
    NSRect new_frame = frame;
    NSPoint sPoint;
    NSSize save_size;

    while (!done) {
      NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
      theEvent = [[self window] nextEventMatchingMask:(NSLeftMouseDraggedMask | NSLeftMouseUpMask)];
      curPoint = [theEvent locationInWindow];

      ysave = 0;
      if (curPoint.y < 0 ) {
	ysave = curPoint.y;
	curPoint.y = 0;
      }

      sPoint = [[self window] convertBaseToScreen:curPoint];
      sPoint.y += ysave;

      w = curPoint.x + (frame.size.width-startPoint.x);
      bx = (w-275) / 25;
      nw = (bx * 25) + 275;
      if( nw < 275 ) 
	nw = 275;
		
      if(![cfg playlist_shaded]) {
	int y = sPoint.y - startPoint.y;
	h = new_frame.size.height - (y-new_frame.origin.y);
	by = (h-58) / 29;
	nh = (by * 29) + 58;
	if ( nh < 116 )
	  nh = 116;
	ny = new_frame.origin.y + (new_frame.size.height-nh);
      } else {
	nh = frame.size.height;
	ny = frame.origin.y;
      }

      if ( nh != frame.size.height || nw != frame.size.width ) {
	new_frame.origin.x = frame.origin.x;
	new_frame.size.width = nw;

	new_frame.size.height = nh;
	new_frame.origin.y = ny;
	save_size = new_frame.size;
	if ( [cfg playlist_shaded] )
	  save_size.height = [cfg playlist_size].height;
	[cfg setplaylist_size:save_size];
	[[self window] setFrame:new_frame display:YES];
	if ( ((new_frame.size.width-275)/25) >= 3 ) {
	  if ( [vis superview] == nil )
	    [vis setFrame:NSMakeRect(new_frame.size.width-223,
				     new_frame.size.height-26,72, 16)];
	  [self addSubviewIfNeeded:vis];
	} else {
	  if ( [vis superview] != nil )
	    [vis removeFromSuperview];
	}
      }

      if ([theEvent type] == NSLeftMouseUp) {
	if ( [cfg playlist_shaded] )
	  [self update_sinfo];
	done = YES;
      }

      [pool release];
    }
    
  } else if (startPoint.y > frame.size.height-14 || [cfg easy_move] ) {
    // Move window
    startPoint = [[self window] convertBaseToScreen:startPoint];
    xdif = startPoint.x - frame.origin.x;
    ydif = startPoint.y - frame.origin.y;

    if( [cfg player_visible] )
      playerFrame = [[[NSApp delegate] mainWindow] frame];
    if ( [cfg equalizer_visible] )
      eqFrame = [[[NSApp delegate] eqWindow] frame];

    while (!done) {
      NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
      theEvent = [[self window] nextEventMatchingMask:(NSLeftMouseDraggedMask | NSLeftMouseUpMask)];
      curPoint = [theEvent locationInWindow];

      curPoint = [[self window] convertBaseToScreen:curPoint];
      new = NSMakePoint(curPoint.x-xdif, curPoint.y-ydif);

      if ( [cfg snap_windows] ) {
	if(new.x > -sd && new.x < sd)
	  new.x = 0;
	if((new.x + w) > sw - sd && (new.x + w) < sw + sd)
	  new.x = sw - w;
	if(new.y > -sd && new.y < sd)
	  new.y = 0;
	if((new.y + h) > sh - sd && (new.y + h) < sh + sd) 
	  new.y = sh - h;
      }

      if( [cfg player_visible] ) {
	dock(&new.x, &new.y, w, h, playerFrame.origin.x, 
	     playerFrame.origin.y, playerFrame.size.width, 
	     playerFrame.size.height);
      }
	  
      if([cfg equalizer_visible]) {
	dock(&new.x, &new.y, w, h, eqFrame.origin.x, 
	     eqFrame.origin.y, eqFrame.size.width,
	     eqFrame.size.height);
      }

      [[self window] setFrameOrigin:new];

      if ([theEvent type] == NSLeftMouseUp)
	done = YES;

      [pool release];

    }
  }
  
}

- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
  return YES;
}

- (int)currentLength
{
  return currentLength;
}

- (void)songIsPlaying:(NSString *)title length:(int)len
{
  currentLength = len;
}

- (void)eofReached
{
  if ( [cfg noplaylist_advance] == YES ) {
    [[[NSApp delegate] mainView] setRate:0 freq:0 numChannels:0];
    if ( [cfg repeat] )
      [self play];
  } else {
    if ( [cfg repeat] )
      [self play];
    else
      [self forward];
  }
}

- (void)playlistChanged:(NSNotification *)notification
{
  int oldpos = [slider intValue];
  if ( [cfg playlist_position] > [Playlist count] )
    [cfg setplaylist_position:0];
  if ( [slider maxValue] != [Playlist count] ) {
    [slider setMaxValue:[Playlist count]];
    if ( oldpos < [slider maxValue] )
      [slider setIntValue:[slider maxValue] - oldpos];
    else if ( oldpos > [slider maxValue] )
      [slider setIntValue:[slider maxValue]];
  }
  [self update_sinfo];
  [self update_info];
}

- (void)setTime:(int)time length:(int)length
{
  NSString *text;
  char sign;
		
  if([cfg timer_mode] == TIMER_REMAINING && length != -1) {
    time = length-time;
    sign = '-';
  } else
    sign = ' ';
  
  time /= 1000;
	
  if(time < 0)
    time = 0;
  if(time > 99 * 60)
    time /= 60;
	
  text = [NSString stringWithFormat:@"%c%-2.2d", sign, time/60];
  [time_min setStringValue:text];
  text = [NSString stringWithFormat:@"%-2.2d", time%60];
  [time_sec setStringValue:text];
}

- (void)update_sinfo
{
  NSString *time = nil, *pos, *title, *infot;
  int max_len;
  PlaylistEntry *entry;
  
  if( [Playlist count] == 0 ) {
    [sinfo setStringValue:@""];
    return;
  }
  
  if ( [cfg playlist_position] >= [Playlist count] )
    [cfg setplaylist_position:0];
  
  entry = [Playlist entryAtIndex:[cfg playlist_position]];
	
  title = [entry title];
  if ( title == nil ) {
    title = [[entry filename] lastPathComponent];
  }
	
  max_len = ([self frame].size.width - 35) / 5;
	
  pos = [NSString stringWithFormat:@"%d. ", [cfg playlist_position]+1];
	
  if ( [entry length] != -1 ) {
    time = [NSString stringWithFormat:@"%d:%-2.2d",
	     [entry length]/60000, ([entry length]/1000)%60];
    max_len -= [time length];
    infot = [NSString stringWithFormat:@"%s%-*.*s%s",
	     [pos cString], max_len-[pos length], max_len-[pos length], 
	     [title cString], [time cString]];
    
  } else
    infot = [NSString stringWithFormat:@"%s%-*.*s",
	     [pos cString], max_len-[pos length], max_len-[pos length],
	     [title cString]];
  
  [sinfo setStringValue:infot];
}

- (void)update_info
{
  PlaylistEntry *entry;
  NSString *sel_text, *tot_text;
  int i, selection=0, total=0;
  BOOL selection_more = FALSE, total_more = FALSE;

  for ( i = 0; i < [Playlist count]; i++ ) {
    entry = [Playlist entryAtIndex:i];
    if ( [entry length] != -1 )
      total += [entry length];
    else
      total_more = TRUE;
    if([entry selected]) {
      if ( [entry length] != -1)
	selection += [entry length];
      else
	selection_more = TRUE;
    }
  }

  selection/=1000;
	
  if ( selection > 0 || (selection == 0 && !selection_more) ) {
    if(selection>3600)
      sel_text = [NSString stringWithFormat:@"%d:%-2.2d:%-2.2d%s",
		   selection/3600,
		   (selection/60)%60,
		      selection%60, (selection_more?"+":"")];
    else
      sel_text = [NSString stringWithFormat:@"%d:%-2.2d%s",
		   selection/60, selection%60,
			     (selection_more?"+":"")];
  } else
    sel_text = @"?";

  total /= 1000;
  if ( total > 0 || (total==0 && !total_more )) {
    if(total>3600)
      tot_text = [NSString stringWithFormat:@"%d:%-2.2d:%-2.2d%s",
       total/3600,(total/60)%60,total%60,total_more?"+":""];
    else
      tot_text = [NSString stringWithFormat:@"%d:%-2.2d%s",
		total/60,total%60,total_more?"+":""];
  }
  else
    tot_text = @"?";
  [info setStringValue:[NSString stringWithFormat:@"%@/%@", sel_text, 
			 tot_text]];
}


- (void)playlistListClicked:sender
{
  if ( [sender selected] != -1 ) {
    [cfg setplaylist_position:[sender selected]];
    [self play];
  }
}

- (void)play
{
  if ( [Playlist count] ) {
    if ( [cfg playlist_position] > [Playlist count] ) {
      [cfg setplaylist_position:0];
    }
    
    [Input playFile:
	[[Playlist entryAtIndex:[cfg playlist_position]] filename]];
    [playlistList centerCurrentIfNeeded];
    [playlistList setNeedsDisplay:YES];
  }
}

- (void)forward
{
  if ( [Playlist count] ) {
    if ( [Input isPlaying] )
      [Input stop];
    [Playlist next];
    [self play];
  }
}

- (void)prev
{
  if ( [Playlist count] ) {
    if ( [Input isPlaying] )
      [Input stop];
    [Playlist prev];
    [self play];
  }
}

- (void)songInfoChanged:(NSNotification *)notification
{
  NSDictionary *songinfo;

  songinfo = [notification userInfo];
  if ( [songinfo objectForKey:@"length"] ) 
    [self songIsPlaying:[songinfo objectForKey:@"title"]
		 length:[[songinfo objectForKey:@"length"] intValue]];
}

- (void)songEnded:(NSNotification *)notification
{
  [self eofReached];
}

- (void)vis_timeout:(unsigned char *)data
{
  if ( (([self frame].size.width-275)/25) >= 3 )
    [vis timeout:data];
}

@end
