/**
 * OpenAmp Audio Stream
 *
 * Wilfredo Sanchez | wsanchez@apple.com
 * September 20, 1998
 **/

#import <Foundation/NSObject.h>
#import <SoundKit/NXSoundDevice.h>

@class NXPlayStream;
@class NXSoundOut;
@class NXSoundParameters;
@class NSLock;
@class NSDictionary;

@interface SoundStream : NSObject
{
@public
  NXPlayStream*      myPlayStream;
  NXSoundOut*        mySoundDevice;
  NXSoundParameters* myStreamParameters;

  NSLock* myPlayingLock;
  NSLock* myCounterLock;

  int myQueuedBuffersCount;
  int myRemainingBuffersCount;

  int frequencyRate;
  int numChannels;
  int written;
  int ebps;
  int bps;
  NXSoundParameterTag format;
  int bytes_output;
  NSMutableDictionary *buffer_sizes;
}

- (BOOL)openWithFormat:(int)afmt rate:(int)rate channels:(int)nch;
- (void)dealloc;
- (void)write:(void *)ptr length:(int)length;
- (void)wait;
- (void)close;
- (void)pause:(short)p;
- (BOOL)isActive;
- (int)getOutputTime;
- (int)getWrittenTime;
- (int)getFree;

@end
