/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
 */

#import "MainView.h"
#import "Skin.h"
#import "Config.h"
#import "Button.h"
#import "TextBox.h"
#import "MenuRow.h"
#import "Slider.h"
#import "MonoStereo.h"
#import "Number.h"
#import "EqView.h"
#import "AppDelegate.h"
#import "PlayStatus.h"
#import "MainWindow.h"
#import "PlaylistEntry.h"
#import "Plugins.h"
#import "PlaylistView.h"
#import "SVisualization.h"

@implementation MainView

- (BOOL)isFlipped
{
  return YES;
}

+ (NSSize)calcSize
{
  NSSize size;

  if([cfg doublesize]) {
    size.width = 550;
    size.height = [cfg player_shaded] ? 28 : 232;
  } else {
    size.width = 275;
    size.height = [cfg player_shaded] ? 14 : 116;			
  }
  return size;
}

- (void)removeIfNeeded:(NSView *)view
{
  if ( [view superview] != nil )
    [view removeFromSuperviewWithoutNeedingDisplay];
}

- (void)addSubviewIfNeeded:(NSView *)view
{
  if ( [view superview] == nil )
    [self addSubview:view];
}

- (void)toggleShaded
{
  NSSize size;
  NSRect frame;
  NSPoint new_pos;
  
  frame = [[self window] frame];
  new_pos = frame.origin;
  [cfg setplayer_shaded:![cfg player_shaded]];
  size = [MainView calcSize];

  if ( ![cfg player_shaded] ) {
    [sprev removeFromSuperview];
    [splay removeFromSuperview];
    [spause removeFromSuperview];
    [sstop removeFromSuperview];
    [sfwd removeFromSuperview];
    [seject removeFromSuperview];
    [svis removeFromSuperview];
    [self removeIfNeeded:sposbar];
    [self removeIfNeeded:stime_min];
    [self removeIfNeeded:stime_sec];
    new_pos.y = new_pos.y + frame.size.height - size.height;
  } else {
    [self addSubview:sprev];
    [self addSubview:splay];
    [self addSubview:spause];
    [self addSubview:sstop];
    [self addSubview:sfwd];
    [self addSubview:seject];
    [self addSubview:svis];
    if ( [Input isPlaying] ) {
      [self addSubview:sposbar];
      [self addSubview:stime_min];
      [self addSubview:stime_sec];
    }
    new_pos.y = new_pos.y - size.height + frame.size.height;
  }
  frame = NSMakeRect(new_pos.x, new_pos.y, size.width,size.height);
  [[self window] setFrame:frame display:YES];
}

- (void)shade_pressed:button
{
  [self toggleShaded];
}

- (void)button_pressed:button
{
}


- (void)showMenu:(NSMenu *)amenu origin:(NSPoint)origin 
{
  NSRect frame, mframe;
  NSMenuView *menuView;
  NSWindow *menuWindow;

  menuView = [[NSMenuView alloc] initWithFrame:NSMakeRect(0,0,0,0)];
  [menuView setMenu:amenu];
  [menuView update];
  [menuView setNeedsSizing:YES];
  [menuView sizeToFit];
  menuWindow = [[NSWindow alloc]  
		 initWithContentRect:[menuView frame]
			   styleMask:NSBorderlessWindowMask
			     backing:NSBackingStoreBuffered
			       defer:FALSE];
  [menuWindow setLevel:NSPopUpMenuWindowLevel];
  [menuWindow setContentView:menuView];
    
  mframe = [menuView frame];
  frame = [[self window] frame];
  frame.origin.y = origin.y + frame.size.height - mframe.size.height;
  frame.origin.x = origin.x;
  [menuWindow setFrameOrigin:NSMakePoint(frame.origin.x, frame.origin.y)];
  
  [menuWindow makeKeyAndOrderFront:self];
  [menuView trackWithEvent:[NSApp currentEvent]];
  [menuWindow orderOut:self];
}


- (void)menu_pressed:button
{
  NSPoint o;
  o = [button frame].origin;
  o.y = [[self window] frame].origin.y - 14;
  o.x += [[self window] frame].origin.x;
  [self showMenu:[NSApp mainMenu] origin:o];
}

- (Button *)playlistButton
{
  return playlist;
}

- (Button *)eqButton
{
  return eq;
}

- (void)close_button:button
{
  [NSApp terminate:self];
}


- (int)volume_frame_cb:(int)pos
{
  return (int)rint((pos/52.0)*28);  
}


- (void)volume_motion_cb:(id)slider
{
  int v = (int)rint(([slider intValue]/51.0)*100);
  [[NSApp delegate] lockMainInfoText:
	  [NSString stringWithFormat:@"VOLUME: %d%%", v]];
  [cfg setvolume:[slider intValue]];
  [Input updateVolume];
}

- (void)volume_release_cb:(id)slider
{
  [[NSApp delegate] unlockMainInfoText];
}

- (int)balance_frame_cb:(int)pos
{
  return ((abs(pos-12)*28)/13);
}

- (void)balance_motion_cb:(id)slider
{
  int b;
  int v = (int)rint(([volume intValue]/51.0)*100);
  NSString *s = nil;
  int pos = [slider intValue];
  
  if ( pos < 12 ) {
    b=((12-pos)*100)/12;
    s = [NSString stringWithFormat:@"BALANCE: %d%% LEFT",b];
    [Input setVolumeLeft:v right:(int)rint(((100-b)/100.0)*v)];
  } else if( pos == 12 ) {
    s = @"BALANCE: CENTER";
    [Input setVolumeLeft:v right:v];
  }  else if ( pos > 12 ) {
    b=((pos-12)*100)/12;
    s = [NSString stringWithFormat:@"BALANCE: %d%% RIGHT",b];
    [Input setVolumeLeft:(int)rint(((100-b)/100.0)*v) right:v];
  }
  [[NSApp delegate] lockMainInfoText:s];
  [cfg setbalance:pos];
}

- (void)balance_release_cb:(id)slider
{
  [[NSApp delegate] unlockMainInfoText];
}

- (void)pos_motion_cb:(id)slider
{
  int length,time;
  NSString *s;
//  length=playlist_get_current_length()/1000;
  length = 200;
  time=(length*[slider intValue])/219;
  s = [NSString stringWithFormat:@"SEEK TO: %d:%-2.2d/%d:%-2.2d (%d%%)",
    time/60,time%60,length/60,length%60,(length!=0)?(time*100)/length:0];
  [[NSApp delegate] lockMainInfoText:s];
}

- (void)pos_release_cb:(id)slider
{
  [[NSApp delegate] unlockMainInfoText];
}

- (int)spos_frame_cb:(int)pos
{
#if 0
  if(pos<6)
    mainwin_sposition->hs_knob_nx = mainwin_sposition->hs_knob_px = 17;
  else if(pos<9)
    mainwin_sposition->hs_knob_nx = mainwin_sposition->hs_knob_px = 20;
  else
    mainwin_sposition->hs_knob_nx = mainwin_sposition->hs_knob_px = 23;
#endif
  return 1;
}

- (void)spos_motion_cb:(id)slider
{
}

- (void)spos_release_cb:(id)slider
{
  [[NSApp delegate] unlockMainInfoText];
}

- (void)showFileInfoBox:(NSString *)filename
{
  if ( filename != nil ) {
    [Input fileInfoBox:filename];
  }
}

- (void)clutter_press:sender
{
  int sel = [sender selectedMenuItem];
  NSPoint o = [[self window] frame].origin;
  int idx;
  id <NSMenuItem> item;
  
  switch ( sel ) {
  case MENUROW_OPTIONS:
    o.x = [sender frame].origin.x+o.x + 8;
    o.y = o.y - [sender frame].origin.y;
    idx = [[NSApp menu] indexOfItemWithTitle:@"Options"];
    item = [[NSApp menu] itemAtIndex:idx];
    [self showMenu:[item submenu] origin:o];
    [sender clearSelection];
    break;
    
  case MENUROW_ALWAYS:
    [cfg setalways_on_top:![cfg always_on_top]];
    [((MainWindow *)[self window]) updateAlwaysOnTop];
    break;
    
  case MENUROW_FILEINFOBOX:
    [self showFileInfoBox:[Input playingFile]];
    break;
    
  case MENUROW_DOUBLESIZE:
    [cfg setdoublesize:![cfg doublesize]];
    break;
    
  case MENUROW_VISUALIZATION:
    o.x = [sender frame].origin.x+o.x + 8;
    o.y = o.y - [sender frame].origin.y - 36;
    idx = [[NSApp menu] indexOfItemWithTitle:@"Visualization"];
    item = [[NSApp menu] itemAtIndex:idx];
    [self showMenu:[item submenu] origin:o];
    [sender clearSelection];
    break;
  }
  
}

- initWithFrame:(NSRect)frame
{
  id left, right;
  NSPoint menuNormal, menuPushed, closeNormol, closePushed;
  NSPoint leftPushed, leftNormal, rightNormal, rightPushed;
  SEL leftSel, rightSel;
  id adel = [NSApp delegate];
  
  menuNormal = NSMakePoint(0,0);
  menuPushed = NSMakePoint(0,9);
  closeNormol = NSMakePoint(18,0);
  closePushed = NSMakePoint(19,9);

  if ( [cfg close_box_on_left] ) {
    leftSel = @selector(close_button:);
    leftNormal = closeNormol;
    leftPushed = closePushed;
    rightSel = @selector(menu_pressed:);
    rightNormal = menuNormal;
    rightPushed = menuPushed;
  } else {
    rightSel = @selector(close_button:);
    rightNormal = closeNormol;
    rightPushed = closePushed;
    leftSel = @selector(menu_pressed:);
    leftNormal = menuNormal;
    leftPushed = menuPushed;
  }
  
  [super initWithFrame:frame];

  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(songInfoChanged:)
	   name:SongInfoChangedNotification
	 object:nil];

  [[NSNotificationCenter defaultCenter] 
    addObserver:self
       selector:@selector(songEnded:)
	   name:SongEndedNotification
	 object:nil];

  left = [[Button alloc] init:NSMakeRect(6,3,9,9)
			     :leftNormal
			     :leftPushed
			     :self
			     :leftSel
			     :@selector(titlebar)];
  [self addSubview:left];

  right = [[Button alloc] init:NSMakeRect(264,3,9,9)
			      :rightNormal
			      :rightPushed
			      :self
			      :rightSel
			      :@selector(titlebar)];
  [self addSubview:right];

  if ( [cfg close_box_on_left] ) {
    menu = right;
    quit = left;
  } else {
    menu = left;
    quit = right;
  }
  [menu sendActionOn:NSLeftMouseDownMask];


  minimize = [[Button alloc] init:NSMakeRect(244,3,9,9)
					:NSMakePoint(9,0)
					:NSMakePoint(9,9)
					:self
					:@selector(button_pressed:)
					:@selector(titlebar)];
  [minimize setAllowDraw:NO];
  [self addSubview:minimize];

  shade = [[Button alloc] init:NSMakeRect(254,3,9,9)
			      :NSMakePoint(0,[cfg player_shaded] ? 27 : 18)
			      :NSMakePoint(9,[cfg player_shaded] ? 27 : 18 )
			      :self
			      :@selector(shade_pressed:)
			      :@selector(titlebar)];
  [shade setAllowDraw:NO];
  [self addSubview:shade];


  playlist_prev = [[Button alloc] init:NSMakeRect(16,88,23,18)
					     :NSMakePoint(0,0)
					     :NSMakePoint(0,18)
					     :adel
					     :@selector(prev_pressed:)
					     :@selector(cbuttons)];
  [self addSubview:playlist_prev];
  play = [[Button alloc] init:NSMakeRect(39,88,23,18)
				    :NSMakePoint(23,0)
				    :NSMakePoint(23,18)
				    :adel
				    :@selector(play_pressed:)
				    :@selector(cbuttons)];
  [self addSubview:play];
  pause = [[Button alloc] init:NSMakeRect(62,88,23,18)
				     :NSMakePoint(46,0)
				     :NSMakePoint(46,18)
				     :adel
				     :@selector(pause_pressed:)
				     :@selector(cbuttons)];
  [self addSubview:pause];
  stop = [[Button alloc] init:NSMakeRect(85,88,23,18)
				    :NSMakePoint(69,0)
				    :NSMakePoint(69,18)
				    :adel
				    :@selector(stop_pressed:)
				    :@selector(cbuttons)];
  [self addSubview:stop];
  fwd =   [[Button alloc] init:NSMakeRect(108,88,22,18)
				     :NSMakePoint(92,0)
				     :NSMakePoint(92,18)
				     :adel
				     :@selector(fwd_pressed:)
				     :@selector(cbuttons)];
  [self addSubview:fwd];
  eject = [[Button alloc] init:NSMakeRect(136,89,22,16)
				     :NSMakePoint(114,0)
				     :NSMakePoint(114,16)
				     :adel
				     :@selector(eject_pressed:)
				     :@selector(cbuttons)];
  [self addSubview:eject];


  sprev = [[Button alloc] init:NSMakeRect(169,4,8,7)
			      :adel
			      :@selector(prev_pressed:)];
  if ( [cfg player_shaded] )
    [self addSubview:sprev];

  splay = [[Button alloc] init:NSMakeRect(177,4,10,7)
			      :adel
			      :@selector(play_pressed:)];
  if ( [cfg player_shaded] )
    [self addSubview:splay];

  spause = [[Button alloc] init:NSMakeRect(187,4,10,7)
			       :adel
			       :@selector(pause_pressed:)];
  if ( [cfg player_shaded] )
    [self addSubview:spause];

  sstop = [[Button alloc] init:NSMakeRect(197,4,9,7)
			       :adel
			       :@selector(stop_pressed:)];
  if ( [cfg player_shaded] )
    [self addSubview:sstop];

  sfwd  = [[Button alloc] init:NSMakeRect(206,4,8,7)
			       :adel
			       :@selector(fwd_pressed:)];
  if ( [cfg player_shaded] )
    [self addSubview:sfwd];

  seject = [[Button alloc] init:NSMakeRect(216,4,9,7)
			       :adel
			       :@selector(eject_pressed:)];
  if ( [cfg player_shaded] )
    [self addSubview:seject];
  

  shuffle = [[Button alloc] init:NSMakeRect(164,89,46,15)
				:NSMakePoint(28,0)
				:NSMakePoint(28,15)
				:NSMakePoint(28,30)
				:NSMakePoint(28,45)
				:adel
				:@selector(shuffle_pressed:)
				:@selector(shufrep)];
  [self addSubview:shuffle];
  [shuffle toggle:[cfg shuffle]];

  repeat = [[Button alloc] init:NSMakeRect(210,89,28,15)
			       :NSMakePoint(0,0)
			       :NSMakePoint(0,15)
			       :NSMakePoint(0,30)
			       :NSMakePoint(0,45)
			       :adel
			       :@selector(repeat_pressed:)
			       :@selector(shufrep)];
  [self addSubview:repeat];
  [repeat toggle:[cfg repeat]];

  eq = [[Button alloc] init:NSMakeRect(219,58,23,12)
			       :NSMakePoint(0,61)
			       :NSMakePoint(46,61)
			       :NSMakePoint(0,73)
			       :NSMakePoint(46,73)
			       :adel
			       :@selector(hideShowEq:)
			       :@selector(shufrep)];
  [self addSubview:eq];
  [eq toggle:[cfg equalizer_visible]];

  playlist = [[Button alloc] init:NSMakeRect(242,58,23,12)
			       :NSMakePoint(23,61)
			       :NSMakePoint(69,61)
			       :NSMakePoint(23,73)
			       :NSMakePoint(69,73)
			       :adel
			       :@selector(hideShowPlaylist:)
			       :@selector(shufrep)];
  [self addSubview:playlist];
  [playlist toggle:[cfg playlist_visible]];


  info_box = [[TextBox alloc] initWithFrame:NSMakeRect(112, 27, 153, 1)
					   :self
					   :@selector(text)];
  [self addSubview:info_box];
  [info_box setScroll:[cfg autoscroll]];
  [self updateInfoText];

  rate_box = [[TextBox alloc] initWithFrame:NSMakeRect(111, 43, 15, 0)
					   :self
					   :@selector(text)];
  [self addSubview:rate_box];

  freq_box = [[TextBox alloc] initWithFrame:NSMakeRect(156, 43, 10, 0)
					   :self
					   :@selector(text)];
  [self addSubview:freq_box];

  menurow = [[MenuRow alloc] initWithPoint:NSMakePoint(10,22)
					  :NSMakePoint(304,0)
					  :NSMakePoint(304,44)
					  :self
					  :@selector(clutter_press:)
					  :@selector(titlebar)];
  [self addSubview:menurow];

  volume = [[Slider alloc] initWithFrame:NSMakeRect(107,57,68,13)
					:NSMakePoint(15,420)
					:NSMakePoint(0, 420)
					:NSMakeSize(14,11)
					:15
					:0
					:0
					:51
					:self
					:@selector(volume_frame_cb:)
					:@selector(volume_motion_cb:)
					:@selector(volume_release_cb:)
					:@selector(volume)];
  [volume setIntValue:[cfg volume]];
  [self addSubview:volume];

  balance = [[Slider alloc] initWithFrame:NSMakeRect(177,57,38,13)
					 :NSMakePoint(15,420)
					 :NSMakePoint(0, 420)
					 :NSMakeSize(14,11)
					 :15
					 :9
					 :0
					 :24
					 :self
					 :@selector(balance_frame_cb:)
					 :@selector(balance_motion_cb:)
					 :@selector(balance_release_cb:)
					 :@selector(balance)];
  [balance setIntValue:[cfg balance]];
  [self addSubview:balance];

  monostereo = [[MonoStereo alloc] initPos:NSMakePoint(212, 41)
					  :@selector(monostereo)];
  [self addSubview:monostereo];

  playstatus = [[PlayStatus alloc] initWithPos:NSMakePoint(24,28)];
  [self addSubview:playstatus];

  minus_num = [[Number alloc] initPos:NSMakePoint(36,26) 
				     :@selector(numbers)];
  tenmin_num = [[Number alloc] initPos:NSMakePoint(48,26) 
				     :@selector(numbers)];
  min_num = [[Number alloc] initPos:NSMakePoint(60,26) 
				     :@selector(numbers)];
  tensec_num = [[Number alloc] initPos:NSMakePoint(78,26) 
				     :@selector(numbers)];
  sec_num = [[Number alloc] initPos:NSMakePoint(90,26) 
				     :@selector(numbers)];

  posbar = [[Slider alloc] initWithFrame:NSMakeRect(16,72,248,10)
					 :NSMakePoint(248,0)
					 :NSMakePoint(278, 0)
					 :NSMakeSize(29,10)
					 :10
					 :0
					 :0
					 :219
					 :self
					 :0
					 :@selector(pos_motion_cb:)
					 :@selector(pos_release_cb:)
					 :@selector(posbar)];
  
//  [self addSubview:posbar];

  sposbar = [[Slider alloc] initWithFrame:NSMakeRect(226,4,17,7)
					 :NSMakePoint(17,36)
					 :NSMakePoint(17,36)
					 :NSMakeSize(3,7)
					 :36
					 :0
					 :1
					 :13
					 :self
					 :@selector(spos_frame_cb:)
					 :@selector(spos_motion_cb:)
					 :@selector(spos_release_cb:)
					 :@selector(titlebar)];
  stime_min = [[TextBox alloc] initWithFrame:NSMakeRect(130, 4, 15, 1)
					   :self
					   :@selector(text)];
  stime_sec = [[TextBox alloc] initWithFrame:NSMakeRect(147, 4, 10, 1)
					   :self
					   :@selector(text)];
  if ( [cfg player_shaded] ) {
    [self addSubview:stime_min];
    [self addSubview:stime_sec];
  }

  vis = [[Visualization alloc] initWithFrame:NSMakeRect(24, 43, 76, 16)];
  [self addSubview:vis];

  svis = [[SVisualization alloc] initWithFrame:NSMakeRect(79,4, 38, 7)];
  if ( [cfg player_shaded] )
    [self addSubview:svis];

  return self;
}


- (void)drawRect:(NSRect)rect 
{
  [[currentSkin main] 
    compositeToPoint:NSMakePoint(0,[self frame].size.height)
	   operation:NSCompositeCopy];  

  if([[self window] isKeyWindow] || ![cfg dim_titlebar])
    [[currentSkin titlebar] compositeToPoint:NSMakePoint(0,14)
	   fromRect:flipRect(NSMakeRect(27,29*[cfg player_shaded], 275, 14),
			     [currentSkin titlebar])
	  operation:NSCompositeCopy];
  else
    [[currentSkin titlebar] compositeToPoint:NSMakePoint(0,14)
	   fromRect:flipRect(NSMakeRect(27,(27*[cfg player_shaded])+15, 275,
					14), [currentSkin titlebar])
	  operation:NSCompositeCopy];
}

- (void)mouseDown:(NSEvent *)theEvent 
{
  NSPoint startPoint, curPoint;
  NSRect frame, eqFrame, plFrame;
  int xdif, ydif;
  BOOL move_eq = NO, move_playlist = NO;
  NSWindow *plWindow = nil, *eqWindow = nil;
  int sd = [cfg snap_distance];
  int w = frame.size.width;
  int h = frame.size.height;
  int sw = [[NSScreen mainScreen] frame].size.width;
  int sh = [[NSScreen mainScreen] frame].size.height;

  startPoint = [theEvent locationInWindow];

  frame = [[self window] frame];

  if( [cfg equalizer_visible] ) {
    eqWindow = [[NSApp delegate] eqWindow];
    eqFrame = [eqWindow frame];
    if ( eqFrame.origin.x != frame.origin.x 
	 || eqFrame.origin.y != frame.origin.y )
      move_eq = is_docked(frame.origin.x, frame.origin.y,
			  frame.size.width, frame.size.height,
			  eqFrame.origin.x, eqFrame.origin.y,
			  eqFrame.size.width, eqFrame.size.height);
  }
  if ( [cfg playlist_visible] ) {
    plWindow = [[NSApp delegate] playlistWindow];
    plFrame = [plWindow frame];
    if ( plFrame.origin.x != frame.origin.x 
	 || plFrame.origin.y != frame.origin.y )
      move_playlist = is_docked(frame.origin.x, frame.origin.y,
				frame.size.width, frame.size.height,
				plFrame.origin.x, plFrame.origin.y,
				plFrame.size.width, plFrame.size.height);
  }

  if (startPoint.y > frame.size.height-14 || [cfg easy_move] ) {
    startPoint = [[self window] convertBaseToScreen:startPoint];
    xdif = startPoint.x - frame.origin.x;
    ydif = startPoint.y - frame.origin.y;
    while (1) {
      theEvent = [[self window] nextEventMatchingMask:(NSLeftMouseDraggedMask | NSLeftMouseUpMask)];
      curPoint = [theEvent locationInWindow];
      curPoint = [[self window] convertBaseToScreen:curPoint];
      curPoint.x = curPoint.x-xdif;
      curPoint.y = curPoint.y-ydif;

      frame = [[self window] frame];

      if ( [cfg snap_windows] ) {
	if(curPoint.x > -sd && curPoint.x < sd)
	  curPoint.x = 0;
	if((curPoint.x + w) > sw - sd && (curPoint.x + w) < sw + sd)
	  curPoint.x = sw - w;
	if(curPoint.y > -sd && curPoint.y < sd)
	  curPoint.y = 0;
	if((curPoint.y + h) > sh - sd && (curPoint.y + h) < sh + sd) 
	  curPoint.y = sh - h;
      }

      if ( [cfg playlist_visible] ) {
	plFrame = [plWindow frame];

	if(move_playlist) {
	  [plWindow setFrameOrigin:NSMakePoint(
	    (plFrame.origin.x - frame.origin.x) + curPoint.x,
	    (plFrame.origin.y - frame.origin.y) + curPoint.y)];
	} else {
	  dock(&curPoint.x, &curPoint.y, w, h, plFrame.origin.x, 
	       plFrame.origin.y, plFrame.size.width, 
	       plFrame.size.height);
	}
      }
      

      if ( [cfg equalizer_visible] ) {
	eqFrame = [eqWindow frame];

	if(move_eq) {
	  [eqWindow setFrameOrigin:NSMakePoint(
	    (eqFrame.origin.x - frame.origin.x) + curPoint.x,
	    (eqFrame.origin.y - frame.origin.y) + curPoint.y)];
	} else {
	  dock(&curPoint.x, &curPoint.y, w, h, eqFrame.origin.x, 
	       eqFrame.origin.y, eqFrame.size.width, 
	       eqFrame.size.height);
	}
      }

      [[self window] setFrameOrigin:NSMakePoint(curPoint.x, curPoint.y)];
      

      if ([theEvent type] == NSLeftMouseUp)
	break;
    }
  }
  
}

- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
  return YES;
}

- (void)updateInfoText
{
  static NSString *version_text = nil; 

  if ( version_text == nil )
    version_text = [[NSString stringWithFormat:@"%@ %@", PACKAGE, VERSION]
		     retain];
  
  if ( infoTextLocked == NO ) {
    [info_box setStringValue:info_text ? info_text : version_text];
  }
}

- (void)lockInfoText:(NSString *)string
{
  infoTextLocked = YES;
  [info_box setStringValue:string];
}


- (void)unlockInfoText
{
  infoTextLocked = NO;
  [self updateInfoText];
}

- (void)setInfoText:(NSString *)string
{
  [info_text release];
  info_text = [string retain];
  [self updateInfoText];
}

- (void)setRate:(int)rate
{
  NSString *rate_string;
  if( rate != -1){
    rate /= 1000; 
    if( rate < 1000) {
      rate_string = [NSString stringWithFormat:@"%3d", rate];
    } else {
      rate /= 100;
      rate_string = [NSString stringWithFormat:@"%2dH", rate];
    }
    [rate_box setStringValue:rate_string];
  }
}

- (void)setRate:(int)rate
	  freq:(int)freq
   numChannels:(int)channels;

{
#if 1
  if ( rate == 0 && freq == 0 && channels == 0 ) {
    [rate_box setStringValue:@""];
    [freq_box setStringValue:@""];
    [self setInfoText:nil];
    [monostereo setNumChannels:0];

    [playstatus setStatus:STATUS_STOP];
    [self removeIfNeeded:minus_num];
    [self removeIfNeeded:tenmin_num];
    [self removeIfNeeded:min_num];
    [self removeIfNeeded:tenmin_num];
    [self removeIfNeeded:sec_num];
    [self removeIfNeeded:tensec_num];
    [self removeIfNeeded:posbar];
    [self removeIfNeeded:sposbar];
    [self removeIfNeeded:stime_min];
    [self removeIfNeeded:stime_sec];
    [self vis_clear];
    [self svis_clear];
    [self setNeedsDisplay:YES];
  } else {
    [self addSubviewIfNeeded:min_num];
    [self addSubviewIfNeeded:tenmin_num];
    [self addSubviewIfNeeded:min_num];
    [self addSubviewIfNeeded:sec_num];
    [self addSubviewIfNeeded:minus_num];
    [self addSubviewIfNeeded:tensec_num];

    [self setRate:rate];
    [freq_box setIntValue:freq];
    [monostereo setNumChannels:channels];
    [playstatus setStatus:STATUS_PLAY];
    [self addSubviewIfNeeded:posbar];
    if ( [cfg player_shaded] ) {
      [self addSubviewIfNeeded:sposbar];
      [self addSubviewIfNeeded:stime_min];
      [self addSubviewIfNeeded:stime_sec];
    }
  }
#endif
}


- (void)setNumbers:(int)minus 
		  :(int)_tenmin_num 
		  :(int)_min_num 
		  :(int)_tensec_num
		  :(int)_sec_num
{
  if ( ![cfg player_shaded] ) {
    [minus_num setNumber:minus];
    [tenmin_num setNumber:_tenmin_num];
    [min_num setNumber:_min_num];
    [tensec_num setNumber:_tensec_num];
    [sec_num setNumber:_sec_num];
  }
}

- (void)setSNumbers:(NSString *)min :(NSString *)sec
{
  if ( [cfg player_shaded] ) {
    [stime_min setStringValue:min];
    [stime_sec setStringValue:sec];
  }
}

- (void)songInfoChanged:(NSNotification *)notification
{
  NSDictionary *info = [notification userInfo];

  
  if ( [info objectForKey:@"title"] )
    [self setInfoText:[info objectForKey:@"title"]];

  if ( [info objectForKey:@"frequency"] ) {
    [self setRate:[[info objectForKey:@"rate"] intValue]
	     freq:[[info objectForKey:@"frequency"] intValue]
      numChannels:[[info objectForKey:@"numChannels"] intValue]];
  } else if ( [info objectForKey:@"rate"] ) {
    [self setRate:[[info objectForKey:@"rate"] intValue]];
  }
}

- (void)songEnded:(NSNotification *)notification
{
  [self setRate:0 freq:0 numChannels:0];
}

- (void)setPosbar:(int)val
{
  if ( ![cfg player_shaded] )
    [posbar setIntValue:val];
}

- (void)setSposbar:(int)val
{
  if ( [cfg player_shaded] )
    [sposbar setIntValue:val];
}

- (void)setPlayStatus:(PStatus)status
{
  [playstatus setStatus:status];
}

- (BOOL)becomeFirstResponder
{
  return YES;
}

- (BOOL)resignFirstResponder
{
  return YES;
}

- (BOOL)acceptsFirstResponder
{
  return YES;
}

- (void)vis_timeout:(unsigned char *)data
{
  [vis timeout:data];
}

- (void)svis_timeout:(unsigned char *)data
{
  [svis timeout:data];
}

- (void)svis_clear
{
  [svis clear];
}

- (void)vis_clear
{
  [vis clear];
}


@end
