/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/

#import "xing.h"
#import <string.h>
#import <Foundation/Foundation.h>
#import <AppKit/NSApplication.h>
#import <AppKit/NSPanel.h>
#import "mhead.h"
#import <stdlib.h>
#import <c.h>
#import "id3.h"
#import "Configure.h"
#import "Config.h"
#import "FileInfo.h"
#import "http.h"
#import "dxhead.h"

typedef struct
{
  int (*decode_init)(MPEG_HEAD * h,int framebytes_arg,int reduction_code,int transform_code,int convert_code,int freq_limit);
  void (*decode_info) (DEC_INFO * info);
  IN_OUT(*decode) (unsigned char *bs, short *pcm);
} AUDIO;

static AUDIO    Audio;
static AUDIO    AudioTable[2][2] =
{
  {
    {audio_decode_init , audio_decode_info, audio_decode},
    {audio_decode8_init, audio_decode8_info, audio_decode8},
  },
  {
    {i_audio_decode_init, i_audio_decode_info, i_audio_decode},
    {audio_decode8_init, audio_decode8_info, audio_decode8},
  }
};

xing *xip = nil;
int actually_decode = 1;

@implementation xing


- init
{
  decoding_lock = [[NSLock alloc] init];
  xip = self;
  return [super initWithDescription:@"Xing MPEG Decoder"];
}

- (BOOL)isOurFile:(NSString *)filename
{
  NSString *ext;

  if ( [filename hasPrefix:@"http://"] ) { 
    /* We assume all http:// are mpeg -- why do we do that? */
    return TRUE;
  }
  
  ext = [filename pathExtension];
  if(ext) {
    if([ext isEqualToString:@"mpg"] || [ext isEqualToString:@"mp2"] || 
       [ext isEqualToString:@"mp3"] || [ext isEqualToString:@"mpeg"]) {
      return YES;
    }
  }

  return NO;
}

- (BOOL)readHeadInfo:(NSString *)fileName 
		head:(MPEG_HEAD *)the_head
		info:(DEC_INFO *)the_info
	  framebytes:(int *)the_framebytes
	     bitrate:(int *)abitrate
	  xingHeader:(XHEADDATA *)xingHead
       hasXingHeader:(BOOL *)hasXingHeader
{
  FILE *tfp = fopen([fileName cString], "r");
  if ( tfp != NULL ) {
    WAVE_HEAD whead;
    unsigned char *buf, toc[100];
    int read, pos;
    int freq_limit = 24000;
    
#define HEAD_READ_SIZE 10000

    buf = malloc(HEAD_READ_SIZE);
    read = fread(buf, 1, HEAD_READ_SIZE, tfp);

    memcpy(&whead, buf, sizeof(whead));
    if ((whead.riff[0]=='R') && (whead.riff[1]=='I') && (whead.riff[2]=='F')
	&&(whead.riff[3]=='F'))
      {
	/* Second test to be sure */
	if ((whead.wave[0]=='W') && (whead.wave[1]=='A') 
	    && (whead.wave[2]=='V') && (whead.wave[3]=='E'))
	  {
	    /* This is a WAVE.MP3 - update buffer (???) */
	    buf += 72;
	    read -= 72;
	  }
      }

    *the_framebytes = head_info3(buf, read , the_head, abitrate, &pos);
    if (*the_framebytes == 0
	|| !audio_decode_init(the_head, *the_framebytes, 0,0,4,freq_limit)) {
      fclose(tfp);
      free(buf);
      return NO;
    }

    audio_decode_info(the_info);

    buf += pos;
    xingHead->toc=toc;
    if ( GetXingHeader(xingHead,buf) ) {
      *hasXingHeader = YES;
    } else
      *hasXingHeader = NO;
    
    free(buf);
    
    fclose(tfp);
    return YES;
  }
  return NO;
}

#define compute_tpf mcompute_tpf
static double compute_tpf(DEC_INFO *info, MPEG_HEAD *head)
{
  static int bs[4] = { 0,1152,1152,384 };
  double tpf;
  
  tpf = (double) bs[head->option];
  tpf /= (double)(info->samprate << (head->pad));
  return tpf;
}

#define compute_bpf mcompute_bpf
double compute_bpf(DEC_INFO *info, MPEG_HEAD *head, int bitrate)
{
  double bpf;
  
  switch(head->option) {
  case 3:
    bpf = bitrate / 1000;
    bpf *= 12000.0 * 4.0;
    bpf /= info->samprate << head->pad;
    break;
  case 2:
  case 1:
    bpf = bitrate / 1000;
    bpf *= 144000;
    bpf /= info->samprate << head->pad;
    break;
  default:
    bpf = 1.0;
  }
  
  return bpf;
}


- (int)computeSongLength:(NSString *)filename
{
  NSDictionary *attrs;
  unsigned long long end;
  int length = -1, aframebytes;
  MPEG_HEAD ahead;
  DEC_INFO adecinfo;
  XHEADDATA xHead;
  BOOL hasXhead;
  int abitrate;
  double tpf;
  BOOL res;

  if ( [filename hasPrefix:@"http://"] ) { 
    return -1;
  }
  
  attrs = [[NSFileManager defaultManager] 
	    fileAttributesAtPath:filename traverseLink:YES];
  end = [attrs fileSize];

  res = [self readHeadInfo:filename head:&ahead 
				    info:&adecinfo 
			      framebytes:&aframebytes
				 bitrate:&abitrate
			      xingHeader:&xHead
			   hasXingHeader:&hasXhead];

  if ( res ) {
    tpf = compute_tpf(&adecinfo, &ahead);
    if ( hasXhead )
      length = (int)(tpf*(double)xHead.frames*1000);
    else {
      int num_frames=(int)((double)end/compute_bpf(&adecinfo, &ahead, 
						   abitrate));
    length = (int)(num_frames*tpf*1000);
    }
  }

  return length;

#if 0
//  int sampRateIndex = 4 * head.id + head.sr_index;
  double    milliseconds_per_frame = 0;
  static int l[4] = {25, 3, 2, 1};
  int layer;
  static double ms_p_f_table[3][3] =
  {
    {8.707483f, 8.0f, 12.0f},
    {26.12245f, 24.0f, 36.0f},
    {26.12245f, 24.0f, 36.0f}
  };
  int totalFrames;
  NSDictionary *attrs;
  unsigned long long end;
  int length, aframebytes;
  MPEG_HEAD ahead;
  DEC_INFO adecinfo;
  int samprate;

  if ( [filename hasPrefix:@"http://"] ) { 
    return -1;
  }
  
  attrs = [[NSFileManager defaultManager] 
	    fileAttributesAtPath:filename traverseLink:YES];
  end = [attrs fileSize];

  if ( [filename isEqualToString:playingFileName] == NO ) {
    [self readHeadInfo:filename head:&ahead info:&adecinfo 
				     framebytes:&aframebytes];
  } else {
    ahead = head;
    adecinfo = decinfo;
    aframebytes = framebytes;
  }
  
  layer = l[ahead.option];
  samprate = adecinfo.samprate;
  
  if ((ahead.sync & 1) == 0)
     samprate = samprate / 2;    // mpeg25

   milliseconds_per_frame = ms_p_f_table[layer - 1][ahead.sr_index];

   if (end > 0)
   {
       totalFrames = end / aframebytes;
       length = (float) ((double) totalFrames * 
                      (double) milliseconds_per_frame);
   }
   else
   {
       length = 0;
   }
   return length;
#endif
}

- (NSDictionary *)getSongInfoForFile:(NSString *)filename
{
  NSMutableDictionary *info = [NSMutableDictionary dictionary];
  NSString *title;
  int len;

  if ( [filename hasPrefix:@"http://"] ) { 
    if ( playing_http && [filename isEqualToString:filename] )
      title = http_get_title(filename);
    else
      title = filename;
    [info setObject:title forKey:@"title"];
    len = -1;
  } else {
    NSDictionary *id3_info;
    
    id3_info = x_get_song_info(filename, [Configure id3Format]);
    [info addEntriesFromDictionary:id3_info];
    len = [self computeSongLength:filename];
  }
  [info setObject:[NSNumber numberWithInt:len] forKey:@"length"];
  return info;
}

static BOOL find_header(unsigned char *buf, int n, int *found_pos)
{
  int iCount;
  
  for(iCount = 0; iCount < n - 1 &&
	!(*buf == 0xFF && ((*(buf+1) & 0xF0) == 0xF0 || 
			   (*(buf+1) & 0xF0) == 0xE0)); 
      buf++, iCount++)
    ; // <=== Empty body!

  if (iCount != 0 && iCount < n - 1) {
    *found_pos = iCount;
    return YES;
  }
  return NO;


#if 0
  unsigned int pBuf = 0;
  BOOL found = NO;
  unsigned long head;
  unsigned char *tmp;
  
  while (pBuf+4 < n && found == NO ) {
    tmp = buf+pBuf;
    head=((unsigned long)tmp[0]<<24)|((unsigned long)tmp[1]<<16)|
      ((unsigned long)tmp[2]<<8)|(unsigned long)tmp[3];
    if ( xhead_check(head) )
      found = YES;
    else
      pBuf++;
  }

  *found_pos = pBuf;
  return found;
#endif
}

- (BOOL)fillBuffer
{
  if ( inputBytes < inputTrigger ) {
    int nread;

    memmove(buffer, currentInputBuffer, inputBytes);
    if ( playing_http )
      nread = http_read(buffer+inputBytes, BufferSize-inputBytes);
    else
      nread = fread(buffer+inputBytes, 1, BufferSize-inputBytes, fp);
    if ( nread <= 0 )
      return NO;

    inputBytes += nread;
    currentInputBuffer = buffer;
  }
  return YES;
}
			
- (BOOL)open_file:(NSString *)fileName
{
  BOOL res = NO;

  if ( [fileName hasPrefix:@"http://"] ) { 
    http_open(fileName);
    res = TRUE;
    playing_http = YES;
  } else {
    playing_http = NO;
    fp = fopen([fileName cString], "r");
    if ( fp != NULL ) {
      res = YES;
    }
  }

  if ( res ) {
    WAVE_HEAD whead;
    int freq_limit = 24000;
    NSDictionary *info;
    unsigned int pos;
    BOOL found;
    BOOL force8 = NO;
    int tries = 0, max_retries = 32;

    reduction_code = 0;
    convert_code = 0;

    if ( playing_http )
      BufferSize = (([Configure httpBufferSize] * 1024)
		    *[Configure httpPreBuffer])/100;
    else
      BufferSize = 60000;

    buffer = malloc(BufferSize);
    outputBuffer = malloc(BufferSize*2);
    currentInputBuffer = buffer;

    if (playing_http == NO )
      inputBytes = fread(buffer, 1, BufferSize, fp);
    else
      inputBytes = http_read(buffer, BufferSize);      

    if ( stop )
      return NO;

    if ( inputBytes <= 0 )
      return NO;

    memcpy(&whead, buffer, sizeof(whead));
    if ((whead.riff[0]=='R') && (whead.riff[1]=='I') && (whead.riff[2]=='F')
	&&(whead.riff[3]=='F'))
      {
	/* Second test to be sure */
	if ((whead.wave[0]=='W') && (whead.wave[1]=='A') 
	    && (whead.wave[2]=='V') && (whead.wave[3]=='E'))
	  {
	    /* This is a WAVE.MP3 - update buffer (???) */
	    currentInputBuffer += 72;
	    inputBytes -= 72;
	  }
      }

#if 0
    switch ([Configure downsample])
      {
      case 2:
	reduction_code=1;
	break;
      case 1:
	reduction_code=2;
	break;
      case 0:
      default:
	reduction_code=0;
	break;
      }
    
    if ( [Configure resolution] == 8 ) {
      convert_code += 8;
      force8 = YES;
    }
    
    if ( [Configure channels] == 1 )
      convert_code += 1;
#endif

    Audio = AudioTable[0][(int)force8];

#if 1
    if ( playing_http == NO ) 
      {
	do {
	  framebytes = head_info3(currentInputBuffer, inputBytes , &head,
				  &bitrate, &pos);
	  if ( framebytes == 0 && pos == 0 )
	    pos = 1; // must be a messed up frame, look for another
	  currentInputBuffer += pos;
	  inputBytes -= pos;
	  [self fillBuffer];

	  if ( framebytes == 0 && pos )
	    NSLog(@"Skipped %d bytes at begining of stream", pos);

	} while ( framebytes <= 0 && tries++ < max_retries );
      } 
    else 
#endif
      {
	int totalBytes = inputBytes;
	
	do {
	  do {
	    found = find_header(currentInputBuffer, inputBytes, &pos);
	    if ( found == NO ) {
	      if ( playing_http )
		inputBytes = http_read(buffer, BufferSize);
	      else
		inputBytes = fread(buffer, 1, BufferSize, fp);
	      currentInputBuffer = buffer;
	      totalBytes += inputBytes;
	    }
	  } while ( found == NO && totalBytes < BufferSize*3 && stop == NO );
	  if ( found ) {
	    currentInputBuffer += pos;
	    inputBytes -= pos;
	    framebytes = head_info3(currentInputBuffer, inputBytes , &head,
				    &bitrate, &pos);
	    if ( framebytes <= 0 ) {
	      framebytes = 0;
	      currentInputBuffer++;
	      inputBytes--;
	    }
	  }
	} while ( framebytes == 0 && tries++ < max_retries );
      }

    if (framebytes == 0
	|| !Audio.decode_init(&head, framebytes, reduction_code, 0, 
			      convert_code, freq_limit)) {
      if ( playing_http )
	http_close();
      else
	fclose(fp);
      NSRunAlertPanel(@"MacOSXAmp", @"Invalid MPEG File: %@", @"OK", nil, 
		      nil, fileName);      
      return NO;
      
    }

    Audio.decode_info(&decinfo);
    
    {
      int fmt;
      fmt = decinfo.bits == 16 ?  FMT_S16_NE : FMT_U8;
      
      if(![[Output output] openAudioFormat:fmt
				      rate:decinfo.samprate
			       numChannels:decinfo.channels] ) {
	fclose(fp);
	NSRunAlertPanel(@"MacOSXAmp", @"Couldn't open audio!", @"OK", nil, 
			nil);      
	return NO;
      }
      [Input updateVolume];
    }

    playingFileName = [fileName retain];
    info = [self getSongInfoForFile:fileName];
    [Input setInfoTitle:[info objectForKey:@"title"]
	         length:[[info objectForKey:@"length"] intValue]
		   rate:bitrate
	      frequency:decinfo.samprate
	    numChannels:decinfo.channels];
    if ( [cfg slow_cpu] )
      outputTrigger = BufferSize - 2500 * sizeof(short);
    else
      outputTrigger = 2500;
    inputTrigger = inputTrigger < framebytes ? framebytes : 2500;
    outputBytes = 0;
    return YES;
  } else {
    NSRunAlertPanel(@"MacOSXAmp", @"Could not open File: %@", @"OK", nil, 
		    nil, fileName);      
  }

  return NO;
}


int xhead_check(unsigned long head)
{
    if( (head & 0xffe00000) != 0xffe00000)
	return FALSE;
    if(!((head>>17)&3))
	return FALSE;
    if( ((head>>12)&0xf) == 0xf)
	return FALSE;
    if( ((head>>10)&0x3) == 0x3 )
	return FALSE;
    
    if( ((head>>19)&1)==1 && ((head>>17)&3)==3 && ((head>>19)&1)==1 )
	return FALSE;

    return TRUE;
}

- (void)decode_loop:(NSString *)filename
{
  BOOL eof = NO;
  NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
  
  [decoding_lock lock];

  if ( [self open_file:filename] ) {
    while ( eof == NO && stop == NO ) {
      NSAutoreleasePool *ppool = [[NSAutoreleasePool alloc] init];
      do {
	if ( [self fillBuffer] == NO ) {
	  eof = YES;
	  break;
	}
	if (inputBytes < framebytes)
	  break;
	
	mpg_out = Audio.decode(currentInputBuffer, 
			       (short *)(outputBuffer+outputBytes));
	if (mpg_out.in_bytes <= 0) {
	  // stream got screwed up, look for another header
	  int totalBytes = 0, pos;
	  BOOL found = NO;
	  do {
	    found = find_header(currentInputBuffer, inputBytes, &pos);
	    if ( found == NO ) {
	      totalBytes += inputBytes;
	      inputBytes = 0;
	      if ( [self fillBuffer] == NO ) {
		eof = YES;
		break;
	      }
	    }
	  } while ( found == NO && totalBytes < 128*1024 && stop == NO );
	  if ( found == NO ) {
	    eof = YES;
	    break;
	  } else {
	    NSLog(@"Skipped %d bytes in stream", totalBytes+pos);
	    inputBytes -= pos;
	    currentInputBuffer += pos;

#if 1
	    audio_decode_init(&head, framebytes, reduction_code, 0, 
			      convert_code, 24000);
#endif
	    
	    continue;
	  }	    
	}

	currentInputBuffer += mpg_out.in_bytes;
	inputBytes -= mpg_out.in_bytes;
	outputBytes+=mpg_out.out_bytes;

      } while ( outputBytes < outputTrigger && eof == NO && stop == NO );

      if (stop == NO && eof == NO && outputBytes) {

	[Input addVisPcmTime:[[Output output] writtenTime]
		      format:FMT_S16_NE
		 numChannels:decinfo.channels
		      length:outputBytes
			data:(void *)outputBuffer];
      
	outputBytes = [Effect
			modSampleData:(short int *)outputBuffer
			       length:outputBytes
			bitsPerSample:16
			  numChannels:decinfo.channels
				 freq:decinfo.samprate];

	while([[Output output] bufferFree] < outputBytes && stop == NO ) {
	  mysleep(10000);
	}
	
	[[Output output] writeAudioData:outputBuffer length:outputBytes];
	outputBytes = 0;
      }
      [ppool release];
    }
    if ( playing_http )
      http_close();
    else
      fclose(fp);
  }

  if ( stop == NO )
    [[Output output] wait];

  [[Output output] closeAudio];
  [filename release];
  [playingFileName release];
  playingFileName = nil;
  framebytes = 0;
  playing = NO;
  free(buffer);
  free(outputBuffer);
  [self donePlaying];
  [decoding_lock unlock];
  [pool release];
//  printf("exiting xing thread\n");
}

- (void)playFile:(NSString *)filename
{
  stop = NO;
  playing = YES;
  [NSApplication detachDrawingThread:@selector(decode_loop:)
			    toTarget:self
			  withObject:[filename retain]];
}

- (void)stop
{
  stop = YES;
  [decoding_lock lock];
  [decoding_lock unlock];
}

- (void)seek:(int) time
{
}

- (void)pause:(BOOL)p
{
  [[Output output] pause:p];
}

- (int)getTime
{
  return playing ? [[Output output] outputTime] : -1;
}

- (void)about
{
  static NibObject *aboutBox = nil;

  if (aboutBox == nil) {
    aboutBox = [[NibObject alloc] 
	 initWithNibName:@"About" 
			  bundle:[NSBundle bundleForClass:[self class]]];
  }
  [aboutBox show];
}

- (BOOL)hasAbout
{
  return YES;
}

- (void)configure
{
  static Configure *configure = nil;
  
  if ( configure == nil )
    configure = [[Configure alloc] init];
  
  [configure show];
}

- (BOOL)hasConfigure
{
  return YES;
}

- (void)fileInfoBox:(NSString *)filename
{
  static FileInfo *fileInfoBox = nil;
  if ( fileInfoBox ==  nil )
    fileInfoBox = [[FileInfo alloc] init];
  
  [fileInfoBox setFileName:filename];
  [fileInfoBox show];
}

- (BOOL)enabledByDefault
{
  return YES;
}

#define	LIMIT_DB_RATIO	3

- (void)setEq:(BOOL)on preamp:(float)preamp bands:(float *)b
{
  float band[10];
  int i;

  /** from freeamp **/
  
  eq_active=on;
  if(eq_active)
    {
      for(i=0;i<10;i++)
	{
	  band[i]=b[i]+preamp;
	}

#define eq_val() (float)pow(2,(double)(band[i])/10)
//#define eq_val() (float)pow(10,(double)(0-band[i]/LIMIT_DB_RATIO)/10)

      for ( i = 0; i < 10; i++ ) {
	switch (i) {
	case 0:
	case 1:
	case 2:
	case 3:
	case 4:
	case 5:
	  eq_mul[i] = eq_val();
	  break;
	case 6:
	  eq_mul[6] = eq_val();
	  eq_mul[7] = eq_mul[6];
	  break;
	case 7:
	  eq_mul[8] = eq_val();
	  eq_mul[9] = eq_mul[8];
	  eq_mul[10] = eq_mul[8];
	  eq_mul[11] = eq_mul[8];
	  break;
	case 8:
	  eq_mul[12] = eq_val();
	  eq_mul[13] = eq_mul[12];
	  eq_mul[14] = eq_mul[12];
	  eq_mul[15] = eq_mul[12];
	  eq_mul[16] = eq_mul[12];
	  eq_mul[17] = eq_mul[12];
	  eq_mul[18] = eq_mul[12];
	  eq_mul[19] = eq_mul[12];
	  break;
	case 9:
	  eq_mul[20] = eq_val();
	  eq_mul[21] = eq_mul[20];
	  eq_mul[22] = eq_mul[20];
	  eq_mul[23] = eq_mul[20];
	  eq_mul[24] = eq_mul[20];
	  eq_mul[25] = eq_mul[20];
	  eq_mul[26] = eq_mul[20];
	  eq_mul[27] = eq_mul[20];
	  eq_mul[28] = eq_mul[20];
	  eq_mul[29] = eq_mul[20];
	  eq_mul[30] = eq_mul[20];
	  eq_mul[31] = eq_mul[20];
	  break;
	  
	}
      }
    }
}

- (BOOL)eq_active
{
  return eq_active;
}

- (float *)eq
{
  return eq_mul;
}

- (BOOL)playing
{
  return playing;
}

@end


void xing_addvis(unsigned char *spectrum)
{
  [Input addVisTime:[[Output output] writtenTime]
	       data:spectrum
	       type:INPUT_VIS_ANALYZER];
}

int xing_analyzer_vis()
{
  return [Input getVisType] == INPUT_VIS_ANALYZER;
}

int xing_eq_active()
{
  return [xip eq_active];
}

float *xing_eq()
{
  return [xip eq];
}

void xbitrate_changed(int new_bitrate)
{
  [Input setInfoTitle:nil
	       length:-1
		 rate:new_bitrate*1000
	      frequency:-1
	    numChannels:-1];
}
