/*
 * SkySOUND Portable Replay Library
 *
 * MP3 Decoder originally Copyright (C) 1995-1997 Xing Technology
 * Corp.  http://www.xingtech.com
 *
 * Portions Copyright (C) 1998 GoodNoise
 * From the FreeAmp project : http://www.freeamp.org
 *
 * Portions Copyright (c) 1999 Jean-Michel HERVE
 *
 * This file is part of SkySOUND Portable Replay Library, and may only be
 * used, modified and distributed under the terms of the license provided in
 * your package, LICENSE.TXT. Please read it before going further.
 */

/****  csbtL3.c  ***************************************************

layer III

  include to  csbt.c

******************************************************************/
/*============================================================*/
/*============ Layer III =====================================*/
/*============================================================*/
void sbt_mono_L3(float *sample, short *pcm, int ch)
{
   int i;

   ch = 0;
   for (i = 0; i < 18; i++)
   {
      fdct32(sample, vbuf + vb_ptr);
      window_mpg(vbuf, vb_ptr, pcm);
      sample += 32;
      vb_ptr = (vb_ptr - 32) & 511;
      pcm += 32;
   }

}
/*------------------------------------------------------------*/
void sbt_dual_L3(float *sample, short *pcm, int ch)
{
   int i;
   float *osamp = sample;

#if 0
   if(xing_eq_active())
     {
       float crap, *eq_mul = xing_eq();
       for(i = 0; i < 576; i++ ) {
	 osamp[i] *= (eq_mul[i]);
       }
     }
#endif

   if (ch == 0) 
     {
      for (i = 0; i < 18; i++)
      {
	 fdct32(sample, vbuf + vb_ptr);
	 window_dual(vbuf, vb_ptr, pcm);
	 sample += 32;
	 vb_ptr = (vb_ptr - 32) & 511;
	 pcm += 64;
      }
     }
   else
      for (i = 0; i < 18; i++)
      {
	 fdct32(sample, vbuf2 + vb2_ptr);
	 window_dual(vbuf2, vb2_ptr, pcm + 1);
	 sample += 32;
	 vb2_ptr = (vb2_ptr - 32) & 511;
	 pcm += 64;
      }

   
#if 0
   if ( ch == 0 ) 
     {
   /** Scott **/
   {
     int l,r,val, i;
     float fl,fr,tmp;
     unsigned char spectrum[75];
     int scale[]={0,1,3,4,6,7,9,10,12,13,14,16,17,19,20,22,23,
		  25,29,33,36,40,44,48,52,56,60,64,68,72,76,80,
		  84,88,92,96,100,104,108,112,116,120,124,128,131,
		  135,139,143,147,151,155,166,177,188,199,210,221,
		  231,242,253,264,275,286,297,308,318,329,340,351,
		      362,373,384,395,406,416,575};
     int yscale[] = { 0,1,1,2,2,3,3,4,4,5,5,5,6,6,6,7,7,7,8,8,8,8,9,9,9,9,9,
		      10,10,10,10,10,11,11,11,11,11,11,12,12,12,12,12,12,13,
		      13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,15,15,15,
		      15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,
		      15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,
		      15,15};
     
     if(xing_analyzer_vis() )
       {
	 for(i=0;i<75;i++)
	   {
	     
	     for(l=scale[i],fl=0.0;l<scale[i+1];l++)
	       {
//		 tmp=(sample[l/18][l%18]);
		 tmp=*(osamp + (((l/18) * 32 ) + (l%18)));
		 fl=tmp>fl?tmp:fl;
	       }
	     if(fl < 0)
	       fl = 0;
	     l=yscale[(int)((fl<10000)?(fl/100.0):100)];
//	     l=yscale[(int)((fl<0.1)?(fl*1000.0):100)];
#if 0
	     if(single<0)
	       {
		 for(r=scale[i],fr=0.0;r<scale[i+1];r++)
		   {
		     tmp=/*fabs*/(hybridIn[1][r/18][r%18]);
		     fr=tmp>fr?tmp:fr;
		   }
		 if(fr < 0)
		   fr = 0;
		 r=yscale[(int)((fr<0.1)?(fr*1000.0):100)];
		 val=l>r?l:r;
	       }
	     else
#endif
	       val=l;
	     
	     spectrum[i]=val;
	     
	   }
	 xing_addvis(spectrum);
       }
   }
     }
#endif

}
/*------------------------------------------------------------*/
#ifdef __L3_USEASM__
void sbt_dual_full_L3(float *sample1, float *sample2, short *pcm)
{
  int i;

  for (i = 0; i < 18; i++)
  {
    fdct32_full_asm(sample1,sample2,vbuf+vb_ptr,vbuf2+vb_ptr);
    window_dual_full_asm(vbuf,vbuf2,vb_ptr,pcm);
    sample1 += 32;
    sample2 += 32;
    vb_ptr = (vb_ptr - 32) & 511;
    pcm += 64;
  }
}
#endif
/*------------------------------------------------------------*/
/*------------------------------------------------------------*/
/*---------------- 16 pt sbt's  -------------------------------*/
/*------------------------------------------------------------*/
void sbt16_mono_L3(float *sample, short *pcm, int ch)
{
   int i;

   ch = 0;
   for (i = 0; i < 18; i++)
   {
      fdct16(sample, vbuf + vb_ptr);
      window16(vbuf, vb_ptr, pcm);
      sample += 32;
      vb_ptr = (vb_ptr - 16) & 255;
      pcm += 16;
   }


}
/*------------------------------------------------------------*/
void sbt16_dual_L3(float *sample, short *pcm, int ch)
{
   int i;


   if (ch == 0)
   {
      for (i = 0; i < 18; i++)
      {
	 fdct16(sample, vbuf + vb_ptr);
	 window16_dual(vbuf, vb_ptr, pcm);
	 sample += 32;
	 vb_ptr = (vb_ptr - 16) & 255;
	 pcm += 32;
      }
   }
   else
   {
      for (i = 0; i < 18; i++)
      {
	 fdct16(sample, vbuf2 + vb2_ptr);
	 window16_dual(vbuf2, vb2_ptr, pcm + 1);
	 sample += 32;
	 vb2_ptr = (vb2_ptr - 16) & 255;
	 pcm += 32;
      }
   }

}
/*------------------------------------------------------------*/
/*---------------- 8 pt sbt's  -------------------------------*/
/*------------------------------------------------------------*/
void sbt8_mono_L3(float *sample, short *pcm, int ch)
{
   int i;

   ch = 0;
   for (i = 0; i < 18; i++)
   {
      fdct8(sample, vbuf + vb_ptr);
      window8(vbuf, vb_ptr, pcm);
      sample += 32;
      vb_ptr = (vb_ptr - 8) & 127;
      pcm += 8;
   }

}
/*------------------------------------------------------------*/
void sbt8_dual_L3(float *sample, short *pcm, int ch)
{
   int i;

   if (ch == 0)
   {
      for (i = 0; i < 18; i++)
      {
	 fdct8(sample, vbuf + vb_ptr);
	 window8_dual(vbuf, vb_ptr, pcm);
	 sample += 32;
	 vb_ptr = (vb_ptr - 8) & 127;
	 pcm += 16;
      }
   }
   else
   {
      for (i = 0; i < 18; i++)
      {
	 fdct8(sample, vbuf2 + vb2_ptr);
	 window8_dual(vbuf2, vb2_ptr, pcm + 1);
	 sample += 32;
	 vb2_ptr = (vb2_ptr - 8) & 127;
	 pcm += 16;
      }
   }



}
/*------------------------------------------------------------*/
/*------- 8 bit output ---------------------------------------*/
/*------------------------------------------------------------*/
void sbtB_mono_L3(float *sample, unsigned char *pcm, int ch)
{
   int i;

   ch = 0;
   for (i = 0; i < 18; i++)
   {
      fdct32(sample, vbuf + vb_ptr);
      windowB(vbuf, vb_ptr, pcm);
      sample += 32;
      vb_ptr = (vb_ptr - 32) & 511;
      pcm += 32;
   }

}
/*------------------------------------------------------------*/
void sbtB_dual_L3(float *sample, unsigned char *pcm, int ch)
{
   int i;

   if (ch == 0)
      for (i = 0; i < 18; i++)
      {
	 fdct32(sample, vbuf + vb_ptr);
	 windowB_dual(vbuf, vb_ptr, pcm);
	 sample += 32;
	 vb_ptr = (vb_ptr - 32) & 511;
	 pcm += 64;
      }
   else
      for (i = 0; i < 18; i++)
      {
	 fdct32(sample, vbuf2 + vb2_ptr);
	 windowB_dual(vbuf2, vb2_ptr, pcm + 1);
	 sample += 32;
	 vb2_ptr = (vb2_ptr - 32) & 511;
	 pcm += 64;
      }

}
/*------------------------------------------------------------*/
/*------------------------------------------------------------*/
/*---------------- 16 pt sbtB's  -------------------------------*/
/*------------------------------------------------------------*/
void sbtB16_mono_L3(float *sample, unsigned char *pcm, int ch)
{
   int i;

   ch = 0;
   for (i = 0; i < 18; i++)
   {
      fdct16(sample, vbuf + vb_ptr);
      windowB16(vbuf, vb_ptr, pcm);
      sample += 32;
      vb_ptr = (vb_ptr - 16) & 255;
      pcm += 16;
   }


}
/*------------------------------------------------------------*/
void sbtB16_dual_L3(float *sample, unsigned char *pcm, int ch)
{
   int i;

   if (ch == 0)
   {
      for (i = 0; i < 18; i++)
      {
	 fdct16(sample, vbuf + vb_ptr);
	 windowB16_dual(vbuf, vb_ptr, pcm);
	 sample += 32;
	 vb_ptr = (vb_ptr - 16) & 255;
	 pcm += 32;
      }
   }
   else
   {
      for (i = 0; i < 18; i++)
      {
	 fdct16(sample, vbuf2 + vb2_ptr);
	 windowB16_dual(vbuf2, vb2_ptr, pcm + 1);
	 sample += 32;
	 vb2_ptr = (vb2_ptr - 16) & 255;
	 pcm += 32;
      }
   }

}
/*------------------------------------------------------------*/
/*---------------- 8 pt sbtB's  -------------------------------*/
/*------------------------------------------------------------*/
void sbtB8_mono_L3(float *sample, unsigned char *pcm, int ch)
{
   int i;

   ch = 0;
   for (i = 0; i < 18; i++)
   {
      fdct8(sample, vbuf + vb_ptr);
      windowB8(vbuf, vb_ptr, pcm);
      sample += 32;
      vb_ptr = (vb_ptr - 8) & 127;
      pcm += 8;
   }

}
/*------------------------------------------------------------*/
void sbtB8_dual_L3(float *sample, unsigned char *pcm, int ch)
{
   int i;

   if (ch == 0)
   {
      for (i = 0; i < 18; i++)
      {
	 fdct8(sample, vbuf + vb_ptr);
	 windowB8_dual(vbuf, vb_ptr, pcm);
	 sample += 32;
	 vb_ptr = (vb_ptr - 8) & 127;
	 pcm += 16;
      }
   }
   else
   {
      for (i = 0; i < 18; i++)
      {
	 fdct8(sample, vbuf2 + vb2_ptr);
	 windowB8_dual(vbuf2, vb2_ptr, pcm + 1);
	 sample += 32;
	 vb2_ptr = (vb2_ptr - 8) & 127;
	 pcm += 16;
      }
   }

}
/*------------------------------------------------------------*/
