#define _MATH_H_ // keep math.h from being include
#include "id3_tag.h"
extern "C" {
#import <AppKit/AppKit.h>
}
#import "FileInfo.h"
#import "id3funcs.h"


@implementation FileInfo

- (BOOL)readtag
{
  [values release];
  values = id3_get_tag_dictionary(filename);
  [values retain];
  return values != nil;
}

- (void)alert:(NSString *)string
{
  NSRunAlertPanel(@"File Info", string, @"OK", nil, nil);
}

- (BOOL)savetag
{
  return NO;
}	

- (BOOL)removetag
{
  return NO;
}	


- (void)updateDisplay
{
  if ( [self readtag] ) {
    [window setTitleWithRepresentedFilename:filename];
    [tableView reloadData];
  } else {
  }
  
}

- (void)awakeFromNib
{
  [tableView setDataSource:self];
}

- (void)removeId3:sender
{
  if ( [self removetag] )
    [super cancel:sender];
}

- (void)setFileName:(NSString *)_filename
{
  [filename release];
  filename = [_filename retain];
}

- (void)ok:sender
{
  [super ok:sender];
}

- (id)tableView:(NSTableView *)aTableView
   objectValueForTableColumn:(NSTableColumn *)aTableColumn
   row:(int)rowIndex
{
  if ( [[aTableColumn identifier] isEqualToString:@"name"] )
    return [[values allKeys] objectAtIndex:rowIndex];
  else
    return [values objectForKey:[[values allKeys] objectAtIndex:rowIndex]];
}

- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
   return [values count];
}


@end


