/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/
#import "EqView.h"
#import "Skin.h"
#import "Config.h"
#import "Button.h"
#import "TextBox.h"
#import "MenuRow.h"
#import "Slider.h"
#import "MonoStereo.h"
#import "Number.h"
#import "EqGraph.h"
#import "EqSlider.h"
#import "AppDelegate.h"
#import "Plugins.h"


@implementation EqView

+ (NSSize)calcSize
{
  NSSize size;
  size.width = 275 * (([cfg doublesize]&[cfg eq_doublesize_linked]) + 1);
  size.height = 116 * (([cfg doublesize]&[cfg eq_doublesize_linked]) + 1);
  return size;
}

- (BOOL)isFlipped
{
  return YES;
}

- (void)button_pressed:button
{
}

- (void)on_pressed:button
{
  [cfg setequalizer_active:[button intValue]];
  [Input setEq];
}

- (void)auto_pressed:button
{
  [cfg setequalizer_autoload:[button intValue]];
}

- (void)close_button:sender
{
  [[NSApp delegate] hideShowEq:sender];
}

- (void)preset_pressed:button
{
  NSRect frame, mframe, bframe;

  if ( presetMenuView == nil ) {
    presetMenuView = [[NSMenuView alloc] initWithFrame:NSMakeRect(0,0,0,0)];
    [presetMenuView setMenu:[[NSApp delegate] eqMenu]];
    [presetMenuView update];
    [presetMenuView setNeedsSizing:YES];
    [presetMenuView sizeToFit];
    presetMenuWindow = [[NSWindow alloc]  
			 initWithContentRect:[presetMenuView frame]
				   styleMask:NSBorderlessWindowMask
				     backing:NSBackingStoreBuffered
				       defer:FALSE];
    [presetMenuWindow setContentView:presetMenuView];
    [presetMenuWindow setLevel:NSPopUpMenuWindowLevel];
  }

  mframe = [presetMenuView frame];
  bframe = [button frame];
  frame = [[self window] frame];
  frame.origin.y = frame.origin.y + (frame.size.height-bframe.origin.y)
    - mframe.size.height;
  frame.origin.x = frame.origin.x + bframe.origin.x + bframe.size.width;
  [presetMenuWindow setFrameOrigin:NSMakePoint(frame.origin.x, frame.origin.y)];
  
  [presetMenuWindow makeKeyAndOrderFront:self];
  [presetMenuView trackWithEvent:[NSApp currentEvent]];
  [presetMenuWindow orderOut:self];
}


- (void)motion:slider
{
  NSString *bandname[11]={@"PREAMP",@"60HZ",@"170HZ",@"310HZ",@"600HZ",
			 @"1KHZ",@"3KHZ",@"6KHZ",@"12KHZ",@"14KHZ",@"16KHZ"};


  [[NSApp delegate] lockMainInfoText:
	  [NSString stringWithFormat:@"EQ: %@: %+.1f DB",
	    bandname[[slider band]],
	    [slider position]]];

  if ( [slider band] == 0 )
    [cfg setequalizer_preamp:[slider position]];
  else {
    int band = [slider band]-1;
    [cfg seteq_band:[slider position] :band];
  }

  [graph setNeedsDisplay:YES];
  [Input setEq];
}

- initWithFrame:(NSRect)frame
{
  int i;
  [super initWithFrame:frame];

  on = [[Button alloc] init:NSMakeRect(14,18,25,12)
			       :NSMakePoint(10,119)
			       :NSMakePoint(128,119)
			       :NSMakePoint(69,119)
			       :NSMakePoint(187,119)
			       :self
			       :@selector(on_pressed:)
			       :@selector(eqmain)];
  [self addSubview:on];
  [on toggle:[cfg equalizer_active]];

  autob = [[Button alloc] init:NSMakeRect(39,18,33,12)
				 :NSMakePoint(35,119)
				 :NSMakePoint(153,119)
				 :NSMakePoint(94,119)
				 :NSMakePoint(212,119)
				 :self
				 :@selector(auto_pressed:)
			         :@selector(eqmain)];
  [self addSubview:autob];
  [autob toggle:[cfg equalizer_autoload]];

  presets = [[Button alloc] init:NSMakeRect(217,18,44,12)
				:NSMakePoint(224,164)
				:NSMakePoint(224,176)
				:self
				:@selector(preset_pressed:)
				:@selector(eqmain)];
  [self addSubview:presets];

  close = [[Button alloc] init:NSMakeRect(264,3,9,9)
			      :NSMakePoint(0,116)
			      :NSMakePoint(0,125)
			      :self
			      :@selector(close_button:)
			      :@selector(eqmain)];
  [self addSubview:close];
  
  graph = [[EqGraph alloc] initWithPoint:NSMakePoint(86,17)];
  [self addSubview:graph];


  preamp = [[EqSlider alloc] initWithPos:NSMakePoint(21, 38) 
				    band:0
				  target:self
				      cb:@selector(motion:)];
  [self addSubview:preamp];
  [preamp setPosition:[cfg equalizer_preamp]];

  for( i = 0; i < 10; i++ ) {
    bands[i] = [[EqSlider alloc] initWithPos:NSMakePoint(78+(i*18), 38)
					band:i+1
				      target:self
				      cb:@selector(motion:)];
    [self addSubview:bands[i]];
    [bands[i] setPosition:[cfg eq_bands][i]];
  }

#if 0
	equalizerwin_presets_menu=gtk_item_factory_new(GTK_TYPE_MENU,"<Main>",equalizerwin_accel);
	gtk_item_factory_create_items(equalizerwin_presets_menu,EQUALIZERWIN_PRESETS_MENU_ENTRIES,equalizerwin_presets_menu_entries,NULL);
	equalizer_presets=equalizerwin_read_presets("eq.preset");
	equalizer_auto_presets=equalizerwin_read_presets("eq.auto_preset");
#endif
  return self;
}

- (void)drawRect:(NSRect)rect 
{
#if 1
  [[currentSkin eqmain] 
    compositeToPoint:NSMakePoint(0, [self frame].size.height)
	    fromRect:flipRect(NSMakeRect(0, 0, 275, 116), 
			      [currentSkin eqmain])
	   operation:NSCompositeCopy];

  if([[self window] isKeyWindow] || ![cfg dim_titlebar])
    [[currentSkin eqmain] 
      compositeToPoint:NSMakePoint(0,14)
	      fromRect:flipRect(NSMakeRect(0, 134, 275, 14), 
				[currentSkin eqmain])
	     operation:NSCompositeCopy];
  else
    [[currentSkin eqmain] 
      compositeToPoint:NSMakePoint(0,14)
	      fromRect:flipRect(NSMakeRect(0, 149, 275, 14), 
				[currentSkin eqmain])
	     operation:NSCompositeCopy];
#endif
}

- (void)mouseDown:(NSEvent *)theEvent 
{
  NSPoint startPoint, curPoint, new;
  NSRect frame = [[self window] frame], playerFrame, playlistFrame;
  int xdif, ydif;
  int sd = [cfg snap_distance];
  int w = frame.size.width;
  int h = frame.size.height;
  int sw = [[NSScreen mainScreen] frame].size.width;
  int sh = [[NSScreen mainScreen] frame].size.height;
  BOOL done = NO;

  startPoint = [theEvent locationInWindow];

  if (startPoint.y > frame.size.height-14 || [cfg easy_move] ) {
    startPoint = [[self window] convertBaseToScreen:startPoint];
    xdif = startPoint.x - frame.origin.x;
    ydif = startPoint.y - frame.origin.y;

    if( [cfg player_visible] )
      playerFrame = [[[NSApp delegate] mainWindow] frame];
    if ( [cfg playlist_visible] )
      playlistFrame = [[[NSApp delegate] playlistWindow] frame];

    while (!done) {
      NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
      theEvent = [[self window] nextEventMatchingMask:(NSLeftMouseDraggedMask | NSLeftMouseUpMask)];
      curPoint = [theEvent locationInWindow];

      curPoint = [[self window] convertBaseToScreen:curPoint];
      new = NSMakePoint(curPoint.x-xdif, curPoint.y-ydif);

      if ( [cfg snap_windows] ) {
	if(new.x > -sd && new.x < sd)
	  new.x = 0;
	if((new.x + w) > sw - sd && (new.x + w) < sw + sd)
	  new.x = sw - w;
	if(new.y > -sd && new.y < sd)
	  new.y = 0;
	if((new.y + h) > sh - sd && (new.y + h) < sh + sd) 
	  new.y = sh - h;
      }

      if( [cfg player_visible] ) {
	dock(&new.x, &new.y, w, h, playerFrame.origin.x, 
	     playerFrame.origin.y, playerFrame.size.width, 
	     playerFrame.size.height);
      }
	  
      if([cfg playlist_visible]) {
	dock(&new.x, &new.y, w, h, playlistFrame.origin.x, 
	     playlistFrame.origin.y, playlistFrame.size.width,
	     playlistFrame.size.height);
      }

      [[self window] setFrameOrigin:new];

      if ([theEvent type] == NSLeftMouseUp)
	done = YES;

      [pool release];

    }
  }
  
}

- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
  return YES;
}

@end

void dock(float *rx,float *ry,int w,int h,int ox,int oy,int ow,int oh)
{
  int snapd=[cfg snap_distance];
  int x = *rx, y = *ry;
  
  if(![cfg snap_windows])
    return;

  if(x+w>ox-snapd && x+w<ox+snapd && y>oy-h && y<oy+oh)
    {
      x=ox-w;
      if(y>oy-snapd && y<oy+snapd) y=oy;
      if(y+h>oy+oh-snapd && y+h<oy+oh+snapd) y=oy+oh-h;
    }
	
  if(x>ox+ow-snapd && x<ox+ow+snapd && y>oy-h && y<oy+oh) 
    {
      x=ox+ow;
      if(y>oy-snapd && y<oy+snapd) y=oy;
      if(y+h>oy+oh-snapd && y+h<oy+oh+snapd) y=oy+oh-h;
    }
  if(y+h>oy-snapd && y+h<oy+snapd && x>ox-w && x<ox+ow) 
    {
      y=oy-h;
      if(x>ox-snapd && x<ox+snapd) x=ox;
      if(x+w>ox+ow-snapd && x+w<ox+ow+snapd) x=ox+ow-w;
    }
  if(y>oy+oh-snapd && y<oy+oh+snapd && x>ox-w && x<ox+ow) 
    {
      y=oy+oh;
      if(x>ox-snapd && x<ox+snapd) x=ox;
      if(x+w>ox+ow-snapd && x+w<ox+ow+snapd) x=ox+ow-w;
    }
  *rx = x;
  *ry = y;
}

BOOL is_docked(int x,int y,int w, int h,int ox,int oy,int ow,int oh)
{
  if((x==ox||x==ox+ow||x+w==ox||x+w==ox+ow)&&oy>=y-oh&&oy<=y+h) 
    return YES;
  if((y==oy||y==oy+oh||y+h==oy||y+h==oy+oh)&&ox>=x-ow&&ox<=x+w) 
    return YES;
  return NO;
}
