/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/
#import "Config.h"
#import <AppKit/AppKit.h>
#import "AppDelegate.h"

Config *cfg = nil;

@implementation Config

- (id)copyWithZone:(NSZone *)zone
{
  Config *copy = [[[Config alloc] init] autorelease];
  copy->dict = [dict mutableCopyWithZone:zone];
  memcpy(copy->eq_bands, eq_bands, sizeof(float)*NUM_EQ_BANDS);
  return copy;
}

- (void)save_config
{
  NSUserDefaults *ud = [NSUserDefaults standardUserDefaults];
  NSArray *keys;
  id key, obj;
  int i;

  keys = [dict allKeys];
  for ( i = 0; i < [keys count]; i++ ) {
    key = [keys objectAtIndex:i];
    obj = [self objectForKey:key];
    if ( [obj isKindOfClass:[NSString class]] 
	 || [obj isKindOfClass:[NSDictionary class]] )
      [ud setObject:obj forKey:key];
  }
  
  {
    NSMutableArray *eqs = [NSMutableArray array];
    int i;
    for ( i = 0; i < NUM_EQ_BANDS; i++ ) {
      [eqs addObject:[[NSNumber numberWithFloat:eq_bands[i]] description]];
    }
    [ud setObject:eqs forKey:@"eq_bands"];
  }
  [ud synchronize];
}
  

- (void)load_config
{
  NSUserDefaults *ud = [NSUserDefaults standardUserDefaults];
  id obj;
  NSArray *keys;
  id key;
  int i;
  NSMutableDictionary *newd;

  keys = [dict allKeys];
  for ( i = 0; i < [keys count]; i++ ) {
    key = [keys objectAtIndex:i];
    obj = [ud objectForKey:key];
    if ( [obj isKindOfClass:[NSDictionary class]] ) {
      newd = [NSMutableDictionary dictionaryWithDictionary:obj];
      [self setObject:newd forKey:key];
    } else if ( obj != nil )
      [self setObject:obj forKey:key];
  }
  
  
  if ( [ud objectForKey:@"eq_bands"] ) {
    NSArray *eqs;
    int i;

    eqs = [ud objectForKey:@"eq_bands"];
    for ( i = 0; i < NUM_EQ_BANDS; i++ ) {
      eq_bands[i] = [[eqs objectAtIndex:i] floatValue];
    }
  }
  {
    NSMutableDictionary *newd;
    newd = [NSMutableDictionary dictionaryWithDictionary:
					[ud objectForKey:@"plugins"]];
    [self setObject:newd forKey:@"plugins"];
  }
}

- init
{
  int i;

  dict = [[NSMutableDictionary dictionary] retain];

  [self seteasy_move:YES];
  [self setplayer_visible:YES];
  [self setequalizer_visible:YES];
  [self setplaylist_visible:YES];
  [self setdim_titlebar:YES];
  [self setautoscroll:YES];
  [self setplayer_shaded:NO];
  [self setequalizer_preamp:0.0];
  [self setbalance:12];
  [self setvolume:35];
  [self setsnap_distance:10];
  [self setsnap_windows:YES];
  [self setplaylist_font:[[NSFont fontWithName:@"Ohlfs" size:10.0] retain]];
  [self setshow_numbers_in_pl:YES];
  [self setequalizer_active:NO];
  [self setequalizer_autoload:NO];
  [self setdoublesize:NO];
  [self seteq_doublesize_linked:YES];
  [self setshuffle:NO];
  [self setrepeat:NO];
  [self setalways_on_top:NO];
  [self setread_titles_on_load:NO];
  [self setskin_file_name:@"(none)"];
  [self setalways_show_cb:YES];
  [self settimer_mode:TIMER_ELAPSED];
  [self setcurrent_playlist:@""];
  [self setnoplaylist_advance:NO];
  [self setvis_type:VIS_ANALYZER];

  [self setpeaks_falloff:FALLOFF_FAST];
  [self setanalyzer_falloff:FALLOFF_FAST];
  [self setvis_refresh:REFRESH_FULL];
  [self setanalyzer_type:ANALYZER_LINES];
  [self setanalyzer_mode:ANALYZER_FIRE];
  [self setanalyzer_peaks:YES];
  [self setscope_mode:SCOPE_DOT];
  [self setsmooth_title_scroll:NO];
  [self setObject:[NSMutableDictionary dictionary] forKey:@"plugins"];
  [self setIntValue:300 forKey:@"playlist_size_x"];
  [self setIntValue:232 forKey:@"playlist_size_y"];
  [self setplaylist_shaded:NO];
  [self setplaylist_position:0];
  [self setslow_cpu:NO];
  [self setdefault_extension:@"mp3"];
  [self setclose_box_on_left:NO];
  [self setvu_mode:VU_NORMAL];
  [self setUseArtistBrowser:NO];

  for ( i = 0; i < NUM_EQ_BANDS; i++ ) {
    eq_bands[i] = 0.0;
  }

  return [super init];
}

+ (void)load_configuration
{
  cfg = [[Config alloc] init];
  [cfg load_config];
}

- (void)setObject:(id)anObject forKey:(id)aKey
{
  [dict setObject:anObject forKey:aKey];
}

- (id)objectForKey:(id)aKey
{
  return [dict objectForKey:aKey];
}

- (BOOL)boolValueForKey:(NSString *)key
{
  NSString *val = [self objectForKey:key];
  return [val isEqualToString:@"YES"] ? YES : NO;
}

- (int)intValueForKey:(NSString *)key
{
  return [[self objectForKey:key] intValue];
}

- (void)setIntValue:(int)val forKey:(NSString *)key
{
  [self setObject:[NSString stringWithFormat:@"%d", val] forKey:key];
}

- (void)setBoolValue:(BOOL)val forKey:(NSString *)key
{
  [self setObject:val ? @"YES" : @"NO" forKey:key];
}

- (float)floatValueForKey:(NSString *)key
{
  return [[self objectForKey:key] floatValue];
}


- (void)setFloatValue:(float)val forKey:(NSString *)key
{
  [self setObject:[NSString stringWithFormat:@"%f", val] forKey:key];
}


- (BOOL)player_visible
{
  return [self boolValueForKey:@"player_visible"];
}

- (BOOL)doublesize
{
  return [self boolValueForKey:@"doublesize"];
}

- (BOOL)player_shaded
{
  return [self boolValueForKey:@"player_shaded"];
}

- (BOOL)playlist_shaded
{
  return [self boolValueForKey:@"playlist_shaded"];
}

- (BOOL)eq_doublesize_linked
{
  return [self boolValueForKey:@"eq_doublesize_linked"];
}

- (BOOL)dim_titlebar
{
  return [self boolValueForKey:@"dim_titlebar"];
}

- (BOOL)shuffle
{
  return [self boolValueForKey:@"shuffle"];
}

- (BOOL)repeat
{
  return [self boolValueForKey:@"repeat"];
}

- (BOOL)equalizer_visible
{
  return [self boolValueForKey:@"equalizer_visible"];
}

- (BOOL)playlist_visible
{
  return [self boolValueForKey:@"playlist_visible"];
}

- (BOOL)autoscroll
{
  return [self boolValueForKey:@"autoscroll"];
}

- (BOOL)always_on_top
{
  return [self boolValueForKey:@"always_on_top"];
}

- (BOOL)equalizer_active
{
  return [self boolValueForKey:@"equalizer_active"];
}

- (BOOL)equalizer_autoload
{
  return [self boolValueForKey:@"equalizer_autoload"];
}

- (BOOL)easy_move
{
  return [self boolValueForKey:@"easy_move"];
}

- (float)equalizer_preamp
{
  return [self floatValueForKey:@"equalizer_preamp"];
}

- (int)volume
{
  return [self intValueForKey:@"volume"];
}

- (int)balance
{
  return [self intValueForKey:@"balance"];
}

- (int)snap_distance
{
  return [self intValueForKey:@"snap_distance"];
}

- (BOOL)snap_windows
{
  return [self boolValueForKey:@"snap_windows"];
}

- (int)playlist_position
{
  return [self intValueForKey:@"playlist_position"];
}

- (BOOL)show_numbers_in_pl
{
  return [self boolValueForKey:@"show_numbers_in_pl"];
}

- (NSFont *)playlist_font
{
  return [self objectForKey:@"playlist_font"];
}

- (float)eq_band:(int)band
{
  return eq_bands[band];
}

- (float *)eq_bands
{
  return eq_bands;
}

- (NSSize)playlist_size
{
  return NSMakeSize([self intValueForKey:@"playlist_size_x"],
		    [self intValueForKey:@"playlist_size_y"]);
}

- (BOOL)read_titles_on_load
{
  return [self boolValueForKey:@"read_titles_on_load"];
}

- (NSString *)skin_file_name
{
  return [self objectForKey:@"skin_file_name"];
}

- (NSString *)current_playlist
{
  return [self objectForKey:@"current_playlist"];
}

- (BOOL)always_show_cb
{
  return [self boolValueForKey:@"always_show_cb"];
}

- (TimerMode)timer_mode
{
  return (TimerMode)[self intValueForKey:@"timer_mode"];
}

- (BOOL)noplaylist_advance
{
  return [self boolValueForKey:@"noplaylist_advance"];
}

- (VisType)vis_type
{
  return (VisType)[self intValueForKey:@"vis_type"];
}

- (FalloffSpeed)peaks_falloff
{
  return (FalloffSpeed)[self intValueForKey:@"peaks_falloff"];
}

- (FalloffSpeed)analyzer_falloff
{
  return (FalloffSpeed)[self intValueForKey:@"analyzer_falloff"];
}

- (RefreshRate)vis_refresh
{
  return (RefreshRate)[self intValueForKey:@"vis_refresh"];
}

- (AnalyzerType)analyzer_type
{
  return (AnalyzerType)[self intValueForKey:@"analyzer_type"];
}

- (AnalyzerMode)analyzer_mode
{
  return (AnalyzerMode)[self intValueForKey:@"analyzer_mode"];
}

- (BOOL)analyzer_peaks
{
  return [self boolValueForKey:@"analyzer_peaks"];
}

- (ScopeMode)scope_mode
{
  return (ScopeMode)[self intValueForKey:@"scope_mode"];
}

- (BOOL)pluginEnabled:(Class)pluginClass
{
  NSDictionary *pdict = [self objectForKey:@"plugins"];
  NSString *val;
  val = [pdict objectForKey:NSStringFromClass(pluginClass)];
  return val && [val isEqualToString:@"YES"] ? YES : NO;
}

- (BOOL)pluginEnabledIsSet:(Class)pluginClass
{
  NSDictionary *pdict = [self objectForKey:@"plugins"];
  NSString *val;
  val = [pdict objectForKey:NSStringFromClass(pluginClass)];
  return val != nil;
}

- (BOOL)smooth_title_scroll
{
  return [self boolValueForKey:@"smooth_title_scroll"];
}

- (BOOL)slow_cpu
{
  return [self boolValueForKey:@"slow_cpu"];
}

- (NSString *)default_extension
{
  return [self objectForKey:@"default_extension"];
}

- (BOOL)close_box_on_left
{
  return [self boolValueForKey:@"close_box_on_left"];
}

  
- (VUMode)vu_mode
{
  return [self intValueForKey:@"vu_mode"];
}

- (BOOL)useArtistBrowser
{
  return [self boolValueForKey:@"useArtistBrowser"];
}


- (void)setPluginEnabled:(Class)pluginClass value:(BOOL)val
{
  NSMutableDictionary *pdict = [self objectForKey:@"plugins"];
  [pdict setObject:val ? @"YES" : @"NO"
	    forKey:NSStringFromClass(pluginClass)];
}

- (void)setplayer_visible:(BOOL)val
{
  [self setBoolValue:val forKey:@"player_visible"];
}

- (void)setdoublesize:(BOOL)val
{
  [self setBoolValue:val forKey:@"doublesize"];
}

- (void)setplayer_shaded:(BOOL)val
{
  [self setBoolValue:val forKey:@"player_shaded"];
}

- (void)setplaylist_shaded:(BOOL)val
{
  [self setBoolValue:val forKey:@"playlist_shaded"];
}

- (void)seteq_doublesize_linked:(BOOL)val
{
  [self setBoolValue:val forKey:@"eq_doublesize_linked"];
}

- (void)setdim_titlebar:(BOOL)val
{
  [self setBoolValue:val forKey:@"dim_titlebar"];
}

- (void)setshuffle:(BOOL)val
{
  [self setBoolValue:val forKey:@"shuffle"];
}

- (void)setrepeat:(BOOL)val
{
  [self setBoolValue:val forKey:@"repeat"];
}

- (void)setequalizer_visible:(BOOL)val
{
  [self setBoolValue:val forKey:@"equalizer_visible"];
}

- (void)setplaylist_visible:(BOOL)val
{
  [self setBoolValue:val forKey:@"playlist_visible"];
}

- (void)setautoscroll:(BOOL)val
{
  [self setBoolValue:val forKey:@"autoscroll"];
}

- (void)setalways_on_top:(BOOL)val
{
  [self setBoolValue:val forKey:@"always_on_top"];
}

- (void)setequalizer_active:(BOOL)val
{
  [self setBoolValue:val forKey:@"equalizer_active"];
}

- (void)setequalizer_autoload:(BOOL)val
{
  [self setBoolValue:val forKey:@"equalizer_autoload"];
}

- (void)seteasy_move:(BOOL)val
{
  [self setBoolValue:val forKey:@"easy_move"];
}

- (void)setequalizer_preamp:(float)val
{
  [self setFloatValue:val forKey:@"equalizer_preamp"];
}

- (void)setvolume:(int)val
{
  [self setIntValue:val forKey:@"volume"];
}

- (void)setbalance:(int)val
{
  [self setIntValue:val forKey:@"balance"];
}

- (void)setsnap_distance:(int)val
{
  [self setIntValue:val forKey:@"snap_distance"];
}

- (void)setsnap_windows:(BOOL)val
{
  [self setBoolValue:val forKey:@"snap_windows"];
}

- (void)setplaylist_position:(int)val
{
  [self setIntValue:val forKey:@"playlist_position"];
}

- (void)setshow_numbers_in_pl:(BOOL)val
{
  [self setBoolValue:val forKey:@"show_numbers_in_pl"];
}

- (void)setplaylist_font:(NSFont *)val
{
  [self setObject:val forKey:@"playlist_font"];
}

- (void)seteq_band:(float)val :(int)band
{
  eq_bands[band] = val;
}

- (void)setread_titles_on_load:(BOOL)val
{
  [self setBoolValue:val forKey:@"read_titles_on_load"];
}

- (void)setskin_file_name:(NSString *)val
{
  [self setObject:val forKey:@"skin_file_name"];
}

- (void)setalways_show_cb:(BOOL)val
{
  [self setBoolValue:val forKey:@"always_show_cb"];
}

- (void)settimer_mode:(TimerMode)val
{
  [self setIntValue:(int)val forKey:@"timer_mode"];
}

- (void)setcurrent_playlist:(NSString *)val
{
  [self setObject:val forKey:@"current_playlist"];
}

- (void)setnoplaylist_advance:(BOOL)val
{
  [self setBoolValue:val forKey:@"noplaylist_advance"];
}

- (void)setvis_type:(VisType)val;
{
  [self setIntValue:(int)val forKey:@"vis_type"];
}

- (void)setpeaks_falloff:(FalloffSpeed)val
{
  [self setIntValue:(int)val forKey:@"peaks_falloff"];
}

- (void)setanalyzer_falloff:(FalloffSpeed)val;
{
  [self setIntValue:(int)val forKey:@"analyzer_falloff"];
}

- (void)setvis_refresh:(RefreshRate)val
{
  [self setIntValue:(int)val forKey:@"vis_refresh"];
}

- (void)setanalyzer_type:(AnalyzerType)val
{
  [self setIntValue:(int)val forKey:@"analyzer_type"];
}

- (void)setanalyzer_mode:(AnalyzerMode)val
{
  [self setIntValue:(int)val forKey:@"analyzer_mode"];
}

- (void)setanalyzer_peaks:(BOOL)val
{
  [self setBoolValue:val forKey:@"analyzer_peaks"];
}

- (void)setscope_mode:(ScopeMode)val
{
  [self setIntValue:(int)val forKey:@"scope_mode"];
}

- (void)setsmooth_title_scroll:(BOOL)val
{
  [self setBoolValue:val forKey:@"smooth_title_scroll"];
}

- (void)setslow_cpu:(BOOL)val
{
  [self setBoolValue:val forKey:@"slow_cpu"];
}

- (void)setdefault_extension:(NSString *)val
{
  [self setObject:val forKey:@"default_extension"];
}

- (void)setclose_box_on_left:(BOOL)val
{
  [self setBoolValue:val forKey:@"close_box_on_left"];
  
}

- (void)setplaylist_size:(NSSize)size
{
  [self setFloatValue:size.width forKey:@"playlist_size_x"];
  [self setFloatValue:size.height forKey:@"playlist_size_y"];
}

- (void)setvu_mode:(VUMode)val
{
  [self setIntValue:val forKey:@"vu_mode"];
}

- (void)setUseArtistBrowser:(BOOL)val
{
  [self setBoolValue:val forKey:@"useArtistBrowser"];
}

@end
