/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
*/
#import <Foundation/NSDictionary.h>
#import <Foundation/NSGeometry.h>
#import "Plugins.h"
#import "Visualization.h"

@class NSFont;

#define NUM_EQ_BANDS 10

typedef enum { TIMER_ELAPSED, TIMER_REMAINING } TimerMode;


@interface Config : NSObject <NSCopying>
{
  float eq_bands[NUM_EQ_BANDS];
  NSMutableDictionary *dict;
}

- (id)objectForKey:(id)aKey;
- (void)setObject:(id)anObject forKey:(id)aKey;
- (BOOL)boolValueForKey:(NSString *)key;
- (int)intValueForKey:(NSString *)key;
- (void)setIntValue:(int)val forKey:(NSString *)key;
- (void)setBoolValue:(BOOL)val forKey:(NSString *)key;

+ (void)load_configuration;

- (BOOL)pluginEnabled:(Class)pluginClass;
- (BOOL)pluginEnabledIsSet:(Class)pluginClass;
- (void)setPluginEnabled:(Class)pluginClass value:(BOOL)val;

- (BOOL)player_visible;
- (BOOL)doublesize;
- (BOOL)player_shaded;
- (BOOL)playlist_shaded;
- (BOOL)eq_doublesize_linked;
- (BOOL)dim_titlebar;
- (BOOL)shuffle;
- (BOOL)repeat;
- (BOOL)equalizer_visible;
- (BOOL)playlist_visible;
- (BOOL)autoscroll;
- (BOOL)always_on_top;
- (BOOL)equalizer_active;
- (BOOL)equalizer_autoload;
- (BOOL)easy_move;
- (float)equalizer_preamp;
- (int)volume;
- (int)balance;
- (int)snap_distance;
- (BOOL)snap_windows;
- (int)playlist_position;
- (BOOL)show_numbers_in_pl;
- (NSFont *)playlist_font;
- (float)eq_band:(int)band;
- (float *)eq_bands;
- (BOOL)read_titles_on_load;
- (NSString *)skin_file_name;
- (NSSize)playlist_size;
- (BOOL)always_show_cb;
- (TimerMode)timer_mode;
- (NSString *)current_playlist;
- (BOOL)noplaylist_advance;
- (VisType)vis_type;
- (FalloffSpeed)peaks_falloff;
- (FalloffSpeed)analyzer_falloff;
- (RefreshRate)vis_refresh;
- (AnalyzerType)analyzer_type;
- (AnalyzerMode)analyzer_mode;
- (BOOL)analyzer_peaks;
- (ScopeMode)scope_mode;
- (BOOL)smooth_title_scroll;
- (BOOL)slow_cpu;
- (NSString *)default_extension;
- (BOOL)close_box_on_left;
- (VUMode)vu_mode;
- (BOOL)useArtistBrowser;

- (void)setplayer_visible:(BOOL)val;
- (void)setdoublesize:(BOOL)val;
- (void)setplayer_shaded:(BOOL)val;
- (void)setplaylist_shaded:(BOOL)val;
- (void)seteq_doublesize_linked:(BOOL)val;
- (void)setdim_titlebar:(BOOL)val;
- (void)setshuffle:(BOOL)val;
- (void)setrepeat:(BOOL)val;
- (void)setequalizer_visible:(BOOL)val;
- (void)setplaylist_visible:(BOOL)val;
- (void)setautoscroll:(BOOL)val;
- (void)setalways_on_top:(BOOL)val;
- (void)setequalizer_active:(BOOL)val;
- (void)setequalizer_autoload:(BOOL)val;
- (void)seteasy_move:(BOOL)val;
- (void)setequalizer_preamp:(float)val;
- (void)setvolume:(int)val;
- (void)setbalance:(int)val;
- (void)setsnap_distance:(int)val;
- (void)setsnap_windows:(BOOL)val;
- (void)setplaylist_position:(int)val;
- (void)setshow_numbers_in_pl:(BOOL)val;
- (void)setplaylist_font:(NSFont *)val;
- (void)seteq_band:(float)val :(int)band;
- (void)setread_titles_on_load:(BOOL)val;
- (void)setskin_file_name:(NSString *)val;
- (void)setalways_show_cb:(BOOL)val;
- (void)settimer_mode:(TimerMode)val;
- (void)setcurrent_playlist:(NSString *)val;
- (void)setnoplaylist_advance:(BOOL)val;
- (void)setvis_type:(VisType)val;
- (void)setpeaks_falloff:(FalloffSpeed)val;
- (void)setanalyzer_falloff:(FalloffSpeed)val;
- (void)setvis_refresh:(RefreshRate)val;
- (void)setanalyzer_type:(AnalyzerType)val;
- (void)setanalyzer_mode:(AnalyzerMode)val;
- (void)setanalyzer_peaks:(BOOL)val;
- (void)setscope_mode:(ScopeMode)val;
- (void)setsmooth_title_scroll:(BOOL)val;
- (void)setslow_cpu:(BOOL)val;
- (void)setdefault_extension:(NSString *)val;
- (void)setclose_box_on_left:(BOOL)val;
- (void)setplaylist_size:(NSSize)size;
- (void)setvu_mode:(VUMode)val;
- (void)setUseArtistBrowser:(BOOL)val;

- (void)save_config;
- (void)load_config;


@end

extern Config *cfg;
