/*  
 *  MacOSXAmp - graphically mp3 player for MaxOS X Server
 *  Copyright (C) 1999  Scott P. Bender (sbender@harmony-ds.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING if not, write to 
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *  Boston, MA 02111-1307, USA.
 */

#import "AppDelegate.h"
#import <AppKit/AppKit.h>
#import "MainWindow.h"
#import "MainView.h"
#import "EqView.h"
#import "Skin.h"
#import "Config.h"
#import "PlaylistView.h"
#import "Button.h"
#import "Preferences.h"
#import "SkinBrowser.h"
#import "Plugins.h"
#import "PlaylistEntry.h"

#if 0
enum { PLAYLIST_TARGET, MAIN_TARGET, EQ_TARGET, DELEGATE_TARGET };

struct menu_command
{
  int target;
  SEL selector;
  id arg;
};

struct menu_command menu_commands[] = 
{
  { 0, 0, nil },
  { MAIN_TARGET, @selector(toggle_repeate), -1 },
  { MAIN_TARGET, @selector(toggle_shuffle), -1 }
};
int num_commands = sizeof(menu_commands)/sizeof(menu_commands[0]);
#endif

@implementation AppDelegate

#if 0
- (void)handleMenuCommand:sender
{
  int tag = [sender tag];
  
  if ( tag > 0 && tag < num_commands ) {
    id target;
    switch(menu_commands[tag].target) {
    case PLAYLIST_TARGET:
      target = [playlistWindow contentView];
      break;
    case MAIN_TARGET:
      target = [mainWindow contentView];
      break;
    case EQ_TARGET:
      target = [eqWindow contentView];
      break;
    case DELEGATE_TARGET:
      target = self;
      break;
    }
    if ( menu_commands[tag].arg != -1 )
      [target performSelector:menu_commands[tag].selector 
		   withObject:menu_commands[tag].arg];
    else
      [target performSelector:menu_commands[tag].selector];
  }
}
#endif

- (void)applicationDidFinishLaunching:(NSNotification *)notification
{
  NSRect rect;
  MainView *mainView;
  EqView *eqView;
  PlaylistView *plView;
  NSSize main_size, eq_size, pl_size;

  [Config load_configuration];
  [Plugin loadAllPluginBundles];

  [Skin loadSkin:[cfg skin_file_name]];

  main_size = [MainView calcSize];
  eq_size = [EqView calcSize];
  rect = NSMakeRect(0, eq_size.height, main_size.width, 
		    main_size.height);

  mainWindow = [[MainWindow alloc] initWithContentRect:rect 
					     styleMask:NSBorderlessWindowMask
					       backing:NSBackingStoreBuffered
						 defer:FALSE
						  name:@"Main"];
  mainView = [[MainView alloc] initWithFrame:rect];
  [mainWindow setContentView:mainView];

  if ( [cfg player_visible] )
    [mainWindow makeKeyAndOrderFront:self];

  rect = NSMakeRect(0, 0, eq_size.width, eq_size.height);
  eqWindow = [[MainWindow alloc] initWithContentRect:rect 
					 styleMask:NSBorderlessWindowMask
					   backing:NSBackingStoreBuffered
					     defer:FALSE
					      name:@"EQ"];
  eqView = [[EqView alloc] initWithFrame:rect];
  [eqWindow setContentView:eqView];
  if ( [cfg equalizer_visible] )
    [eqWindow orderFront:self];

  pl_size = [cfg playlist_size];
  rect = NSMakeRect(main_size.width, 0, pl_size.width, pl_size.height);
  playlistWindow = [[MainWindow alloc] 
		     initWithContentRect:rect 
			       styleMask:NSBorderlessWindowMask
				 backing:NSBackingStoreBuffered
				   defer:FALSE
				    name:@"Playlist"];
  plView = [[PlaylistView alloc] initWithFrame:rect];
  [playlistWindow setContentView:plView];
  if ( [cfg playlist_shaded] )
    [plView updateShaded:YES];
  if ( [cfg playlist_visible] )
    [playlistWindow orderFront:self];

  [self resetVisTimer];

  [NSTimer scheduledTimerWithTimeInterval:1.0
				   target:self 
				 selector:@selector(timeTimer:)
				 userInfo:nil
				  repeats:YES];

  initialized = YES;

  if ( startupPlayFile ) {
    [self addAndPlayFile:startupPlayFile];
    [startupPlayFile release];
    startupPlayFile = nil;
  }
}

- (BOOL)applicationShouldTerminate:(NSApplication *)sender
{
  BOOL res = YES;
  
  if ( [Playlist modified] ) {
    int ret = NSRunAlertPanel(PACKAGE, @"Your playlist has been changed. Would you like to save it?", @"Save", @"Cancel", @"Don't Save");    
    if ( ret == NSAlertDefaultReturn )
      res = [self savePlaylist];
    else if ( ret == NSAlertAlternateReturn )
      res = NO;
  }
  return res;
}

- (BOOL)savePlaylist
{
  NSSavePanel *panel;
  NSString *cf;
  int res;
  
  panel = [NSSavePanel savePanel];

  cf = [cfg current_playlist];
  if ( [cf length] )
    res = [panel runModalForDirectory:[cf stringByDeletingLastPathComponent]
				 file:[cf lastPathComponent]];
  else
    res = [panel runModal];
  
  if ( res == NSOKButton ) {
    if ( [Playlist savePlaylist:[panel filename]] == NO ) {
      NSRunAlertPanel(@"MacOSXAmp", @"Unable to save playlist file: %@", 
		      @"OK", nil, nil, [panel filename]);      
      return NO;
    } else {
      [cfg setcurrent_playlist:[panel filename]];
      return YES;
    }
  }
  return NO;
}

- (void)resetVisTimer
{
  if ( visTimer != nil ) {
    [visTimer invalidate];
  }
  
  visTimer = [NSTimer scheduledTimerWithTimeInterval:
				[cfg slow_cpu] ? 0.1 : 0.05
					       target:self 
					     selector:@selector(visTimer:)
					     userInfo:nil
					      repeats:YES];
}

- (void)addAndPlayFile:(NSString *)file
{
  int pos = [Playlist count];
  [Playlist addFile:file];
  [cfg setplaylist_position:pos];
  [[self playlistView] play];
}

- (BOOL)application:sender openFile:(NSString *)file
{
  if ( initialized )
    [self addAndPlayFile:file];
  else
    startupPlayFile = [file retain];
  return YES;
}

- (void)applicationWillTerminate:(NSNotification *)notification
{
  if ( [Input isPlaying] )
    [Input stop];
  [cfg save_config];
}

- (NSWindow *)mainWindow
{
  return mainWindow;
}

- (NSWindow *)eqWindow
{
  return eqWindow;
}

- (NSWindow *)playlistWindow
{
  return playlistWindow;
}

- (MainView *)mainView
{
  return [mainWindow contentView];
}

- (EqView *)eqView
{
  return [eqWindow contentView];
}

- (PlaylistView *)playlistView
{
  return [playlistWindow contentView];
}

- (NSMenu *)eqMenu
{
  return eqMenu;
}

- (NSMenu *)miscOptsMenu
{
  return miscOptsMenu;
}

- (NSMenu *)sortMenu
{
  return sortMenu;
}

- (NSMenu *)fileMenu
{
  return fileMenu;
}

- (void)lockMainInfoText:(NSString *)string
{
  [[mainWindow contentView] lockInfoText:string];
}

- (void)unlockMainInfoText
{
  [[mainWindow contentView] unlockInfoText];
}

- (void)hideShowPlaylist:sender
{
  if ( [cfg playlist_visible] == NO )
    [playlistWindow orderFront:self];
  else
    [playlistWindow orderOut:self];
  [cfg setplaylist_visible:![cfg playlist_visible]];
  [[[mainWindow contentView] playlistButton] toggle:[cfg playlist_visible]];
}

- (void)hideShowEq:sender
{
  if ( [cfg equalizer_visible] == NO )
    [eqWindow orderFront:self];
  else
    [eqWindow orderOut:self];
  [cfg setequalizer_visible:![cfg equalizer_visible]];
  [[[mainWindow contentView] eqButton] toggle:[cfg equalizer_visible]];
}

- (void)hideShowMain:sender
{
  if ( [cfg player_visible] == NO )
    [mainWindow orderFront:self];
  else
    [mainWindow orderOut:self];
  [cfg setplayer_visible:![cfg player_visible]];
}

- (void)openFilePanel:sender
{
  NSOpenPanel *panel;
  
  panel = [NSOpenPanel openPanel];
  
  [panel setAllowsMultipleSelection:NO];
  [panel setCanChooseDirectories:NO];
  
  if ( [panel runModalForTypes:nil] == NSOKButton ) {
    [self addAndPlayFile:[[panel filenames] objectAtIndex:0]];
  }
}

- (void)time_elapsed:sender
{
  [cfg settimer_mode:TIMER_ELAPSED];
}

- (void)time_remaining:sender
{
  [cfg settimer_mode:TIMER_REMAINING];
}

- (BOOL)validateMenuItem:(id <NSMenuItem>)menuItem
{
  NSMenu *visMenu, *menu = [menuItem menu];
  int val = -1;

  visMenu = [[[NSApp mainMenu] itemWithTitle:@"Visualization"] submenu];
  
  if ( menu == [[visMenu itemWithTag:0] submenu] )
    val = [cfg vis_type];
  else if ( menu == [[visMenu itemWithTag:1] submenu] ) {
    if ( [menuItem tag] <= ANALYZER_VLINES )
      val = [cfg analyzer_mode];
    else if ( [menuItem tag] == 5 )
      val = [cfg analyzer_peaks] ? 5 : 0;
    else
      val = [cfg analyzer_type]+ANALYZER_VLINES+1;
  } else if ( menu == [[visMenu itemWithTag:2] submenu] )
    val = [cfg scope_mode];
  else if ( menu == [[visMenu itemWithTag:3] submenu] )
    val = [cfg vu_mode];
  else if ( menu == [[visMenu itemWithTag:4] submenu] )
    val = [cfg vis_refresh];
  else if ( menu == [[visMenu itemWithTag:5] submenu] )
    val = [cfg analyzer_falloff];
  else if ( menu == [[visMenu itemWithTag:6] submenu] )
    val = [cfg peaks_falloff];

  if ( val == -1 ) {
    SEL options[] = { 0, 
		      @selector(repeat), 
		      @selector(shuffle),
		      @selector(noplaylist_advance), 
		      @selector(player_visible),
		      @selector(playlist_visible),
		      @selector(equalizer_visible) 
    };

    if ( [menuItem tag] == 101 ) {
      [menuItem setState:[Input isPlaying]];
      NSLog(@"fjsdfd");
    } else if ( [menuItem tag] > 0 && [menuItem tag] < 7 )
      [menuItem setState:(int)[cfg performSelector:options[[menuItem tag]]]];
      
  } else if ( val != -1 && val == [menuItem tag] )
    [menuItem setState:1];

  return YES;
}

- (void)set_menustate:mitem value:(int)val tagMin:(int)min tagMax:(int)max
{
  NSMenu *menu = [mitem submenu];
  NSArray *items = [menu itemArray];
  NSMenuItem *item;
  int i;
  
  for ( i = 0; i < [items count]; i++ ) {
    item = [items objectAtIndex:i];
    if ( min == -1 || ([item tag] >= min && [item tag] <= max) ) {
      [item setState:[item tag] == val];
    }
  }
}

- (void)update_states:sender tagMin:(int)min tagMax:(int)max
{
  NSMenu *menu = [sender menu];
  NSArray *items = [menu itemArray];
  NSMenuItem *item;
  int i;
  
  for ( i = 0; i < [items count]; i++ ) {
    item = [items objectAtIndex:i];
    if ( min == -1 || ([item tag] >= min && [item tag] <= max) )
      [item setState:0];
  }
  [sender setState:1];
}

- (void)vis_type:sender
{
  [cfg setvis_type:[sender tag]];
  [self update_states:sender tagMin:VIS_ANALYZER tagMax:VIS_OFF];
  [[self mainView] vis_clear];  
  [[self mainView] svis_clear];
}
  
- (void)analyzer_mode:sender
{
  [cfg setanalyzer_mode:[sender tag]];
  [self update_states:sender tagMin:ANALYZER_NORMAL tagMax:ANALYZER_VLINES];
}

- (void)analyzer_type:sender
{
  [cfg setanalyzer_type:[sender tag]-ANALYZER_VLINES-1];
  [self update_states:sender tagMin:ANALYZER_VLINES+ANALYZER_LINES 
			     tagMax:ANALYZER_VLINES+ANALYZER_BARS];
}

- (void)analyzer_peaks:sender
{
  [cfg setanalyzer_peaks:![sender state]];
  [sender setState:![sender state]];
}

- (void)scope_mode:sender
{
  [cfg setscope_mode:[sender tag]];
  [self update_states:sender tagMin:-1 tagMax:-1];
}

- (void)vu_mode:sender
{
  [cfg setvu_mode:[sender tag]];
  [self update_states:sender tagMin:-1 tagMax:-1];
}

- (void)refresh_rate:sender
{
  [cfg setvis_refresh:[sender tag]];
  [self update_states:sender tagMin:-1 tagMax:-1];
}

- (void)analyzer_falloff:sender
{
  [cfg setanalyzer_falloff:[sender tag]];
  [self update_states:sender tagMin:-1 tagMax:-1];
}

- (void)peaks_falloff:sender
{
  [cfg setpeaks_falloff:[sender tag]];
  [self update_states:sender tagMin:-1 tagMax:-1];
}

- (void)about:sender
{
  [aboutText setStringValue:[NSString stringWithFormat:@"%@ %@", PACKAGE, 
			      VERSION]];
  [aboutPanel makeKeyAndOrderFront:sender];
}

- (void)eject_pressed:sender
{
  [self openFilePanel:self];
}

- (void)play_pressed:sender
{
  if ( [Input isPlaying] && [Input isPaused] )
    [Input pause];
  else {
    if ( [Playlist count] )
      [[self playlistView] play];
    else
      [self eject_pressed:self];
  }
}

- (void)stop_pressed:sender
{
  [Input stop];
}

- (void)pause_pressed:sender
{
  [Input pause];
}

- (void)fwd_pressed:sender
{
  [[self playlistView] forward];
}

- (void)prev_pressed:sender
{
  [[self playlistView] prev];
}

- (void)shuffle_pressed:sender
{
  [cfg setshuffle:[sender state]];
  [Playlist setShuffle:[sender state]];
}

- (void)repeat_pressed:sender
{
  [cfg setrepeat:[sender state]];
}

- (void)toggle_repeat:sender
{
  BOOL repeat = ![cfg repeat];
  [[self mainView]->repeat toggle:repeat];
  [cfg setrepeat:repeat];
}

- (void)toggle_shuffle:sender
{
  BOOL shuff = ![cfg shuffle];
  [[self mainView]->shuffle toggle:shuff];
  [cfg setshuffle:shuff];
}

- (void)toggle_noplaylist_advance:sender
{
  [cfg setnoplaylist_advance:![cfg noplaylist_advance]];
}

- (void)showFileInfoBox:sender
{
  if ( [Input playingFile] )
    [Input fileInfoBox:[Input playingFile]];
}


- (void)visTimer:nothing
{
  int time, x;
  unsigned char *vis_data;
  static int vis_offset=0,vis_delta=1,prev_type=-1,vis_sync_vu = 0,
    vis_sync_delta = 1;

  if( [Input isPlaying]) {
    time = [Input getTime];
    if ( time != -1 ) {
      if ( [cfg vis_type] != VIS_OFF ) {
	if ( vis_data = [Input getVis:time] ) {
	  if([cfg player_shaded] && [cfg player_visible])
	    [[self mainView] svis_timeout:vis_data];
	  else if ( [cfg player_visible] )
	    [[self mainView] vis_timeout:vis_data];
	  else if ( [cfg playlist_visible] )
	    [[self playlistView] vis_timeout:vis_data];
	  free(vis_data);
	  prev_type=[Input getVisType];
	} else if (prev_type != [Input getVisType] && prev_type != -1) {
	  vis_data=malloc(75);
	  memset(vis_data, 0, 75);
	  switch([cfg vis_type]) {
	  case	VIS_ANALYZER:
	    if([cfg player_shaded] && [cfg player_visible]) {
	      vis_data[0] = vis_data[1] = vis_sync_vu;
	      vis_sync_vu += vis_sync_delta;
	      if(vis_sync_vu == 0)
		vis_sync_delta = 1;
	      else if(vis_sync_vu == 37)
		vis_sync_delta = -1;
	    } else {
	      vis_data[vis_offset]=15;
	      vis_offset+=vis_delta;
	      if(vis_offset==0)
		vis_delta=1;
	      else if(vis_offset==74)
		vis_delta=-1;
	      
	      
	    }
	    break;
	  case	VIS_SCOPE:
	    for(x=0;x<75;x++)
	      vis_data[x]=(int)((sin((x+vis_offset)*((2*M_PI)/75.0))*6.0)+6.0);
	    vis_offset++;
	    if(vis_offset==75)
	      vis_offset=0;
	    break;
	  case VIS_OFF:
	    break;
	  }
	  if([cfg player_shaded] && [cfg player_visible])
	    [[self mainView] svis_timeout:vis_data];
	  else if ( [cfg player_visible] )
	    [[self mainView] vis_timeout:vis_data];
	  else if ( [cfg playlist_visible] )
	    [[self playlistView] vis_timeout:vis_data];
	}
      }
      else
	prev_type = INPUT_VIS_OFF;
    }
  }
}

- (void)timeTimer:nothing
{
  int time, length, t;
  char stime_prefix;	
  PlaylistView *pl = [self playlistView];
  MainView *mv = [self mainView];
  int minusn;

  if ( [Input isPlaying] ) {
    time = [Input getTime];
    if ( time != -1 ) {
      length = [pl currentLength];
      [pl setTime:time length:length];

      if ( [cfg timer_mode] == TIMER_REMAINING ) {
	if ( length != -1 ) {
	  minusn = 11;
	  t = length - time;
	  stime_prefix = '-';
	} else {
	  minusn = 10;
	  t = time;
	  stime_prefix = ' ';
	}
      } else {
	minusn = 10;
	t=time;
	stime_prefix = ' ';
      }
      t/=1000;
      [mv setNumbers:minusn :t/600 :(t/60)%10 :(t/10)%6 :t%10];
      
      [mv setSNumbers:[NSString stringWithFormat:@"%c%2.2d", stime_prefix, t/60]
	             :[NSString stringWithFormat:@"%2.2d",t%60]];

      time /= 1000;
      length /= 1000;
      if ( length > 0 )	{
	if (time > length) {
	  [mv setPosbar:219];
	  [mv setSposbar:13];
	} else {
	  [mv setPosbar:(time*219)/length];
	  [mv setSposbar:((time*12)/length)+1];
	}
      } else {
	[mv setPosbar:0];
	[mv setPosbar:1];
      }
    }
#if 0
    {
      int l, r;
      [Input getVolumeLeft:&l right:&r];
    }
#endif

  }
}

@end



