#include <stdlib.h>
#include <string.h>
#include <ar.h>
#include <mach-o/loader.h>
#include <stuff/bytesex.h>
#include <stuff/round.h>

/*
 * get_toc_byte_sex() guesses the byte sex of the table of contents of the
 * library mapped in at the address, addr, of size, size based on the first
 * object file's bytesex.  If it can't figure it out, because the library has
 * no object file members or is malformed it will return UNKNOWN_BYTE_SEX.
 */
__private_extern__
enum byte_sex
get_toc_byte_sex(
char *addr,
unsigned long size)
{
     unsigned long magic;
     struct ar_hdr *ar_hdr;
     char *p;

	ar_hdr = (struct ar_hdr *)(addr + SARMAG);
	p = addr + SARMAG + sizeof(struct ar_hdr) +
	    round(strtoul(ar_hdr->ar_size, NULL, 10), sizeof(short));
	while(p + sizeof(struct ar_hdr) + sizeof(unsigned long) < addr + size){
	    ar_hdr = (struct ar_hdr *)p;
	    p += sizeof(struct ar_hdr);
	    memcpy(&magic, p, sizeof(unsigned long));
	    if(magic == MH_MAGIC)
		return(get_host_byte_sex());
	    else if(magic == SWAP_LONG(MH_MAGIC))
		return(get_host_byte_sex() == BIG_ENDIAN_BYTE_SEX ?
		       LITTLE_ENDIAN_BYTE_SEX : BIG_ENDIAN_BYTE_SEX);
	    p += round(strtoul(ar_hdr->ar_size, NULL, 10), sizeof(short));
	}
	return(UNKNOWN_BYTE_SEX);
}
