/* 
 * Copyright (c) 1987, 1988 NeXT, Inc.
 */ 

#ifndef	_I860_THREAD_STATE_
#define	_I860_THREAD_STATE_

/*
 * I860_thread_state_regs		this is the structure that is exported
 *					to user threads for use in set/get
 *					status calls.  This structure should
 *					never change.
 */

#define	I860_THREAD_STATE_REGS	(4)	/* normal registers */

struct i860_thread_state_regs {
	int	ireg[31];  /* core registers (incl stack pointer, but not r0) */
	int	freg[30];  /* FPU registers, except f0 and f1 */
	int	psr;	   /* user's processor status register */
	int	epsr;	   /* user's extended processor status register */
	int	db;	   /* user's data breakpoint register */
	int	pc;	   /* user's program counter */
	int	_padding_; /* not used */
	/* Pipeline state for FPU */
	double	Mres3;
	double	Ares3;
	double	Mres2;
	double	Ares2;
	double	Mres1;
	double	Ares1;
	double	Ires1;
	double	Lres3m;
	double	Lres2m;
	double	Lres1m;
	double	KR;
	double	KI;
	double	T;
	int	Fsr3;
	int 	Fsr2;
	int	Fsr1;
	int	Mergelo32;
	int	Mergehi32;
};

#define	I860_THREAD_STATE_REGS_COUNT \
	(sizeof (struct i860_thread_state_regs) / sizeof (int))

#endif	_I860_THREAD_STATE_
