/* MartinView
   Ported to FreeSpace for Mac OS X Server
      by Jeff Sickel, Sehjas, Inc.	04-Sep-1999
 */

#import <AppKit/AppKit.h>

#define Martin1	0
#define Martin2	1
#define Ejk1	2
#define Ejk2	3
#define Nfunc	4    // The number of functions supported

#ifndef Min
#define Min(x,y) ((x < y)?x:y)
#define Max(x,y) ((x > y)?x:y)
#endif

#define Ranf() (double)((Ranfseed=(Ranfseed*1629+1)%1048576)/1048576.)
#define Ranfset(l) (Ranfseed=(((abs(l)%1048576)*1629)+1)%1048576)

#define	DEFAULTNUMCOLORS	14

#define	MAXDYNAMPOINTS 		900   
#define	STARTDYNAMPOINTS	400

@interface MartinView:NSView
{
    int numPixels;		// number of pixels in buffer to be displayed
    NSRect *pixels;
    NSString	*file;		// The file used to store remembered fractals
    NSColor *colors[DEFAULTNUMCOLORS];
    NSColor *currColor;
    id  myPrefPanel;		// Preferences Panel
    id  sharedInspectorPanel;	// Dummy inspector that shows up in the standard settings panel
    id	maxTotalPts;
    id	maxTotFlag;
    id	maxInRangePts;
    id	maxInFlag;
    id	dynamFlush;
    id	hopAField;
    id	hopBField;
    id	hopCField;
    id	seedPertInt;
    id	seedIntFlag;
    id	seedPertVal;
    id	seedValFlag;
    id	magField;
    id	magFlag;
    id	colInterval;
    id	colFlag;
    id	randomFlag;
    id	funcAuto;
    id	funcButton;
    id	colorButton;
    id	aFlag;
    id	bFlag;
    id	cFlag;
    id	a1Flag;
    id	b1Flag;
    id	c1Flag;
    id	afFlag;
    id	bfFlag;
    id	cfFlag;
    id	useFileFlag;
    id displaceX;
    id displaceY;

    int		Ncolors, Function;
    int		mxp, np;		/* max in-range points, in-range points    */
    int		mxP, nP;		/* max total points,    total points       */
    int		nC, nc;			/* color-change interval (points)          */
    int		nD, nd;			/* dynam flush buffer interval (points)    */
    int		Pn, pn;			/* seed perturbation interval (points)     */
    double	Pv;			/* seed perturbation value                 */
    double	A, B, C;		/* hopalong parameters                     */
    int		Color;			/* non-zero if color                       */
    BOOL	Randomcolor;		/* randomized color sequences		   */
    double	Zf;			/* magnification factor                    */
    int 	cx, cy, ix, iy, mxX, mxY, W, H, moveX, moveY, color;
    double	 x, y, x1;
    long	Ranfseed;    	
    int		isPaused;
}

+ (void)initialize;

- (id)initWithFrame:(NSRect)frameRect;
- (id)initWithFrame:(NSRect)frameRect loadInspectorPanel:(BOOL)loadPanel;
// - sizeTo:(float)width :(float)height;
- (void)drawRect:(NSRect)rect;
- (void)windowWillMiniaturize:(NSNotification *)notification;

/* Inherited from BackView */
- (NSView *)inspector:(id)sender;
- (void)inspectorWillBeRemoved;
- (void)oneStep;
- (BOOL)useBufferedWindow;
- (void)didLockFocus;

/* Inspector panel methods */
- (void)pause:(id)sender;
- (void)useFile:(id)sender;
- (void)remember:(id)sender;
- (void)setHopA:(id)sender;
- (void)setHopB:(id)sender;
- (void)setHopC:(id)sender;
- (void)setMagnification:(id)sender;
- (void)setSeedInt:(id)sender;
- (void)setSeedVal:(id)sender;
- (void)setColChange:(id)sender;
- (void)setRandomColor:(id)sender;
- (void)setMaxTot:(id)sender;
- (void)setMaxIn:(id)sender;
- (void)setDisplacement:(id)sender;
- (void)changeColorMode:(id)sender;
- (void)convertColors;
- (void)changeFunc:(id)sender;
- (void)changeDynam:(id)sender;
- (void)makeNewDynam:(int)num;
- (void)newOne:(id)sender;

@end

@interface StaticMartinView : MartinView
@end
