#include "dbench.h"


static struct timeval tp1,tp2;

void start_timer(void)
{
	gettimeofday(&tp1,NULL);
}

double end_timer(void)
{
	gettimeofday(&tp2,NULL);
	return((tp2.tv_sec - tp1.tv_sec) + 
	       (tp2.tv_usec - tp1.tv_usec)*1.0e-6);
}


/* return a pointer to a anonymous shared memory segment of size "size"
   which will persist across fork() but will disappear when all processes
   exit 

   The memory is not zeroed 

   This function uses system5 shared memory. It takes advantage of a property
   that the memory is not destroyed if it is attached when the id is removed
   */
void *shm_setup(int size)
{
#ifndef USE_MACH_VM_INHERIT
    void *ret;
	int shmid;

	shmid = shmget(IPC_PRIVATE, size, SHM_R | SHM_W);
	if (shmid == -1) {
		printf("can't get shared memory\n");
		exit(1);
	}
	ret = (void *)shmat(shmid, 0, 0);
	if (!ret || ret == (void *)-1) {
		printf("can't attach to shared memory\n");
		return NULL;
	}
	/* the following releases the ipc, but note that this process
	   and all its children will still have access to the memory, its
	   just that the shmid is no longer valid for other shm calls. This
	   means we don't leave behind lots of shm segments after we exit 

	   See Stevens "advanced programming in unix env" for details
	   */
	shmctl(shmid, IPC_RMID, 0);
	
	return ret;
#else
        kern_return_t	status;
        vm_address_t	new_memory;

        status = vm_allocate( task_self(), &new_memory, size, 1 );

        if( status != KERN_SUCCESS ) {
            printf( "can't vm_allocate memory for sharing\n" );
            exit( 1 );
        }

        status = vm_inherit( task_self(), new_memory, size, VM_INHERIT_SHARE );
        if( status != KERN_SUCCESS ) {
            printf( "couldn't share the memory\n" );
            exit( 1 );
        }
        return (void *)new_memory;
#endif
        
}

void strupper(char *s)
{
	while (*s) {
		*s = toupper(*s);
		s++;
	}
}


/****************************************************************************
similar to string_sub() but allows for any character to be substituted. 
Use with caution!
****************************************************************************/
void all_string_sub(char *s,const char *pattern,const char *insert)
{
	char *p;
	size_t ls,lp,li;

	if (!insert || !pattern || !s) return;

	ls = strlen(s);
	lp = strlen(pattern);
	li = strlen(insert);

	if (!*pattern) return;
	
	while (lp <= ls && (p = strstr(s,pattern))) {
		memmove(p+li,p+lp,ls + 1 - (((int)(p-s)) + lp));
		memcpy(p, insert, li);
		s = p + li;
		ls += (li-lp);
	}
}
