/*
 * nipoppassd.c v1.0
 *
 *	A POPmail change password server for Mac OS X Server runnning NetInfo.
 *
 *	Keith A. Gillette
 *	Texas Animal Health Commission
 *	gillette@tahc.state.tx.us
 *
 *	Created on 1999.05.21 by Keith A. Gillette <gillette@tahc.state.tx.us>
 *	Updated on 1999.05.27 by Keith A. Gillette <gillette@tahc.state.tx.us>
 *
 *	Hacked together from poppassd.c
 *		<ftp://ftp.eudora.com/eudora/servers/unix/password/pwserve-4>
 *		by John Norstad <j-norstad@nwu.edu> based on earlier versions
 *		by Roy Smith <roy@nyu.edu> and Daniel L. Leavitt <dll.mitre.org>
 *	and the original poppassd.c
 *		<ftp://ftp.eudora.com/eudora/servers/unix/password/pwserve-1>
 *		by Daniel L. Leavitt <dll.mitre.org>
 *
 *	WARNING AND DISCLAIMER
 *
 *	Unlike the venerable individuals credited above, I am not a programmer.
 *	This program works but it is an ugly hack and probably a security hole.
 *	Use it at your own risk!
 *
 *	INSTALLATION AND USE
 *
 *	The binary should be owned by root, and executable only by root.
 *	Put it somewhere that makes sense, like /usr/local/bin
 *
 *	Start it with an entry in /etc/inetd.conf such as the following:
 *
 * 	poppassd stream tcp nowait root /usr/local/bin/poppassd poppassd
 *
 *	and in /etc/services
 *
 *	poppassd	106/tcp
 *
 *	Of course /etc/services is not consulted if NetInfo is running
 *	Execute these command lines to update NetInfo properly
 *
 *	/usr/bin/niutil -create . /services/poppassd
 *      /usr/bin/niutil -createprop . /services/poppassd port 106
 *      /usr/bin/niutil -createprop . /services/poppassd protocol tcp
 *
 *	nipoppassd logs to the local2 facility.
 *	Put an entry in /etc/syslog.conf like the following:
 *
 *	poppassd	/var/log/poppassd
 *
 */


/* Steve Dorner's description of the simple protocol:
 *
 * The server's responses should be like an FTP server's responses;
 * 1xx for in progress, 2xx for success, 3xx for more information
 * needed, 4xx for temporary failure, and 5xx for permanent failure.
 * Putting it all together, here's a sample conversation:
 *
 *   S: 200 hello\r\n
 *   E: user yourloginname\r\n
 *   S: 300 please send your password now\r\n
 *   E: pass yourcurrentpassword\r\n
 *   S: 200 My, that was tasty\r\n
 *   E: newpass yournewpassword\r\n
 *   S: 200 Happy to oblige\r\n
 *   E: quit\r\n
 *   S: 200 Bye-bye\r\n
 *   S: <closes connection>
 *   E: <closes connection>
 */


// required libraries
#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <signal.h>
#include <unistd.h>
#include <varargs.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/file.h>
#include <time.h>
#include <syslog.h>

char *encryptPass (char *newPass);	// prototype one troublesome function to prevent compiler warnings

#define VERSION "nipoppassd 1.0"	// version string
#define NIPATH	"/users/"		// location of user directories in NetInfo
#define NIUTILPATH "/usr/bin/niutil"	// location of niutil binary
#define NIFINDPATH "/usr/bin/nifind"	// location of nifind binary
#define MINPASSLEN 6			// minimum password length
#define FI_NULL ((FILE *) NULL)		// NULL file pointer
#define TI_NULL ((time_t *) NULL)	// NULL time pointer
#define SUCCESS 1			// yay!
#define FAILURE 0			// bummer
#define BUFSIZE 512			// default string size


int main (int argc, const char *argv[])
{
    
	char line[BUFSIZE];		// temporary string for reading a line of input
	char user[BUFSIZE];		// username
	char oldPass[BUFSIZE];		// user's current password
	char newPass[BUFSIZE];		// user's requested new password
	struct passwd *pw, *getpwnam();	// password structure for authenticating user

	*user = *oldPass = *newPass = 0;

	openlog ("poppassd", LOG_PID, LOG_LOCAL2);

	WriteToClient ("200 %s. Hello, who are you?", VERSION);
	ReadFromClient (line);
	sscanf (line, "user %s", user) ;
	if (strlen (user) == 0)
	{
		WriteToClient ("500 Username required. Start over!");
		exit(1);
	}

	WriteToClient ("200 Your password please.");
	ReadFromClient (line);
	sscanf (line, "pass %s", oldPass);
	if (strlen (oldPass) == 0)
	{
		WriteToClient ("500 Password required. Start over!");
		exit(1);
	}
        
	if ((pw = getpwnam (user)) == NULL)
	{
		WriteToClient ("500 Unknown user, %s. Start over!", user);
		exit(1);
	}

	if (checkOldPass (user, oldPass, pw) == FAILURE)
	{
		WriteToClient ("500 Current password incorrect. Start over!");
		exit(1);
	}

	WriteToClient ("200 Your new password please.");
	ReadFromClient (line);
	sscanf (line, "newpass %s", newPass);
        
	if (checkNewPass (oldPass, newPass) == FAILURE)
	{
		exit(1);
 	}

        if (changePass (user, oldPass, encryptPass (newPass)) == FAILURE)
        {
            	WriteToClient ("500 NetInfo error. Password not changed.");
		exit(1);
 	}

	WriteToClient ("200 Password changed successfully. Thank you!");
	syslog (LOG_ERR, "password changed for %s", user);

	ReadFromClient (line);
	if (strncmp(line, "quit", 4) != 0) {
		WriteToClient("500 Quit expected, but I'll let it go.");
		exit (1);
	}
	  
	WriteToClient("200 Bye.");
        
   exit(0);       // insure the process exit status is 0
   return 0;      // ...and make main fit the ANSI spec.
}


int checkOldPass (char *user, char *pass, struct passwd *pw)
{
     //  Compare the supplied password with the system password
     if (strcmp (crypt (pass, pw->pw_passwd), pw->pw_passwd) != 0)
          return (FAILURE);
     else
          return (SUCCESS);
}


int checkNewPass (char *oldPass, char *newPass)
{
	if (strlen (newPass) < MINPASSLEN)
	{
		WriteToClient ("500 Password must be at least %d characters.", MINPASSLEN);
		return (FAILURE);
	}
	if (strcmp (oldPass, newPass) == 0)
	{
		WriteToClient ("500 Can't re-use same password.");
		return (FAILURE);
	}
	if (strpbrk (newPass, "01234567890`~!@#$%^&*()-_=+[]{}\\|;:'\",.<>/?") == NULL)
	{
		WriteToClient ("500 Password must contain non-alphabetic characters.");
		return (FAILURE);
	}

    return (SUCCESS);	// password passes minimum tests for lameness
}


void makesalt (char c[2])
{
        register long salt;             // used to compute a salt
        register int i;                 // counter in a for loop

	// just mix a few things up for the salt ...  no rhyme or reason here
        salt = (((long) time(TI_NULL))&0x3f) | (getpid() << 5);

	// use the bottom 12 bits and map them into the legal alphabet
        for(i = 0; i < 2; i++){
                c[i] = (salt & 0x3f) + '.';
                if (c[i] > '9')
                        c[i] += 7;
                if (c[i] > 'Z')
                        c[i] += 6;
                salt >>= 6;
        }
}


char *encryptPass (char *newPass)
{
        char saltc[2];          // the password's salt

        makesalt (saltc);
        return (crypt(newPass, saltc));
}


int changePass (char *user, char *oldPass, char *cryptPass)
{
	char findCmdLine[BUFSIZE] = "";	// string of nifind command and arguments to find proper domain
	char utilCmdLine[BUFSIZE] = "";	// string of niutil command and arguments to change password
        char niDomain[BUFSIZE] = "";	// NetInfo domain in which user's account lives
        char pipeOut[BUFSIZE] = "";	// string holding output of pipes for error detection
	FILE *pPipe;			// pipe to the called NetInfo processes

	sprintf(findCmdLine, "%s -a %s%s", NIFINDPATH, NIPATH, user);	// build the command line

	pPipe = popen(findCmdLine, "r");	// find the domain in which the user's account resides

	fscanf(pPipe,"%s%s%s%s", niDomain, niDomain, niDomain, niDomain);	// domain is in the fourth field
	if (niDomain[0] != '/')
	{
        strcpy (niDomain, ".");	// if nothing is returned, assume the current domain just for kicks
	}
	else
	{
        	niDomain[strlen(niDomain) - 1] = '\0';	// chop off that stupid comma in niutil's output
	}

	pclose(pPipe);

        // build the command line
        sprintf(utilCmdLine, "%s -u %s -P %s -insertval %s %s%s passwd %s 0", NIUTILPATH, user, oldPass, niDomain, NIPATH, user, cryptPass);

	pPipe = popen(utilCmdLine, "r");	// change the encrypted passwd string in the user's NetInfo directory
        pclose(pPipe);

	return SUCCESS;		// can't figure out how to test for failure since I get bus errors testing the return value of popen()
}


WriteToClient (fmt, va_alist)	// can't figure out this declaration, so I'll won't convert it to ANSI C style
char *fmt;
va_dcl
{
        va_list ap;

        va_start (ap);
        vfprintf (stdout, fmt, ap);
        fputs ("\r\n", stdout);
        fflush (stdout);
        va_end (ap);
}


int ReadFromClient (char *line)
{
        char *sp;
        int i;

        strcpy (line, "");
        fgets (line, BUFSIZE, stdin);
        if ((sp = strchr(line, '\n')) != NULL) *sp = '\0';
        if ((sp = strchr(line, '\r')) != NULL) *sp = '\0';

        // convert initial keyword on line to lower case.
       for (sp = line; isalpha(*sp); sp++) *sp = tolower(*sp);

}
