#import "UniverseInspector.h"

@implementation UniverseInspector

- initWithUniverseView:(UniverseView *)uv {
   [super init];
   universeView = uv;
   [NSBundle loadNibNamed:@"UniverseInspector.nib" owner:self];
   [self refresh];

   return self;
}

- (void)refresh {
   [rScaleField setDoubleValue:[universeView rScale]];
   [rScaleSlider setDoubleValue:[universeView rScale]];
   [scaleField setDoubleValue:[universeView scale]];
   [scaleSlider setDoubleValue:[universeView scale]];

   if ([universeView maxSteps] == 0) {
      [maxStepsField setStringValue:@"never"];
   } else {
      [maxStepsField setIntValue:[universeView maxSteps]];
   }
   [maxStepsSlider setIntValue:[universeView maxSteps]];

   [backgroundColorWell setColor:[universeView backgroundColor]];
   [defaultPlanetColorWell setColor:[universeView defaultPlanetColor]];

   [wrapCell setState:([universeView bounce] == NO)];
   [bounceCell setState:([universeView bounce] == YES)];
}

- (void)addPlanets:(id)sender
{
   [universeView addPlanets:[numNewPlanetsField intValue] inColor:[newPlanetColorWell color]];
}

- (void)setRScale:(id)sender
{
   double rScale = [sender doubleValue];
   [universeView setRScale:rScale];
   [self refresh];
}

- (void)setScale:(id)sender
{
   double scale = [sender doubleValue];
   [universeView setScale:scale];
   [self refresh];
}

- (void)setBackgroundColor:(id)sender {
   [universeView setBackgroundColor:[sender color]];
}

- (void)setDefaultPlanetColor:(id)sender {
   [universeView setDefaultPlanetColor:[sender color]];
}

- (void)setMaxSteps:(id)sender {
   [universeView setMaxSteps:[sender intValue]];
   [self refresh];
}


- (void)setBounce:(id)sender {
   int tag = [[sender selectedCell] tag];
   switch (tag) {
      case 0: /* wrap around */
         [universeView setBounce:NO];
         break;
      case 1: /* bounce */
         [universeView setBounce:YES];
         break;
      default:
         break;
   }
}



- (void)show {
   [window makeKeyAndOrderFront:self];
}

@end
