/* Universe.m created by cb on Sun 30-May-1999 */

#import "Universe.h"
#import "Planet.h"
#import "Util.h"

@implementation Universe

- newPlanetWithMass:(double)mass andColor:(NSColor *)color {
   double theta = [Util randomDoubleBetween:0.0 and:2.0*M_PI];
   double r = [Util randomDoubleBetween:0.0 and:1.0];
   double dx = r * cos(theta);
   double dy = r * sin(theta);
   return [[Planet alloc] initAtPosition:NSMakePoint([Util randomDoubleBetween:NSMinX(bounds)
                                                                           and:NSMaxX(bounds)],
                                                     [Util randomDoubleBetween:NSMinY(bounds)
                                                                           and:NSMaxY(bounds)])
                                velocity:NSMakePoint(dx, dy)
                                    mass:mass
                                   color:color];
}

- initWithBounds:(NSRect)b numPlanets:(int)n {
   int i;
   Planet *p;
   NSColor *startColor;
   int startMass;
   double xsum = 0.0, ysum = 0.0;

   [super init];

   bounds = b;
   planets = [[NSMutableArray arrayWithCapacity:n] retain];
   startColor = [Planet startColor];
   startMass = [Planet startMass];
   totalMass = n * startMass;
   bounce = NO;

   for (i = 1; i < n; i++) {
      NSPoint v;
      p = [self newPlanetWithMass:startMass andColor:startColor];
      xsum += (v = [p velocity]).x;
      ysum += v.y;
      [planets addObject:p];
      [p release];
   }

   p = [[Planet alloc] initAtPosition:NSMakePoint([Util randomDoubleBetween:NSMinX(bounds)
                                                                        and:NSMaxX(bounds)],
                                                  [Util randomDoubleBetween:NSMinY(bounds)
                                                                        and:NSMaxY(bounds)])
                             velocity:NSMakePoint(0.0 - xsum,
                                                  0.0 - ysum)
                                 mass:startMass
                                color:startColor];
   [planets addObject:p];
   [p release];

   return self;
}

- (NSRect)bounds {
   return bounds;
}

- (NSMutableArray *)planets {
   return planets;
}

- (void)addPlanet:(Planet *)p {
   [planets addObject:p];
   totalMass += [p mass];
}

- (void)oneStep {
   int i, j;

   for (i = 0; i < [planets count]; i++) {
      Planet *p = (Planet *)[planets objectAtIndex:i];

      [p oneStep];

      for (j = i+1; j < [planets count]; j++) {
         Planet *p2 = [planets objectAtIndex:j];
         NSPoint vector = [p vectorToPlanet:p2];
         double dist = [Util absForVector:vector];
         double d3 = dist * dist * dist;
         int p_mass = [p mass];
         int p2_mass = [p2 mass];
         
         [p addToVelocity:NSMakePoint(vector.x * p2_mass / d3,
                                      vector.y * p2_mass / d3)];
         [p2 addToVelocity:NSMakePoint(-1 * vector.x * p_mass / d3,
                                       -1 * vector.y * p_mass / d3)];

         if (dist < sqrt((double)p_mass) + sqrt((double)p2_mass)) {
            [planets replaceObjectAtIndex:i
                               withObject:(p = [Planet planetByMergingPlanets:p and:p2])];
            [planets removeObjectAtIndex:j];

            if ([p mass] > 0.65 * totalMass ||
                [p mass] > 0.33 * totalMass && [Util randomDoubleBetween:0.0 and:1.0] < 0.15) {
               NSArray *exploded = [p explode];
               int i;
               for (i = 0; i < [exploded count]; i++) {
                  Planet *p = [exploded objectAtIndex:i];
                  if (bounce)
                     [p bounceInside:bounds];
                  else
                     [p wrapInside:bounds];
               }
               [planets addObjectsFromArray:exploded];
            }
         }
      }
      if (bounce)
         [p bounceInside:bounds];
      else
         [p wrapInside:bounds];
   }
}

- (void)dealloc {
   [planets release];
   [super dealloc];
}

- (void)setNumPlanets:(int)n {
   int mass = [Planet startMass];
   int targetMass = n * mass;
   NSColor *color = [Planet startColor];

   while (totalMass > targetMass) {
      int i;
   for (i = [planets count] - 1; i >= 0 && totalMass > targetMass; i--) {
         Planet *p = (Planet *)[planets objectAtIndex:i];
         totalMass -= mass;
         [p setMass:[p mass] - mass];
         if ([p mass] <= 0) {
            [planets removeObjectAtIndex:i];
         }
      }
   }

   while (totalMass < targetMass) {
      [planets addObject:[self newPlanetWithMass:mass andColor:color]];
      totalMass += mass;
   }
}

- (void)setSize:(NSSize)newSize {
   int i;
   double xfac, yfac;
   NSSize oldSize = bounds.size;
   bounds.size = newSize;

   xfac = newSize.width / oldSize.width;
   yfac = newSize.height / oldSize.height;

   for (i = 0; i < [planets count]; i++) {
      Planet *planet = (Planet *)[planets objectAtIndex:i];
      NSPoint p = [planet position];
      p.x *= xfac;
      p.y *= yfac;
      [planet setPosition:p];
   }
}

- (void)setBounce:(BOOL)b {
   bounce = b;
}


@end
