/* Planet.m created by cb on Sun 30-May-1999 */

#import "Planet.h"
#import "Util.h"
#import <math.h>

static NSPoint startPosition;
static NSPoint startVelocity;
static NSColor *startColor;
static double startMass;

@implementation Planet

+ (void)initialize {
   static BOOL initDone = NO;
   if (!initDone) {
      initDone = YES;
      startPosition = NSMakePoint(0.0,0.0);
      startVelocity = NSMakePoint(0.0,0.0);
      startColor = [[NSColor colorWithCalibratedRed:1.0 green:1.0 blue:1.0 alpha:1.0] retain];
      startMass = 1.0;
   }
}

+ (Planet *)planetByMergingPlanets:(Planet *)a and:(Planet *)b {
   NSPoint p1, p2, p, v;
   double m1, m2, m;
   NSColor *c1, *c2, *c;

   m1 = [a mass];
   m2 = [b mass];
   m = m1 + m2;

   p1 = [a position];
   p2 = [b position];
   p = NSMakePoint((p1.x * m1 + p2.x * m2) / m,
                   (p1.y * m1 + p2.y * m2) / m);

   p1 = [a velocity];
   p2 = [b velocity];
   v = NSMakePoint( (p1.x * m1 + p2.x * m2) / m,
                    (p1.y * m1 + p2.y * m2) / m );

   c1 = [[a color] colorUsingColorSpaceName:NSCalibratedRGBColorSpace];
   c2 = [[b color] colorUsingColorSpaceName:NSCalibratedRGBColorSpace];
   c = [NSColor colorWithCalibratedRed:([c1 redComponent] * m1 + [c2 redComponent] * m2) / m
                                 green:([c1 greenComponent] * m1 + [c2 greenComponent] * m2) / m
                                  blue:([c1 blueComponent] * m1 + [c2 blueComponent] * m2) / m
                                 alpha:([c1 alphaComponent] * m1 + [c2 alphaComponent] * m2) / m];

   return [[Planet alloc] initAtPosition:p velocity:v mass:m color:c];
}

+ (NSPoint)startPosition {
   return startPosition;
}

+ (NSPoint)startVelocity {
   return startVelocity;
}

+ (double)startMass {
   return startMass;
}

+ (void)setStartMass:(double)m {
   startMass = m;
}

+ (NSColor *)startColor {
   return startColor;
}

+ (void)setStartColor:(NSColor *)c {
   [startColor autorelease];
   startColor = [c retain];
}

- init {
   Class c = [self class];
   return ([self initAtPosition:[c startPosition]
                       velocity:[c startVelocity]
                           mass:[c startMass]
                          color:[c startColor]]);
}

- initAtPosition:(NSPoint)p velocity:(NSPoint)v mass:(double)m color:(NSColor *)c {
   [super init];
   position = p;
   velocity = v;
   mass = m;
   color = [c retain];
   return self;
}

- (NSPoint)vectorToPlanet:(Planet *)planet {
   NSPoint p2 = [planet position];
   return NSMakePoint(p2.x - position.x,
                      p2.y - position.y);
}

- (void) dealloc {
   [color release];
   [super dealloc];
}


- (NSPoint)position {
   return position;
}

- (void)setPosition:(NSPoint)p {
   position = p;
}

- (NSPoint)velocity {
   return velocity;
}

- (void)setVelocity:(NSPoint)v {
   velocity = v;
}

- (double)mass {
   return mass;
}

- (void)setMass:(double)m {
   mass = m;
}

- (NSColor *)color {
   return color;
}

- (void)setColor:(NSColor *)c {
   [color autorelease];
   color = [c retain];
}


- (NSArray *)explode {
   int i, nNew = (mass / [[self class] startMass]) - 1;
   NSMutableArray *result = [NSMutableArray arrayWithCapacity:nNew];
   double r = nNew * 1.0;

   for (i = 0; i < nNew; i++) {
      double theta = M_PI * 2 * i / (double)nNew;
      double xc = cos(theta), yc = sin(theta);

      NSPoint newPosition = NSMakePoint(position.x + r * xc,
                                        position.y + r * yc);
      NSPoint newVelocity = NSMakePoint(velocity.x + xc * [Util randomDoubleBetween:1.3 and:1.7],
                                        velocity.y + yc * [Util randomDoubleBetween:1.3 and:1.7]);

      [result addObject:[[[self class] alloc] initAtPosition:newPosition
                                                    velocity:newVelocity
                                                        mass:startMass
                                                       color:color]];
      mass -= startMass;
   }

   return result;
}

- (void)oneStep {
   position.x += velocity.x;
   position.y += velocity.y;
}

- (void)addToVelocity:(NSPoint)dv {
   velocity.x += dv.x;
   velocity.y += dv.y;
}

- (void)wrapInside:(NSRect)bounds {
   while (position.x > NSMaxX(bounds))
      position.x -= NSWidth(bounds);
   while(position.x < NSMinX(bounds))
      position.x += NSWidth(bounds);

   while (position.y > NSMaxY(bounds))
      position.y -= NSHeight(bounds);
   while(position.y < NSMinY(bounds))
      position.y += NSHeight(bounds);
}

- (void)bounceInside:(NSRect)bounds {
   double d;
   
   if ((d = position.x - NSMaxX(bounds)) > 0.0) {
      position.x = NSMaxX(bounds) - d;
      velocity.x = -velocity.x;
   }
   if ((d = position.x - NSMinX(bounds)) < 0.0) {
      position.x = NSMinX(bounds) - d;
      velocity.x = -velocity.x;
   }

   if ((d = position.y - NSMaxY(bounds)) > 0.0) {
      position.y = NSMaxY(bounds) - d;
      velocity.y = -velocity.y;
   }
   if ((d = position.y - NSMinY(bounds)) < 0.0) {
      position.y = NSMinY(bounds) - d;
      velocity.y = -velocity.y;
   }
}

@end
