/* Planet.h created by cb on Sun 30-May-1999 */

#import <AppKit/AppKit.h>

@interface Planet : NSObject
{
   NSPoint position;
   NSPoint velocity;
   NSColor *color;
   double mass;
}

+ (void)initialize;
+ (Planet *)planetByMergingPlanets:(Planet *)a and:(Planet *)b;
+ (NSPoint)startPosition;
+ (NSPoint)startVelocity;
+ (double)startMass;
+ (void)setStartMass:(double)m;
+ (NSColor *)startColor;
+ (void)setStartColor:(NSColor *)sc;

- init;
- initAtPosition:(NSPoint)p velocity:(NSPoint)v mass:(double)g color:(NSColor *)c;
- (NSPoint)vectorToPlanet:(Planet *)planet;
- (void) dealloc;

- (NSPoint)position;
- (void)setPosition:(NSPoint)p;

- (NSPoint)velocity;
- (void)setVelocity:(NSPoint)v;

- (double)mass;
- (void)setMass:(double)m;

- (NSColor *)color;
- (void)setColor:(NSColor *)c;

- (NSArray *)explode;

- (void)oneStep;
- (void)addToVelocity:(NSPoint)dv;

- (void)wrapInside:(NSRect)bounds;
- (void)bounceInside:(NSRect)bounds;

@end
