/*
 * Name: my_defines.h
 * Description: This header contains data types, constants and function
 *     prototypes that are needed in the Linux header domain and in the
 *     native header domain. It does not need (and must not need) any
 *     preconditions. It uses only basic C datatypes.
 * Author: Christian Starkjohann <cs@hal.kph.tuwien.ac.at>
 * Date: 1996-11-14
 * Copyright: GNU-GPL
 * Tabsize: 4
 */

extern int				my_fd;
extern int				wr_enable;
extern unsigned long	part_offset;
extern unsigned long	part_size;
extern int				debug_mode;
extern int				use_syslog;
extern char				*device_name;


void	dprintf(const char *format, ...);
void	eprintf(const char *format, ...);
void	fatal_error(const char *format, ...);


#define	DEBUG_BUFFERS	0x01
#define	DEBUG_MISSING	0x02
#define	DEBUG_DUMMIES	0x04
#define	DEBUG_FOPS		0x08
#define	DEBUG_NFS		0x10
#define	DEBUG_NFS_NOISY	0x20
#define	DEBUG_TRANS		0x40
#define	DEBUG_DISPATCH	0x80
#define	DEBUG_CACHE		0x100

void	buffer_initialize(int use_small_buffer);
void	buffer_invalidate(void);
void	missing_init(void);
void	dummies_init(char *devicename, int hssize, int blksz, int devsize);
void	set_current_ids(int uid, int gid);
void	terminate(int exitcode);
void	fops_regular(void);
void	dummies_regular(void);
void	missing_regular(void);
void	buffer_regular(void);

#define	IDBUF_USR	0
#define	IDBUF_GRP	1

void	load_translationfile(int id, char *name);
void	set_fixed_id(int id, int value);
int		translate_to_disk(int id, int local);
int		translate_to_local(int id, int disk);
int		id_is_fixed(int id);
int		fixed_id(int id);


#define MOUNTED		"/tmp/vmounttab"
#define	MNT_RONLY	1

int		lock_mtab(void);
void	unlock_mtab(void);

void	nfs_program_2();
void	mount_and_dispatch(char *dir, void (*proc)(), void *proot_fh, int bg, char *options);

int		my_mount(char *fsname, int options, void *data, int *root_inode);
int		my_unmount(void);
char	*valid_filesystems(void);

void	my_sync_blocks(void);
void	my_sync_inodes(void);
void	missing_init(void);
void	fops_init(void);
void	my_sync(void);

extern int		nfs_uid;
extern int		nfs_gid;
extern int		*nfs_gids;
extern int		nfs_gidslen;	/* gids in nfs_gids */


#define	MY_NFSERR_ACCES		13
#define	MY_NFSERR_STALE		70

typedef struct my_attributes{
	int		mode;
	int		nlink;
	int		uid;
	int		gid;
	int		size;
	int		blocksize;
	int		blocks;
	int		fileid;
	long	atime;
	long	mtime;
	long	ctime;
	int		rdev;
}my_attr_t;

typedef struct my_direntry {/* layout must be equal to NFS 'struct entry'! */
	int					fh;
	char				*name;
	int					cookie;
	struct my_direntry	*next;
}my_direntry_t;


typedef struct my_statfs{
	long	type;
	long	bsize;
	long	blocks;
	long	bfree;
	long	bavail;
	long	files;
	long	ffree;
}my_statfs_t;

int	fo_create(int *fh, my_attr_t *fa, int dir, char *name, my_attr_t *sa);
int	fo_mkdir(int *fh, my_attr_t *fa, int dir, char *name, my_attr_t *sa);
int	fo_getattr(my_attr_t *fa, int fh);
int	fo_lookup(int *fh, my_attr_t *fa, int dir, char *name);
int	fo_readdir(my_direntry_t **result, int *eof, int max_bytes,
														int dir, int cookie);
int	fo_setattr(my_attr_t *fa, int fh, my_attr_t *sa);
int	fo_remove(int dir, char *name);
int	fo_rmdir(int dir, char *name);
int	fo_rename(int fromdir, char *fromname, int todir, char *toname);
int	fo_statfs(my_statfs_t *fsstat);
int	fo_read(my_attr_t *fa, int *len, char **data, int fh, int offs, int count);
int	fo_write(my_attr_t *fa, int fh, int offset, int count, char *data);
int	fo_link(int from, int dir, char *name);
int	fo_readlink(char **path, int fh);
int	fo_symlink(int fromdir, char *fromname, char *topath, my_attr_t *sa);
