#!/bin/sh

self=`which "$0"`
name=`basename $0`
mypath=`echo $self | sed "s/[/]$name\$//"`
cd "$mypath"
mypath=`pwd`

if [ -d Linux ]; then
	linuxdir=Linux
elif [ -d linux ]; then
	linuxdir=linux
else
	echo "No linux directory found."
	echo "Get the linux kernel source and install it in \"Linux\" or \"linux\""
	exit 1
fi
echo "using linux directory \"$linuxdir\""

echo "Setting up links ..."
rm -f include
rm -f fs
ln -s "$linuxdir/include" .
ln -s "$linuxdir/fs" .
rm -f fs/Makefile
(cd "$linuxdir/fs"; ln -s ../../fs-Makefile Makefile)

echo "Generating autoconf.h in directory my_include/linux ..."
rm -f autoconf.h
echo '/* This file was generated by mklinks.sh from config.make. */' >autoconf.h
echo '/* Do not modify it directly. */' >>autoconf.h
echo >>autoconf.h
awk '/^CONFIG.*/{printf("#define %s\t1\n", $1)}' config.make >>autoconf.h
mv -f autoconf.h my_include/linux

echo "$name ready."