/*
 * Name: dummies.c
 * Description: These functions try to do nothing in the smartest possible way.
 * Author: Christian Starkjohann <cs@hal.kph.tuwien.ac.at>
 * Date: 1996-11-14
 * Copyright: GNU-GPL
 * Tabsize: 4
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>
#include "my_defines.h"


#define	DPRINTF(arg)	if(debug_mode & DEBUG_DUMMIES)	dprintf arg

/* ------------------------------------------------------------------------- */

int				securelevel = 0;
struct timezone	sys_tz;
struct timeval	xtime;		/* should contain current time */
unsigned long volatile	jiffies;
int				event = 0;
void			*chrdev_inode_operations[20] = {NULL};
void			*blkdev_inode_operations[20] = {NULL};
int				read_ahead[256];
int				*hardsect_size[256];
int				*blksize_size[256];
int				*blk_size[256];

/* ------------------------------------------------------------------------- */

static char	*dev_name;

/* ------------------------------------------------------------------------- */

int	printk(char *fmt,int arg1,int arg2, int arg3, int arg4, int arg5, int arg6)
{
	eprintf(fmt, arg1, arg2, arg3, arg4, arg5, arg6);
	return 1;
}

void	panic(char *fmt,int arg1,int arg2, int arg3, int arg4, int arg5, int arg6)
{
	eprintf("linux kernel panic: ");
	fatal_error(fmt, arg1, arg2, arg3, arg4, arg5, arg6);
}

char	*___strtok(char *s1, const char *s2)
{
	return strtok(s1, s2);
}

unsigned long simple_strtoul(const char *s, char **p, unsigned int base)
{
	return strtoul(s, p, base);
}

char	*kdevname(void)
{
	return dev_name;
}

void	refile_buffer(void)
{
}

void	insert_inode_hash(void)
{
}

void	schedule(void)
{
}

void	*kmalloc(long size, int priority)
{
	return malloc(size);
}

void	kfree(void *obj)
{
	free(obj);
}

int		verify_area(void)
{
	return 0; /* verifies readability of arguments */
}

int		register_symtab_from(void)
{
	return 0;
}

void	init_fifo(void)
{
}

void	sleep_on(void)
{
}

void	wake_up(void)
{
}

void	__wait_on_super(void)
{
}

void	__wait_on_buffer(void)
{
}

void	update_vm_cache(void)
{
}

void	file_fsync(void)
{
	fatal_error("** file_fsync() called but not implemented\n");
}

void	dcache_add(void)
{
}

int		dcache_lookup(void)
{
	return 0;
}

int		generate_cluster(void)
{
	return 0;
}

int		down_failed(void)
{
	return 0;
}

int		up_wakeup(void)
{
	return 0;
}

int		inode_change_ok(void)
{
	eprintf("** inode_change_ok() called but not implemented\n");
	return -1;
}

void	inode_setattr(void)
{
	fatal_error("** inode_change_ok() called but not implemented\n");
}

int	check_disk_change(void)
{
	return 0;
}

void	open_namei(void)
{
	fatal_error("** open_namei() called but not implemented\n");
}

void	generic_file_mmap(void)
{
	fatal_error("** generic_file_mmap() called but not implemented\n");
}

void	generic_readpage(void)
{
	fatal_error("** generic_readpage() called but not implemented\n");
}

int		in_group_p(void)
{
	return 1;
}

/* ------------------------------------------------------------------------- */

void	dummies_regular(void)
{
static long	last_seconds;

	gettimeofday(&xtime, &sys_tz);
	if(xtime.tv_sec != last_seconds){
		DPRINTF(("dummies_regular(): executing regulars\n"));
		last_seconds = xtime.tv_sec;
		jiffies += 100;
		fops_regular();
		missing_regular();
		buffer_regular();
	}
}

/* ------------------------------------------------------------------------- */

void	dummies_init(char *devicename, int hssize, int blksz, int devsize)
{
int			i;
static int	my_hardsectsize[256];
static int	my_blk_size[256];
static int	my_devicesize[256];

	gettimeofday(&xtime, &sys_tz);	/* system time */
	dev_name = devicename;
	for(i=0;i<256;i++){
		read_ahead[i] = 10;
		hardsect_size[i] = my_hardsectsize;
		blk_size[i] = my_blk_size;		
		blksize_size[i] = my_devicesize;
		my_hardsectsize[i] = hssize;
		my_blk_size[i] = blksz;
		my_devicesize[i] = devsize/blksz*512;
	}
}

/* ------------------------------------------------------------------------- */
