/* PBLaunchButtons.m created by pekeler on Sun 02-Aug-1998 */

#import "PBLaunchButtons.h"
#import "PBButtonsPreferencesController.h"
#import "PBMakeButtons.h"
#import "PBButtons.h"

#ifdef WIN32
#define INFO_TEXT @"Ctrl-Click = 'po', Alt-Click = 'p *', Shift-Click = prevent Return."
#else /* WIN32 */
#define INFO_TEXT @"Cmd-Click = 'po', Alt-Click = 'p *', Shift-Click = prevent Return."
#endif /* WIN32 */

static PBLaunchButtons	*sharedInstanceGV = nil;

@implementation PBLaunchButtons

+ (id)sharedInstance
{
    if (!sharedInstanceGV)
    {
        sharedInstanceGV = [self new];
    }
    return sharedInstanceGV;
}

- (NSString *)buttonNotificationName
{
    return LAUNCH_BUTTON_NOTIFICATION_NAME;
}

- (void)showInfoInWindow:(NSWindow *)window
{
    id <Launcher_PBButtons>	launcher;

    launcher = [window delegate];
    [launcher showStatus:INFO_TEXT];
}

- (void)buttonAction:(id)sender
{
    id <Launcher_PBButtons>	launcher;
    id <TtyText_PBButtons>	ttyText;
    unsigned int			modifierFlags;
    NSString				*inputText = nil;

    launcher = [[sender window] delegate];
    ttyText = [launcher ttyText];
    inputText = [sender toolTip];
    if ((modifierFlags = [[[sender window] currentEvent] modifierFlags])
        && [inputText hasPrefix:@"p "])
    {
    if ((modifierFlags & NSCommandKeyMask)
        && (modifierFlags & NSAlternateKeyMask))
        {
            inputText = [NSString stringWithFormat:@"po *%@", [inputText substringFromIndex:2]];
        }
        else if (modifierFlags & NSCommandKeyMask)
        {
            inputText = [NSString stringWithFormat:@"po %@", [inputText substringFromIndex:2]];
        }
        else if (modifierFlags & NSAlternateKeyMask)
        {
            inputText = [NSString stringWithFormat:@"p *%@", [inputText substringFromIndex:2]];
        }
        else if (modifierFlags & NSHelpKeyMask)
        {
            [self showInfoInWindow:[sender window]];
            return;
        }
    }
    [ttyText setInputText:inputText];
    if (!(modifierFlags & NSShiftKeyMask))
    {
        [ttyText insertNewline:nil];
    }
}

- (NSString *)instanceVariableNameOfOriginalView
{
    return @"standardButtons";
}

- (void)createButtonsInWindow:(NSWindow *)aWindow
{
    NSArray	*launchButtonDescriptions;

    launchButtonDescriptions = [[PBButtonsPreferencesController sharedInstance] launchButtonDescriptions];
    if (launchButtonDescriptions
        && [launchButtonDescriptions count])
    {
        NSButton				*button;
        NSRect					buttonFrame;
        NSRect					originalToolBarViewFrame;
        id						originalToolBarView = nil;
        id <Launcher_PBButtons>	launcher;
        NSMutableArray			*buttons;
        NSEnumerator			*buttonDescriptionEnum;
        NSDictionary			*buttonDescription;
        NSImage					*image;
        NSView					*contentView;

        contentView = [aWindow contentView];
        buttons = [[[NSMutableArray alloc] init] autorelease];
        launcher = [aWindow delegate];
        originalToolBarView = [self originalViewForWindow:aWindow];
        originalToolBarViewFrame = [originalToolBarView frame];
        buttonFrame = NSMakeRect(originalToolBarViewFrame.origin.x + originalToolBarViewFrame.size.width + 8.0,
                                 originalToolBarViewFrame.origin.y,
                                 originalToolBarViewFrame.size.height,
                                 originalToolBarViewFrame.size.height);
        image = [[[NSImage alloc] initWithContentsOfFile:[[NSBundle bundleForClass:[self class]] pathForImageResource:@"DebugCommands"]] autorelease];
        buttonDescriptionEnum = [launchButtonDescriptions objectEnumerator];
        while (buttonDescription = [buttonDescriptionEnum nextObject])
        {
            button = [[[NSButton alloc] initWithFrame:buttonFrame] autorelease];
            [button setFont:[NSFont fontWithName:@"Helvetica"
                                            size:7]];
            [button setTitleWithMnemonic:[buttonDescription objectForKey:TITLE_KEY]];
            [button setToolTip:[buttonDescription objectForKey:TEXT_KEY]];
            [button setAutoresizingMask:(NSViewMaxXMargin + NSViewMinYMargin)];
            [button setTarget:self];
            [button setRefusesFirstResponder:YES];	// doesnt work when accessed with keyboard shortcut.
            [button setAction:@selector(buttonAction:)];
            [button setImage:image];
            [button setImagePosition:NSImageOverlaps];
            [[button cell] setGradientType:NSGradientConcaveStrong];
            [button setEnabled:NO];
            [contentView addSubview:button];
            [buttons addObject:button];
            buttonFrame.origin.x += buttonFrame.size.width;
        }
        [self showInfoInWindow:aWindow];
        [buttonsPerWindow setObject:buttons
                             forKey:[NSValue valueWithPointer:contentView]];
    }
}

- (NSString *)centralPBClassName
{
    return @"Launcher";
}

@end
