/* PBButtonsPreferencesController.m created by pekeler on Sun 02-Aug-1998 */

#import "PBButtonsPreferencesController.h"
#import "PBButtons.h"
#import "PBLaunchButtons.h"
#import "PBMakeButtons.h"

#define DEFAULTS_NAME			@"PBButtons"
#define LAUNCH_BUTTONS_KEY		@"LaunchButtons"
#define MAKE_BUTTONS_KEY		@"MakeButtons"

static PBButtonsPreferencesController *sharedInstanceGv = nil;


@implementation PBButtonsPreferencesController

- (void)addMenuItemToApplication
{
    id superMI		= nil;
    id bundlesMI	= nil;

    superMI = [[NSApp mainMenu] itemWithTitle:@"Edit"];		// Use @"Info" for OPENSTEP
    if ([superMI hasSubmenu] && [superMI target])
    {
        bundlesMI = [[superMI target] addItemWithTitle:@"PBButtons Preferences..."
                                                action:@selector(openWindow)
                                         keyEquivalent:@""];
        if (bundlesMI)
        {
            [bundlesMI setEnabled:YES];
            [bundlesMI setTarget:self];
        }
    }
}

+ (void)initialize
{
    id sharedInstance = [self sharedInstance];
    [sharedInstance addMenuItemToApplication];
}


+ (void)registerDefaults
{
    NSString		*path;
    NSDictionary	*defaultDefaultsDictionary;
    static BOOL		doneThis = NO;

    if (!doneThis)
    {
        doneThis = YES;
        path = [[NSBundle bundleForClass:[self class]] pathForResource:@"PBButtonDefaults"
                                                                ofType:@"plist"];
        NSAssert(path, @"Failed to find 'PBButtonDefaults.plist'");
        defaultDefaultsDictionary = [[NSString stringWithContentsOfFile:path] propertyList];
        [[NSUserDefaults standardUserDefaults] registerDefaults:defaultDefaultsDictionary];
    }
}

+ (id)sharedInstance
{
    if (!sharedInstanceGv)
    {
        sharedInstanceGv = [[self alloc] init];
    }
    return sharedInstanceGv;    
}

- (void)loadNIB
{
    [NSBundle loadNibNamed:@"Preferences"
                     owner:self];
}

- (void)awakeFromNib
{
    // [NSApp registerPreferenceController:self]; doesn't work with PB up to now
}

- (void)openWindow
{
    if(windowWI == nil)
    {
        [self loadNIB];
    }
    [windowWI makeKeyAndOrderFront:self];
    [self tableViewSelectionDidChange:nil];
}

- (NSString *)viewName
{
    return @"PBButtons";
}

- (NSArray *)launchButtonDescriptions
{
    return [[NSUserDefaults standardUserDefaults] objectForKey:LAUNCH_BUTTONS_KEY];
}

- (NSArray *)makeButtonDescriptions
{
    return [[NSUserDefaults standardUserDefaults] objectForKey:MAKE_BUTTONS_KEY];
}

- (NSString *)currentButtonTypeName
{
    if ([[panelPU titleOfSelectedItem] hasPrefix:@"Launch"])
    {
        return LAUNCH_BUTTONS_KEY;
    }
    else
    {
        return MAKE_BUTTONS_KEY;
    }
}

- (NSArray *)currentButtonDescriptions
{
    if ([[self currentButtonTypeName] isEqualToString:LAUNCH_BUTTONS_KEY])
    {
        return [self launchButtonDescriptions];
    }
    else
    {
        return [self makeButtonDescriptions];
    }
}

- (NSMutableArray *)mutableCurrentButtonDescriptions
{
    return [[[self currentButtonDescriptions] mutableCopy] autorelease];
}

- (BOOL)uiChanged
{
    return uiChanged;
}

- (void)setUIChanged:(BOOL)yn
{
    uiChanged = yn;
}

- (void)setCurrentButtonDescriptions:(NSArray *)newButtonDescriptions
{
    [self setUIChanged:YES];
    [[NSUserDefaults standardUserDefaults] setObject:newButtonDescriptions
                                              forKey:[self currentButtonTypeName]];
}

- (IBAction)selectPanel:(id)sender
{
    [buttonDescriptionTV reloadData];
}

- (IBAction)newButton:(id)sender
{
    NSMutableArray	*mutableCurrentButtonDescriptions;
    NSDictionary	*buttonDescriptionDictionary;

    buttonDescriptionDictionary = [NSDictionary dictionaryWithObjectsAndKeys:
        @"", TITLE_KEY,
        @"", TEXT_KEY,
        nil];
    mutableCurrentButtonDescriptions = [self mutableCurrentButtonDescriptions];
    [mutableCurrentButtonDescriptions addObject:buttonDescriptionDictionary];
    [self setCurrentButtonDescriptions:mutableCurrentButtonDescriptions];
    [buttonDescriptionTV reloadData];
}

- (IBAction)removeButton:(id)sender
{
    NSMutableArray	*mutableCurrentButtonDescriptions;
    NSEnumerator	*selectedRowEnum;
    NSNumber		*selectedRow;
    NSMutableArray	*objectsToRemove;
    int				numberOfSelectedRows;

    numberOfSelectedRows = [buttonDescriptionTV numberOfSelectedRows];
    NSAssert(numberOfSelectedRows, @"");
    mutableCurrentButtonDescriptions = [self mutableCurrentButtonDescriptions];
    objectsToRemove = [NSMutableArray arrayWithCapacity:numberOfSelectedRows];
    selectedRowEnum = [buttonDescriptionTV selectedRowEnumerator];
    while (selectedRow = [selectedRowEnum nextObject])
    {
        [objectsToRemove addObject:[mutableCurrentButtonDescriptions objectAtIndex:[selectedRow intValue]]];
    }
    [mutableCurrentButtonDescriptions removeObjectsInArray:objectsToRemove];
    [self setCurrentButtonDescriptions:mutableCurrentButtonDescriptions];
    [buttonDescriptionTV reloadData];
}

- (int)numberOfRowsInTableView:(NSTableView *)tableView
{
    return [[self currentButtonDescriptions] count];
}

- (id)tableView:(NSTableView *)tableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row
{
    NSDictionary	*buttonDescriptionDictionary;

    buttonDescriptionDictionary = [[self currentButtonDescriptions] objectAtIndex:row];
    return [buttonDescriptionDictionary objectForKey:[tableColumn identifier]];
}

- (void)tableView:(NSTableView *)tableView setObjectValue:(id)object forTableColumn:(NSTableColumn *)tableColumn row:(int)row
{
    NSMutableDictionary	*buttonDescriptionDictionary;
    NSArray				*tableColumns;
    NSMutableArray 		*mutableCurrentButtonDescriptions;

    tableColumns = [tableView tableColumns];
    NSAssert([tableColumns count] == 2, @"");
    buttonDescriptionDictionary = [[[[self currentButtonDescriptions] objectAtIndex:row] mutableCopy] autorelease];
    [buttonDescriptionDictionary setObject:object
                                     forKey:[tableColumn identifier]];
    mutableCurrentButtonDescriptions = [self mutableCurrentButtonDescriptions];
    [mutableCurrentButtonDescriptions replaceObjectAtIndex:row
                                                withObject:buttonDescriptionDictionary];
    [self setCurrentButtonDescriptions:mutableCurrentButtonDescriptions];
}

- (void)tableViewSelectionDidChange:(NSNotification *)notification
{
    [removeBU setEnabled:([buttonDescriptionTV numberOfSelectedRows] != 0)];
}

- (void)windowWillClose:(NSNotification *)notification
{
    if ([self uiChanged])
    {
        [[PBMakeButtons sharedInstance] removeAllButtons];
        [[PBLaunchButtons sharedInstance] removeAllButtons];
        [self setUIChanged:NO];
    }
}

@end
