/* PBButtons.h created by pekeler on Sat 08-Aug-1998 */

#import <AppKit/AppKit.h>

#define TITLE_KEY	@"title"
#define TEXT_KEY	@"text"

#define	MAKE_BUTTON_NOTIFICATION_NAME	@"BuildButtonChangedEnabled"
#define	LAUNCH_BUTTON_NOTIFICATION_NAME	@"ProcessesButtonChangedEnabled"


@protocol TtyText_PBButtons

- (void)setInputText:(NSString *)aText;
- (void)insertNewline:(id)sender;

@end

@protocol Launcher_PBButtons

- (id <TtyText_PBButtons>)ttyText;
- (void)showStatus:(NSString *)aStatus;
- (NSWindow *)window;

@end

@protocol Maker_PBButtons

- (void)switchTarget:(NSPopUpButton *)aPopUpButton;
- (void)build;
- (void)showStatus:(NSString *)aStatus;
- (NSWindow *)window;

@end

@interface PBButtons : NSObject
{
    NSMutableDictionary	*buttonsPerWindow;
}

+ (void)initialize;
- (id)originalViewForWindow:(NSWindow *)aWindow;
- (void)removeAllButtons;

@end
